/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print;

import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSReport;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public abstract class SSPrinter {
    protected ResourceBundle iBundle = SSBundle.getBundle();
    private SSReport iReport = new SSReport();

    public SSPrinter() {
        this.iReport.addParameter("company", SSDB.getInstance().getCurrentCompany().getName());
        this.iReport.addParameter("reportdate", new Date());
        this.iReport.addParameter("lastvoucher", SSVoucherMath.getMaxNumber());
    }

    public void addParameter(String pName, Object pValue) {
        this.iReport.addParameter(pName, pValue);
    }

    public void addParameter(String pName, Object pValue, boolean toString) {
        this.iReport.addParameter(pName, pValue == null ? null : pValue.toString());
    }

    public void addParameter(String pName, Date pDate) {
        DateFormat iFormat = DateFormat.getDateInstance(3);
        this.iReport.addParameter(pName, pDate == null ? pDate : iFormat.format(pDate));
    }

    public void addParameters(Map<String, Object> iParameters) {
        this.iReport.addParameters(iParameters);
    }

    protected void setPageHeader(String pPageHeader) {
        this.iReport.setField(SSReport.ReportField.PAGE_HEADER, pPageHeader);
    }

    protected void setPageFooter(String pPageFooter) {
        this.iReport.setField(SSReport.ReportField.PAGE_FOOTER, pPageFooter);
    }

    protected void setColumnHeader(String pColumnName) {
        this.iReport.setField(SSReport.ReportField.COLUMN_HEADER, pColumnName);
    }

    protected void setColumnFooter(String pColumnName) {
        this.iReport.setField(SSReport.ReportField.COLUMN_FOOTER, pColumnName);
    }

    protected void setDetail(String pDetailName) {
        this.iReport.setField(SSReport.ReportField.DETAIL, pDetailName);
    }

    protected void setSummary(String pSummaryName) {
        this.iReport.setField(SSReport.ReportField.SUMMARY, pSummaryName);
    }

    protected void setBackground(String pBackgroundName) {
        this.iReport.setField(SSReport.ReportField.BACKGROUND, pBackgroundName);
    }

    protected void setLastPageFooter(String pLastPageFootername) {
        this.iReport.setField(SSReport.ReportField.LAST_PAGE_FOOTER, pLastPageFootername);
    }

    protected void setMargins(Insets pMargins) {
        this.iReport.setMargins(pMargins);
    }

    public void setColumnCount(int iColumnCount) {
        this.iReport.setColumnCount(iColumnCount);
    }

    public void setColumnSpacing(int iColumnSpacing) {
        this.iReport.setColumnSpacing(iColumnSpacing);
    }

    public void setColumnWidth(int iColumnWidth) {
        this.iReport.setColumnWidth(iColumnWidth);
    }

    protected void setMargins(int top, int left, int bottom, int right) {
        this.iReport.setMargins(new Insets(top, left, bottom, right));
    }

    protected void setSize(int width, int height) {
        this.iReport.setSize(new Point(width, height));
    }

    public void setBundle(ResourceBundle iBundle) {
        this.iBundle = iBundle;
        this.addParameter("REPORT_RESOURCE_BUNDLE", iBundle);
    }

    public ResourceBundle getBundle() {
        return this.iBundle;
    }

    public void setLocale(Locale iLocale) {
        this.addParameter("REPORT_LOCALE", iLocale);
    }

    public abstract String getTitle();

    protected abstract SSDefaultTableModel getModel();

    protected String getSubTitle() {
        return null;
    }

    public Map<String, Object> getParameters() {
        return this.iReport.getParameters();
    }

    public void generateReport() {
        this.iReport.addParameter("title", this.getTitle());
        this.iReport.addParameter("subtitle", this.getSubTitle());
        this.iReport.setModel(this.getModel());
        this.iReport.generateReport();
    }

    public void preview() {
        this.iReport.addParameter("title", this.getTitle());
        this.iReport.addParameter("subtitle", this.getSubTitle());
        this.iReport.setModel(this.getModel());
        this.iReport.viewReport();
    }

    public void preview(SSMainFrame iMainFrame) {
        this.iReport.addParameter("title", this.getTitle());
        this.iReport.addParameter("subtitle", this.getSubTitle());
        this.iReport.setModel(this.getModel());
        this.iReport.viewReport(iMainFrame);
    }

    public void preview(JDialog iDialog) {
        this.iReport.addParameter("title", this.getTitle());
        this.iReport.addParameter("subtitle", this.getSubTitle());
        this.iReport.setModel(this.getModel());
        this.iReport.viewReport(iDialog);
    }

    public void preview(SSMainFrame iMainFrame, InternalFrameListener listener) {
        this.iReport.addParameter("title", this.getTitle());
        this.iReport.addParameter("subtitle", this.getSubTitle());
        this.iReport.setModel(this.getModel());
        this.iReport.viewReport(iMainFrame, listener);
    }

    public void preview(SSMainFrame iMainFrame, final ActionListener iCloseListener) {
        this.preview(iMainFrame, new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                ActionEvent iEvent = new ActionEvent(e.getSource(), e.getID(), "close");
                iCloseListener.actionPerformed(iEvent);
                e.getInternalFrame().removeInternalFrameListener(this);
            }
        });
    }

    public JasperPrint getPrinter() {
        return this.iReport.getPrinter();
    }

    public JasperReport getReport() {
        return this.iReport.getReport();
    }

    public SSDefaultJasperDataSource getDataSource() {
        return this.iReport.getDataSource();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.SSPrinter");
        sb.append("{iBundle=").append(this.iBundle);
        sb.append(", iReport=").append(this.iReport);
        sb.append('}');
        return sb.toString();
    }
}

