/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.event.InternalFrameListener;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.view.JasperViewer;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;
import se.swedsoft.bookkeeping.print.util.SSReportCache;
import se.swedsoft.bookkeeping.print.view.SSJasperPreviewFrame;
import se.swedsoft.bookkeeping.util.SSException;

public class SSReport {
    private static SSReportCache cReportCache = SSReportCache.getInstance();
    private JasperPrint iPrinter;
    private JasperReport iReport;
    private Insets iMargins;
    private Point iSize;
    private int iColumnCount;
    private int iColumnSpacing;
    private int iColumnWidth;
    private JasperDesign iDesign;
    private SSDefaultJasperDataSource iDataSource;
    protected Map<String, Object> iParameters;
    protected Map<ReportField, String> iFields;

    public SSReport() {
        System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        this.iDesign = null;
        this.iPrinter = null;
        this.iReport = null;
        this.iDataSource = null;
        this.iMargins = new Insets(30, 20, 30, 20);
        this.iSize = new Point(595, 842);
        this.iColumnCount = 1;
        this.iColumnSpacing = 0;
        this.iColumnWidth = 555;
        this.iParameters = new HashMap<String, Object>();
        this.iFields = new HashMap<ReportField, String>();
    }

    public void setModel(SSDefaultTableModel pModel) {
        this.iDataSource = new SSDefaultJasperDataSource(pModel);
    }

    public void addParameter(String pName, Object pValue) {
        this.iParameters.put(pName, pValue);
    }

    public void addParameters(Map<String, Object> iParameters) {
        iParameters.putAll(iParameters);
    }

    public void setField(ReportField pField, String pName) {
        this.iFields.put(pField, pName);
    }

    protected void setMargins(Insets pMargins) {
        this.iMargins = pMargins;
    }

    public void setSize(Point iSize) {
        this.iSize = iSize;
    }

    public void setColumnCount(int iColumnCount) {
        this.iColumnCount = iColumnCount;
    }

    public void setColumnSpacing(int iColumnSpacing) {
        this.iColumnSpacing = iColumnSpacing;
    }

    public void setColumnWidth(int iColumnWidth) {
        this.iColumnWidth = iColumnWidth;
    }

    public void generateReport() throws SSException {
        if (this.iDesign == null) {
            try {
                this.compileDesign();
            }
            catch (SSException ex) {
                this.iPrinter = this.getEmptyReport();
                throw ex;
            }
        }
        try {
            this.iReport = JasperCompileManager.compileReport(this.iDesign);
            this.iPrinter = JasperFillManager.fillReport(this.iReport, this.iParameters, (JRDataSource)this.iDataSource);
            if (this.iPrinter.getPages().isEmpty()) {
                this.iPrinter = this.getNoPagesReport();
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private void compileDesign() throws SSException {
        LinkedList<JRReportFont> theFonts = new LinkedList<JRReportFont>();
        LinkedList<JRField> theFields = new LinkedList<JRField>();
        LinkedList<JRParameter> theParameters = new LinkedList<JRParameter>();
        LinkedList<JRVariable> theVariables = new LinkedList<JRVariable>();
        LinkedList<JRGroup> theGroups = new LinkedList<JRGroup>();
        JRBand iPageHeader = null;
        if (this.iFields.containsKey((Object)ReportField.PAGE_HEADER)) {
            iPageHeader = this.getField(ReportField.PAGE_HEADER, theFields, theParameters, theVariables, theGroups, theFonts);
        }
        JRBand iPageFooter = null;
        if (this.iFields.containsKey((Object)ReportField.PAGE_FOOTER)) {
            iPageFooter = this.getField(ReportField.PAGE_FOOTER, theFields, theParameters, theVariables, theGroups, theFonts);
        }
        JRBand iColumnHeader = null;
        if (this.iFields.containsKey((Object)ReportField.COLUMN_HEADER)) {
            iColumnHeader = this.getField(ReportField.COLUMN_HEADER, theFields, theParameters, theVariables, theGroups, theFonts);
        }
        JRBand iColumnFooter = null;
        if (this.iFields.containsKey((Object)ReportField.COLUMN_FOOTER)) {
            iColumnFooter = this.getField(ReportField.COLUMN_FOOTER, theFields, theParameters, theVariables, theGroups, theFonts);
        }
        JRBand iDetail = null;
        if (this.iFields.containsKey((Object)ReportField.DETAIL)) {
            iDetail = this.getField(ReportField.DETAIL, theFields, theParameters, theVariables, theGroups, theFonts);
        }
        JRBand iSummary = null;
        if (this.iFields.containsKey((Object)ReportField.SUMMARY)) {
            iSummary = this.getField(ReportField.SUMMARY, theFields, theParameters, theVariables, theGroups, theFonts);
        }
        JRBand iBackground = null;
        if (this.iFields.containsKey((Object)ReportField.BACKGROUND)) {
            iBackground = this.getField(ReportField.BACKGROUND, theFields, theParameters, theVariables, theGroups, theFonts);
        }
        JRBand iLastPageFooter = null;
        if (this.iFields.containsKey((Object)ReportField.LAST_PAGE_FOOTER)) {
            iLastPageFooter = this.getField(ReportField.LAST_PAGE_FOOTER, theFields, theParameters, theVariables, theGroups, theFonts);
        }
        this.iDesign = new JasperDesign();
        this.iDesign.setResourceBundle("book");
        this.iDesign.setName("JasperDocument");
        this.iDesign.setWhenNoDataType((byte)3);
        this.iDesign.setTopMargin(this.iMargins.top);
        this.iDesign.setBottomMargin(this.iMargins.bottom);
        this.iDesign.setLeftMargin(this.iMargins.left);
        this.iDesign.setRightMargin(this.iMargins.right);
        this.iDesign.setPageWidth(this.iSize.x);
        this.iDesign.setPageHeight(this.iSize.y);
        this.iDesign.setColumnCount(this.iColumnCount);
        this.iDesign.setColumnSpacing(this.iColumnSpacing);
        this.iDesign.setColumnWidth(this.iColumnWidth);
        this.iDesign.setPageHeader(iPageHeader);
        this.iDesign.setPageFooter(iPageFooter);
        this.iDesign.setColumnHeader(iColumnHeader);
        this.iDesign.setColumnFooter(iColumnFooter);
        this.iDesign.setDetail(iDetail);
        this.iDesign.setSummary(iSummary);
        this.iDesign.setBackground(iBackground);
        this.iDesign.setLastPageFooter(iLastPageFooter);
        System.out.println("Report:");
        System.out.println("  Height: " + this.iSize.y);
        System.out.println("  Width : " + this.iSize.x);
        System.out.println("Margins:");
        System.out.println("  Top   : " + this.iMargins.top);
        System.out.println("  Bottom: " + this.iMargins.bottom);
        System.out.println("  Left  : " + this.iMargins.left);
        System.out.println("  Right : " + this.iMargins.right);
        System.out.println("Band heights:");
        System.out.println("  PageHeader    : " + (iPageHeader == null ? 0 : iPageHeader.getHeight()));
        System.out.println("  PageFooter    : " + (iPageFooter == null ? 0 : iPageFooter.getHeight()));
        System.out.println("  ColumnHeader  : " + (iColumnHeader == null ? 0 : iColumnHeader.getHeight()));
        System.out.println("  ColumnFooter  : " + (iColumnFooter == null ? 0 : iColumnFooter.getHeight()));
        System.out.println("  Detail        : " + (iDetail == null ? 0 : iDetail.getHeight()));
        System.out.println("  Summary       : " + (iSummary == null ? 0 : iSummary.getHeight()));
        System.out.println("  Background    : " + (iBackground == null ? 0 : iBackground.getHeight()));
        System.out.println("  LastPageFooter: " + (iLastPageFooter == null ? 0 : iLastPageFooter.getHeight()));
        try {
            for (JRReportFont iFont : theFonts) {
                try {
                    this.iDesign.addFont(iFont);
                }
                catch (JRException jRException) {}
            }
            for (JRField iField : theFields) {
                try {
                    this.iDesign.addField(iField);
                }
                catch (JRException jRException) {}
            }
            for (JRParameter iParameter : theParameters) {
                try {
                    this.iDesign.addParameter(iParameter);
                }
                catch (JRException jRException) {}
            }
            for (JRGroup iGroup : theGroups) {
                try {
                    if (this.iDesign.getMainDesignDataset().getGroupsMap().containsKey(iGroup.getName())) continue;
                    this.iDesign.getMainDesignDataset().getGroupsList().add(iGroup);
                    this.iDesign.getMainDesignDataset().getGroupsMap().put(iGroup.getName(), iGroup);
                }
                catch (Exception exception) {}
            }
            for (JRVariable iVariable : theVariables) {
                try {
                    if (this.iDesign.getMainDesignDataset().getVariablesMap().containsKey(iVariable.getName())) continue;
                    this.iDesign.getMainDesignDataset().getVariablesList().add(iVariable);
                    this.iDesign.getMainDesignDataset().getVariablesMap().put(iVariable.getName(), iVariable);
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private JRBand getField(ReportField pField, List<JRField> pFields, List<JRParameter> pParameters, List<JRVariable> pVariables, List<JRGroup> pGroups, List<JRReportFont> pFonts) throws SSException {
        String pReportName = this.iFields.get((Object)pField);
        try {
            JasperReport iReport = cReportCache.getReport(pReportName);
            if (iReport.getParameters() != null) {
                pParameters.addAll(Arrays.asList(iReport.getParameters()));
            }
            if (iReport.getFields() != null) {
                pFields.addAll(Arrays.asList(iReport.getFields()));
            }
            if (iReport.getVariables() != null) {
                pVariables.addAll(Arrays.asList(iReport.getVariables()));
            }
            if (iReport.getGroups() != null) {
                pGroups.addAll(Arrays.asList(iReport.getGroups()));
            }
            if (iReport.getFonts() != null) {
                pFonts.addAll(Arrays.asList(iReport.getFonts()));
            }
            switch (pField) {
                case PAGE_HEADER: {
                    return iReport.getPageHeader();
                }
                case PAGE_FOOTER: {
                    return iReport.getPageFooter();
                }
                case COLUMN_HEADER: {
                    return iReport.getColumnHeader();
                }
                case COLUMN_FOOTER: {
                    return iReport.getColumnFooter();
                }
                case DETAIL: {
                    return iReport.getDetail();
                }
                case SUMMARY: {
                    return iReport.getSummary();
                }
                case BACKGROUND: {
                    return iReport.getBackground();
                }
                case LAST_PAGE_FOOTER: {
                    return iReport.getLastPageFooter();
                }
            }
            return null;
        }
        catch (SSException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private JasperPrint getNoPagesReport() {
        JasperDesign iDesign = new JasperDesign();
        iDesign.setResourceBundle("book");
        iDesign.setName("NoPages");
        iDesign.setWhenNoDataType((byte)3);
        JRDesignBand iTitle = new JRDesignBand();
        iTitle.setHeight(25);
        JRDesignTextField iTextField = new JRDesignTextField();
        iTextField.setX(0);
        iTextField.setY(0);
        iTextField.setWidth(515);
        iTextField.setHeight(25);
        iTextField.setForecolor(new Color(255, 0, 0));
        iTextField.setHorizontalAlignment((byte)1);
        iTextField.setFontSize(12);
        iTextField.setItalic(true);
        JRDesignExpression iEpression = new JRDesignExpression();
        iEpression.setValueClass(String.class);
        iEpression.setText("$R{report.nopages}");
        iTextField.setExpression(iEpression);
        iTitle.addElement(iTextField);
        iDesign.setTitle(iTitle);
        try {
            this.iReport = JasperCompileManager.compileReport(iDesign);
            return JasperFillManager.fillReport(this.iReport, this.iParameters, (JRDataSource)this.iDataSource);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private JasperPrint getEmptyReport() {
        JasperDesign iDesign = new JasperDesign();
        iDesign.setResourceBundle("book");
        iDesign.setName("Empty");
        iDesign.setWhenNoDataType((byte)3);
        try {
            this.iReport = JasperCompileManager.compileReport(iDesign);
            return JasperFillManager.fillReport(this.iReport, this.iParameters, (JRDataSource)this.iDataSource);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public JasperPrint getPrinter() {
        return this.iPrinter;
    }

    public JasperReport getReport() {
        return this.iReport;
    }

    public Map<String, Object> getParameters() {
        return this.iParameters;
    }

    public Object getParameter(String iName) {
        return this.iParameters.get(iName);
    }

    public SSDefaultJasperDataSource getDataSource() {
        return this.iDataSource;
    }

    public void viewReport() {
        try {
            this.generateReport();
        }
        catch (SSException ex) {
            ex.printStackTrace();
        }
        JasperViewer.viewReport(this.iPrinter, false);
    }

    public void viewReport(SSMainFrame iMainFrame) {
        try {
            this.generateReport();
        }
        catch (SSException ex) {
            new SSErrorDialog(iMainFrame, "exceptiondialog", ex.getLocalizedMessage());
        }
        SSJasperPreviewFrame iJasperPreviewFrame = new SSJasperPreviewFrame(iMainFrame, 800, 600);
        iJasperPreviewFrame.setInCenter(iMainFrame);
        iJasperPreviewFrame.setReport(this);
        iJasperPreviewFrame.setPrinter(this.iPrinter);
        iJasperPreviewFrame.setVisible(true);
    }

    public void viewReport(JDialog iDialog) {
        try {
            this.generateReport();
        }
        catch (SSException ex) {
            new SSErrorDialog(SSMainFrame.getInstance(), "exceptiondialog", ex.getLocalizedMessage());
        }
        SSJasperPreviewFrame iJasperPreviewFrame = new SSJasperPreviewFrame(SSMainFrame.getInstance(), 800, 600);
        iJasperPreviewFrame.setInCenter(iDialog);
        iJasperPreviewFrame.setReport(this);
        iJasperPreviewFrame.setPrinter(this.iPrinter);
        iJasperPreviewFrame.setVisible(true);
    }

    public void viewReport(SSMainFrame iMainFrame, InternalFrameListener listener) {
        try {
            this.generateReport();
        }
        catch (SSException ex) {
            new SSErrorDialog(iMainFrame, "exceptiondialog", ex.getLocalizedMessage());
        }
        SSJasperPreviewFrame iJasperPreviewFrame = new SSJasperPreviewFrame(iMainFrame, 800, 600);
        iJasperPreviewFrame.addInternalFrameListener(listener);
        iJasperPreviewFrame.setReport(this);
        iJasperPreviewFrame.setPrinter(this.iPrinter);
        iJasperPreviewFrame.setInCenter(iMainFrame);
        iJasperPreviewFrame.setVisible(true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.SSReport");
        sb.append("{iColumnCount=").append(this.iColumnCount);
        sb.append(", iColumnSpacing=").append(this.iColumnSpacing);
        sb.append(", iColumnWidth=").append(this.iColumnWidth);
        sb.append(", iDataSource=").append(this.iDataSource);
        sb.append(", iDesign=").append(this.iDesign);
        sb.append(", iFields=").append(this.iFields);
        sb.append(", iMargins=").append(this.iMargins);
        sb.append(", iParameters=").append(this.iParameters);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append(", iReport=").append(this.iReport);
        sb.append(", iSize=").append(this.iSize);
        sb.append('}');
        return sb.toString();
    }

    public static enum ReportField {
        PAGE_HEADER,
        PAGE_FOOTER,
        COLUMN_HEADER,
        COLUMN_FOOTER,
        DETAIL,
        SUMMARY,
        BACKGROUND,
        LAST_PAGE_FOOTER;

    }
}

