/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import se.swedsoft.bookkeeping.app.Path;
import se.swedsoft.bookkeeping.calc.SSOCRNumber;
import se.swedsoft.bookkeeping.calc.math.SSAccountMath;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSInpaymentMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSOutpaymentMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.calc.util.SSAutoIncrement;
import se.swedsoft.bookkeeping.calc.util.SSVATUtil;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSIndelivery;
import se.swedsoft.bookkeeping.data.SSInpayment;
import se.swedsoft.bookkeeping.data.SSInventory;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSOutdelivery;
import se.swedsoft.bookkeeping.data.SSOutpayment;
import se.swedsoft.bookkeeping.data.SSOwnReport;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSSupplierCreditInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSTender;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSMail;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInformationDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSProgressDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSWarningDialog;
import se.swedsoft.bookkeeping.gui.voucher.SSVoucherFrame;
import se.swedsoft.bookkeeping.print.SSMultiPrinter;
import se.swedsoft.bookkeeping.print.dialog.SSAccountsPayableDialog;
import se.swedsoft.bookkeeping.print.dialog.SSAccountsrecievableDialog;
import se.swedsoft.bookkeeping.print.dialog.SSCreditInvoiceListDialog;
import se.swedsoft.bookkeeping.print.dialog.SSCustomerclaimDialog;
import se.swedsoft.bookkeeping.print.dialog.SSIndeliveryListDialog;
import se.swedsoft.bookkeeping.print.dialog.SSInpaymentListDialog;
import se.swedsoft.bookkeeping.print.dialog.SSInventoryListDialog;
import se.swedsoft.bookkeeping.print.dialog.SSInvoiceListDialog;
import se.swedsoft.bookkeeping.print.dialog.SSLanguageDialog;
import se.swedsoft.bookkeeping.print.dialog.SSMainBookDialog;
import se.swedsoft.bookkeeping.print.dialog.SSOCRInvoiceDialog;
import se.swedsoft.bookkeeping.print.dialog.SSOrderListDialog;
import se.swedsoft.bookkeeping.print.dialog.SSOutdeliveryListDialog;
import se.swedsoft.bookkeeping.print.dialog.SSOutpaymentListDialog;
import se.swedsoft.bookkeeping.print.dialog.SSPeriodSelectionDialog;
import se.swedsoft.bookkeeping.print.dialog.SSProjectResultSetupDialog;
import se.swedsoft.bookkeeping.print.dialog.SSPurchaseOrderListDialog;
import se.swedsoft.bookkeeping.print.dialog.SSQuarterReportDialog;
import se.swedsoft.bookkeeping.print.dialog.SSResultPrinterSetupPanel;
import se.swedsoft.bookkeeping.print.dialog.SSResultUnitResultSetupDialog;
import se.swedsoft.bookkeeping.print.dialog.SSSaleReportDialog;
import se.swedsoft.bookkeeping.print.dialog.SSStockAccountDialog;
import se.swedsoft.bookkeeping.print.dialog.SSStockValueDialog;
import se.swedsoft.bookkeeping.print.dialog.SSSupplierCreditInvoiceListDialog;
import se.swedsoft.bookkeeping.print.dialog.SSSupplierInvoiceListDialog;
import se.swedsoft.bookkeeping.print.dialog.SSSupplierdebtDialog;
import se.swedsoft.bookkeeping.print.dialog.SSTenderListDialog;
import se.swedsoft.bookkeeping.print.dialog.SSVATReportDialog;
import se.swedsoft.bookkeeping.print.dialog.SSVoucherListDialog;
import se.swedsoft.bookkeeping.print.report.SSAccountdiagramPrinter;
import se.swedsoft.bookkeeping.print.report.SSAccountsPayablePrinter;
import se.swedsoft.bookkeeping.print.report.SSAccountsRecievablePrinter;
import se.swedsoft.bookkeeping.print.report.SSBalancePrinter;
import se.swedsoft.bookkeeping.print.report.SSBudgetPrinter;
import se.swedsoft.bookkeeping.print.report.SSCreditInvoiceListPrinter;
import se.swedsoft.bookkeeping.print.report.SSCustomerclaimPrinter;
import se.swedsoft.bookkeeping.print.report.SSIndeliveryListPrinter;
import se.swedsoft.bookkeeping.print.report.SSInpaymentListPrinter;
import se.swedsoft.bookkeeping.print.report.SSInventoryListPrinter;
import se.swedsoft.bookkeeping.print.report.SSInvoiceListPrinter;
import se.swedsoft.bookkeeping.print.report.SSMainBookPrinter;
import se.swedsoft.bookkeeping.print.report.SSOrderListPrinter;
import se.swedsoft.bookkeeping.print.report.SSOutdeliveryListPrinter;
import se.swedsoft.bookkeeping.print.report.SSOutpaymentListPrinter;
import se.swedsoft.bookkeeping.print.report.SSOwnReportPrinter;
import se.swedsoft.bookkeeping.print.report.SSProjectResultPrinter;
import se.swedsoft.bookkeeping.print.report.SSPurchaseOrderListPrinter;
import se.swedsoft.bookkeeping.print.report.SSPurchasevaluePrinter;
import se.swedsoft.bookkeeping.print.report.SSQuarterReportPrinter;
import se.swedsoft.bookkeeping.print.report.SSResultPrinter;
import se.swedsoft.bookkeeping.print.report.SSResultUnitResultPrinter;
import se.swedsoft.bookkeeping.print.report.SSSaleReportPrinter;
import se.swedsoft.bookkeeping.print.report.SSSalevaluesPrinter;
import se.swedsoft.bookkeeping.print.report.SSSimpleStatementPrinter;
import se.swedsoft.bookkeeping.print.report.SSStockAccountPrinter;
import se.swedsoft.bookkeeping.print.report.SSStockValuePrinter;
import se.swedsoft.bookkeeping.print.report.SSSupplierCreditInvoiceListPrinter;
import se.swedsoft.bookkeeping.print.report.SSSupplierInvoiceListPrinter;
import se.swedsoft.bookkeeping.print.report.SSSupplierdebtPrinter;
import se.swedsoft.bookkeeping.print.report.SSTenderListPrinter;
import se.swedsoft.bookkeeping.print.report.SSVATControl2007Printer;
import se.swedsoft.bookkeeping.print.report.SSVATControl2015Printer;
import se.swedsoft.bookkeeping.print.report.SSVATControlPrinter;
import se.swedsoft.bookkeeping.print.report.SSVATReport2007Printer;
import se.swedsoft.bookkeeping.print.report.SSVATReport2015Printer;
import se.swedsoft.bookkeeping.print.report.SSVATReportPrinter;
import se.swedsoft.bookkeeping.print.report.SSVoucherListPrinter;
import se.swedsoft.bookkeeping.print.report.SSVoucherPrinter;
import se.swedsoft.bookkeeping.print.report.journals.SSCreditinvoicejournalPrinter;
import se.swedsoft.bookkeeping.print.report.journals.SSInpaymentjournalPrinter;
import se.swedsoft.bookkeeping.print.report.journals.SSInvoicejournalPrinter;
import se.swedsoft.bookkeeping.print.report.journals.SSOutpaymentjournalPrinter;
import se.swedsoft.bookkeeping.print.report.journals.SSSupplierInvoicejournalPrinter;
import se.swedsoft.bookkeeping.print.report.journals.SSSuppliercreditinvoicejournalPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSCreditinvoicePrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSDeliverynotePrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSInquiryPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSInvoicePrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSOCRInvoicePrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSOrderPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSPickingslipPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSPurchaseOrderPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSReminderPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSTenderPrinter;

public class SSReportFactory {
    private static final File PDF_FILE_DIR = new File(Path.get(Path.APP_DATA), "pdftoemail");

    private SSReportFactory() {
    }

    public static void buildVoucherReport(final SSMainFrame iMainFrame, ResourceBundle bundle, SSNewAccountingYear pYearData) {
        final SSVoucherListDialog iDialog = new SSVoucherListDialog(iMainFrame);
        iDialog.setDateFrom(pYearData.getFrom());
        iDialog.setDateTo(pYearData.getTo());
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                List<SSVoucher> iVouchers = iDialog.getElementsToPrint();
                DateFormat iFormat = DateFormat.getDateInstance(3);
                SSVoucherListPrinter iPrinter = new SSVoucherListPrinter(iVouchers);
                if (iDialog.isDateSelected()) {
                    Date iDateFrom = iDialog.getDateFrom();
                    Date iDateTo = iDialog.getDateTo();
                    iPrinter.addParameter("periodTitle", String.format(SSBundle.getBundle().getString("voucherlistreport.period.date"), iFormat.format(iDateFrom), iFormat.format(iDateTo)));
                    iPrinter.addParameter("periodText", " ");
                }
                if (iDialog.isNumberSelected()) {
                    Integer iNumberFrom = iDialog.getNumberFrom();
                    Integer iNumberTo = iDialog.getNumberTo();
                    iPrinter.addParameter("periodTitle", String.format(SSBundle.getBundle().getString("voucherlistreport.period.number"), iNumberFrom, iNumberTo));
                    iPrinter.addParameter("periodText", " ");
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void MainbookReport(final SSMainFrame iMainFrame, final SSNewAccountingYear pYearData) {
        final SSMainBookDialog iDialog = new SSMainBookDialog(iMainFrame);
        iDialog.setDateFrom(pYearData.getFrom());
        iDialog.setDateTo(pYearData.getTo());
        iDialog.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iDialog.closeDialog();
                final Date lDateFrom = iDialog.getDateFrom();
                final Date lDateTo = iDialog.getDateTo();
                final SSAccount lAccountFrom = iDialog.getAccountFrom();
                final SSAccount lAccountTo = iDialog.getAccountTo();
                final SSNewProject iProject = iDialog.getProject();
                final SSNewResultUnit iResultUnit = iDialog.getResultUnit();
                final boolean isProjectSelected = iDialog.isProjectSelected();
                final boolean isResultUnitSelected = iDialog.isResultUnitSelected();
                SSProgressDialog.runProgress(iMainFrame, new Runnable(){

                    @Override
                    public void run() {
                        SSMainBookPrinter iPrinter = new SSMainBookPrinter(pYearData, lAccountFrom, lAccountTo, lDateFrom, lDateTo, iProject, iResultUnit);
                        if (isProjectSelected) {
                            // empty if block
                        }
                        if (isResultUnitSelected) {
                            // empty if block
                        }
                        iPrinter.preview(iMainFrame);
                    }
                });
            }
        });
        iDialog.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iDialog.closeDialog();
            }
        });
        iDialog.pack();
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void buildResultReport(final SSMainFrame iMainFrame, ResourceBundle bundle, SSNewAccountingYear yearData, SSNewAccountingYear lastYearData) {
        Date from = yearData.getFrom();
        Date to = yearData.getTo();
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("resultreport.perioddialog.title"));
        final SSResultPrinterSetupPanel iPanel = new SSResultPrinterSetupPanel();
        iPanel.setFrom(from);
        iPanel.setTo(to);
        iPanel.setPrintBudget(false);
        iPanel.setPrintLastyear(false);
        iPanel.setPrintLastyearEnabled(lastYearData != null);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        iPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final Date lFrom = iPanel.getFrom();
                final Date lTo = iPanel.getTo();
                final boolean lPrintBudget = iPanel.getPrintBudget();
                final boolean lPrintLastyear = iPanel.getPrintLastyear();
                iDialog.closeDialog();
                SSProgressDialog.runProgress(iMainFrame, new Runnable(){

                    @Override
                    public void run() {
                        SSResultPrinter iPrinter = new SSResultPrinter(lFrom, lTo, lPrintBudget, lPrintLastyear);
                        iPrinter.preview(iMainFrame);
                    }
                });
            }
        });
        iPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iDialog.closeDialog();
            }
        });
        iDialog.getRootPane().setDefaultButton(iPanel.getButtonPanel().getOkButton());
        iDialog.pack();
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void buildOwnReport(final SSMainFrame iMainFrame, final SSOwnReport iOwnReport) {
        SSPeriodSelectionDialog iDateDialog = new SSPeriodSelectionDialog(iMainFrame, "V\u00e4lj period");
        SSNewAccountingYear iYear = SSDB.getInstance().getCurrentYear();
        iDateDialog.setFrom(iYear.getFrom());
        iDateDialog.setTo(iYear.getTo());
        iDateDialog.setLocationRelativeTo(iMainFrame);
        if (iDateDialog.showDialog() != 0) {
            return;
        }
        final Date iFrom = iDateDialog.getFrom();
        final Date iTo = iDateDialog.getTo();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSOwnReportPrinter iPrinter = new SSOwnReportPrinter(iFrom, iTo, iOwnReport);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void ProjectResultReport(final SSMainFrame iMainFrame, ResourceBundle bundle, SSNewAccountingYear iAccountingYear) {
        SSProjectResultSetupDialog iDialog = new SSProjectResultSetupDialog(iMainFrame, bundle.getString("resultreport.perioddialog.title"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        final SSNewProject iProject = iDialog.getProject();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSProjectResultPrinter iPrinter = new SSProjectResultPrinter(iFrom, iTo, iProject);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void ResultUnitResultReport(final SSMainFrame iMainFrame, ResourceBundle bundle, SSNewAccountingYear iAccountingYear) {
        SSResultUnitResultSetupDialog iDialog = new SSResultUnitResultSetupDialog(iMainFrame, bundle.getString("resultreport.perioddialog.title"));
        iDialog.setFrom(iAccountingYear.getFrom());
        iDialog.setTo(iAccountingYear.getTo());
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        final SSNewResultUnit iResultUnit = iDialog.getSelectedResultUnit();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSResultUnitResultPrinter iPrinter = new SSResultUnitResultPrinter(iFrom, iTo, iResultUnit);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void buildBalanceReport(final SSMainFrame iMainFrame, ResourceBundle bundle, SSNewAccountingYear iAccountingYear) {
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(iMainFrame, bundle.getString("balancereport.perioddialog.title"));
        iDialog.setFrom(iAccountingYear.getFrom());
        iDialog.setTo(iAccountingYear.getTo());
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSBalancePrinter iPrinter = new SSBalancePrinter(iFrom, iTo);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void buildBudgetReport(final SSMainFrame iMainFrame, ResourceBundle bundle, SSNewAccountingYear iAccountingYear) {
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(iMainFrame, bundle.getString("budgetreport.perioddialog.title"));
        iDialog.setFrom(iAccountingYear.getFrom());
        iDialog.setTo(iAccountingYear.getTo());
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSBudgetPrinter iPrinter = new SSBudgetPrinter(iFrom, iTo);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void buildVATReport(final SSMainFrame iMainFrame, final ResourceBundle bundle, final SSNewAccountingYear iAccountingYear) {
        String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.add(2, -1);
        iCalendar.set(5, iCalendar.getActualMinimum(5));
        Date iFrom = iCalendar.getTime();
        iCalendar.set(5, iCalendar.getActualMaximum(5));
        Date iTo = iCalendar.getTime();
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(iMainFrame, bundle.getString("vatreport.perioddialog.title"));
        iDialog.setFrom(iFrom);
        iDialog.setTo(iTo);
        iDialog.setLocationRelativeTo(iMainFrame);
        int iResponce = iDialog.showDialog();
        if (iResponce != 0) {
            SSPostLock.removeLock(lockString);
            return;
        }
        final Date localFrom = iDialog.getFrom();
        final Date localTo = iDialog.getTo();
        List<SSAccount> iAccounts = iAccountingYear.getAccounts();
        if (SSAccountMath.getNumAccountsByVatCode(iAccounts, "R1") > 1 || SSAccountMath.getNumAccountsByVatCode(iAccounts, "R2") > 1 || SSAccountMath.getNumAccountsByVatCode(iAccounts, "A") > 1) {
            SSPostLock.removeLock(lockString);
            new SSErrorDialog(iMainFrame, "vatbasis.dialog.morethenoneaccount");
            return;
        }
        DateFormat format = DateFormat.getDateInstance(3);
        final SSAccount accountR1 = SSAccountMath.getAccountWithVATCode(iAccounts, "R1", iAccountingYear.getAccountPlan().getAccount(1650));
        final SSAccount accountR2 = SSAccountMath.getAccountWithVATCode(iAccounts, "R2", iAccountingYear.getAccountPlan().getAccount(2650));
        final SSAccount accountA = SSAccountMath.getAccountWithVATCode(iAccounts, "A", iAccountingYear.getAccountPlan().getAccount(3740));
        String voucherName = String.format(bundle.getString("vatbasis.vouchername"), format.format(localFrom), format.format(localTo));
        final SSVoucher iVoucher = SSVATUtil.generateVATVoucher(voucherName, localFrom, localTo, accountR1, accountR2, accountA);
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSVATReportPrinter iPrinter1 = new SSVATReportPrinter(iAccountingYear, localFrom, localTo);
                SSVATControlPrinter iPrinter2 = new SSVATControlPrinter(iAccountingYear, localFrom, localTo);
                SSVoucherPrinter iPrinter3 = new SSVoucherPrinter(iVoucher, bundle.getString("vatbasisreport.title"), accountR1, accountR2, accountA);
                SSMultiPrinter mPrinter = new SSMultiPrinter();
                mPrinter.addReport(iPrinter1);
                mPrinter.addReport(iPrinter2);
                mPrinter.addReport(iPrinter3);
                mPrinter.preview(iMainFrame, new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosed(InternalFrameEvent e) {
                        SSReportFactory.dialogVATVoucher(iMainFrame, iVoucher, iAccountingYear, localFrom, localTo);
                        e.getInternalFrame().removeInternalFrameListener(this);
                    }
                });
            }
        });
    }

    public static void VATReport2007(final SSMainFrame iMainFrame, final ResourceBundle bundle, final SSNewAccountingYear iAccountingYear) {
        final String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
        SSVATReportDialog iDialog = new SSVATReportDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        int iResponce = iDialog.showDialog();
        if (iResponce != 0) {
            SSPostLock.removeLock(lockString);
            return;
        }
        final Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        final SSAccount iAccountR1 = iDialog.getAccountR1();
        final SSAccount iAccountR2 = iDialog.getAccountR2();
        final SSAccount iAccountA = iDialog.getAccountA();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                SSVATReport2007Printer iPrinter1 = new SSVATReport2007Printer(iAccountingYear, iFrom, iTo);
                SSVATControl2007Printer iPrinter2 = new SSVATControl2007Printer(iAccountingYear, iFrom, iTo);
                final SSVoucher iVoucher = iPrinter2.getVoucher(iAccountR1, iAccountR2, iAccountA);
                SSVoucherPrinter iPrinter3 = new SSVoucherPrinter(iVoucher, bundle.getString("vatbasisreport.title"), iAccountR1, iAccountR2, iAccountA);
                iPrinter.addReport(iPrinter1);
                iPrinter.addReport(iPrinter2);
                iPrinter.addReport(iPrinter3);
                iPrinter.preview(iMainFrame, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DateFormat iFormat = DateFormat.getDateInstance(3);
                        SSQueryDialog iDialog = new SSQueryDialog((JFrame)iMainFrame, SSBundle.getBundle(), "vatcontrol2007.voucherdialog", iFormat.format(iFrom), iFormat.format(iTo), iVoucher.getNumber());
                        int iResponce = iDialog.getResponce();
                        if (iResponce != 0) {
                            SSPostLock.removeLock(lockString);
                            return;
                        }
                        SSDB.getInstance().addVoucher(iVoucher, false);
                        if (SSVoucherFrame.getInstance() != null) {
                            SSVoucherFrame.getInstance().getModel().fireTableDataChanged();
                        }
                        SSPostLock.removeLock(lockString);
                    }
                });
            }
        });
    }

    public static void VATReport2015(final SSMainFrame iMainFrame, final ResourceBundle bundle, final SSNewAccountingYear iAccountingYear) {
        final String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
        SSVATReportDialog iDialog = new SSVATReportDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        int iResponce = iDialog.showDialog();
        if (iResponce != 0) {
            SSPostLock.removeLock(lockString);
            return;
        }
        final Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        final int iStartVoucher = iDialog.getStartVoucher();
        final SSAccount iAccountR1 = iDialog.getAccountR1();
        final SSAccount iAccountR2 = iDialog.getAccountR2();
        final SSAccount iAccountA = iDialog.getAccountA();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                SSVATReport2015Printer iPrinter1 = new SSVATReport2015Printer(iAccountingYear, iFrom, iTo, iStartVoucher);
                SSVATControl2015Printer iPrinter2 = new SSVATControl2015Printer(iAccountingYear, iFrom, iTo, iStartVoucher);
                final SSVoucher iVoucher = iPrinter2.getVoucher(iAccountR1, iAccountR2, iAccountA);
                SSVoucherPrinter iPrinter3 = new SSVoucherPrinter(iVoucher, bundle.getString("vatbasisreport.title"), iAccountR1, iAccountR2, iAccountA);
                iPrinter.addReport(iPrinter1);
                iPrinter.addReport(iPrinter2);
                iPrinter.addReport(iPrinter3);
                iPrinter.preview(iMainFrame, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DateFormat iFormat = DateFormat.getDateInstance(3);
                        SSQueryDialog iDialog = new SSQueryDialog((JFrame)iMainFrame, SSBundle.getBundle(), "vatcontrol2015.voucherdialog", iFormat.format(iFrom), iFormat.format(iTo), iVoucher.getNumber());
                        int iResponce = iDialog.getResponce();
                        if (iResponce != 0) {
                            SSPostLock.removeLock(lockString);
                            return;
                        }
                        SSDB.getInstance().addVoucher(iVoucher, false);
                        if (SSVoucherFrame.getInstance() != null) {
                            SSVoucherFrame.getInstance().getModel().fireTableDataChanged();
                        }
                        SSPostLock.removeLock(lockString);
                    }
                });
            }
        });
    }

    public static void SimplestatementReport(final SSMainFrame iMainFrame) {
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(iMainFrame, SSBundle.getBundle().getString("simplestatement.dialog.title"));
        iDialog.setFrom(SSDB.getInstance().getCurrentYear().getFrom());
        iDialog.setTo(SSDB.getInstance().getCurrentYear().getTo());
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSSimpleStatementPrinter iPrinter = new SSSimpleStatementPrinter(iFrom, iTo);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void dialogVATVoucher(SSMainFrame iMainFrame, SSVoucher pVoucher, SSNewAccountingYear pAccountingYear, Date pFrom, Date pTo) {
        String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
        DateFormat format = DateFormat.getDateInstance(3);
        SSQueryDialog iDialog = new SSQueryDialog((JFrame)iMainFrame, SSBundle.getBundle(), "vatbasis.dialog", format.format(pFrom), format.format(pTo), pVoucher.getNumber());
        int iResponce = iDialog.getResponce();
        if (iResponce != 0) {
            SSPostLock.removeLock(lockString);
            return;
        }
        SSDB.getInstance().addVoucher(pVoucher, false);
        if (SSVoucherFrame.getInstance() != null) {
            SSVoucherFrame.getInstance().getModel().fireTableDataChanged();
        }
        SSPostLock.removeLock(lockString);
    }

    public static void buildAccountDiagramReport(final SSMainFrame iMainFrame, ResourceBundle bundle, SSNewAccountingYear yearData) {
        List<SSAccount> iAccounts = SSDB.getInstance().getAccounts();
        List<SSAccount> iAccountsWithoutSRUCode = SSAccountMath.getAccountsWithoutSRUCode(iAccounts);
        if (!iAccountsWithoutSRUCode.isEmpty()) {
            new SSWarningDialog(iMainFrame, "accountdiagramreport.dialogmissingSRUCode");
        }
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSAccountdiagramPrinter iPrinter = new SSAccountdiagramPrinter();
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void OrderListReport(final SSMainFrame iMainFrame) {
        SSOrderListDialog iDialog = new SSOrderListDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final List<SSOrder> iOrders = iDialog.getOrdersToPrint();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSOrderListPrinter iPrinter = new SSOrderListPrinter(iOrders);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void InvoiceListReport(final SSMainFrame iMainFrame) {
        SSInvoiceListDialog iDialog = new SSInvoiceListDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final List<SSInvoice> iInvoices = iDialog.getInvoicesToPrint();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSInvoiceListPrinter iPrinter = new SSInvoiceListPrinter(iInvoices);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void CreditInvoiceListReport(final SSMainFrame iMainFrame) {
        SSCreditInvoiceListDialog iDialog = new SSCreditInvoiceListDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final List<SSCreditInvoice> iInvoices = iDialog.getInvoicesToPrint();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSCreditInvoiceListPrinter iPrinter = new SSCreditInvoiceListPrinter(iInvoices);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void TenderListReport(final SSMainFrame iMainFrame) {
        SSTenderListDialog iDialog = new SSTenderListDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final List<SSTender> iTenders = iDialog.getTendersToPrint();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSTenderListPrinter iPrinter = new SSTenderListPrinter(iTenders);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void PurchaseOrderListReport(final SSMainFrame iMainFrame) {
        SSPurchaseOrderListDialog iDialog = new SSPurchaseOrderListDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final List<SSPurchaseOrder> iOrders = iDialog.getElementsToPrint();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSPurchaseOrderListPrinter iPrinter = new SSPurchaseOrderListPrinter(iOrders);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void SupplierInvoiceListReport(final SSMainFrame iMainFrame) {
        SSSupplierInvoiceListDialog iDialog = new SSSupplierInvoiceListDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final List<SSSupplierInvoice> iInvoices = iDialog.getElementsToPrint();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSSupplierInvoiceListPrinter iPrinter = new SSSupplierInvoiceListPrinter(iInvoices);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void SupplierCreditInvoiceListReport(final SSMainFrame iMainFrame) {
        SSSupplierCreditInvoiceListDialog iDialog = new SSSupplierCreditInvoiceListDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final List<SSSupplierCreditInvoice> iInvoices = iDialog.getElementsToPrint();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSSupplierCreditInvoiceListPrinter iPrinter = new SSSupplierCreditInvoiceListPrinter(iInvoices);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void InventoryList(final SSMainFrame iMainFrame) {
        final SSInventoryListDialog iDialog = new SSInventoryListDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final List<SSInventory> iInventories = iDialog.getElementsToPrint();
        final boolean isDateSelected = iDialog.isDateSelected();
        final boolean isProductSelected = iDialog.isProductSelected();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSInventoryListPrinter iPrinter = new SSInventoryListPrinter(iInventories);
                if (isDateSelected) {
                    iPrinter.addParameter("dateFrom", iDialog.getDateFrom());
                    iPrinter.addParameter("dateTo", iDialog.getDateTo());
                }
                if (isProductSelected) {
                    SSProduct iProduct = iDialog.getProduct();
                    iPrinter.addParameter("periodTitle", SSBundle.getBundle().getString("inventorylistreport.producttitle"));
                    iPrinter.addParameter("periodText", iProduct == null ? null : iProduct.getNumber());
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void IndeliveryList(final SSMainFrame iMainFrame) {
        final SSIndeliveryListDialog iDialog = new SSIndeliveryListDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final List<SSIndelivery> iIndeliveries = iDialog.getElementsToPrint();
        final boolean isDateSelected = iDialog.isDateSelected();
        final boolean isProductSelected = iDialog.isProductSelected();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSIndeliveryListPrinter iPrinter = new SSIndeliveryListPrinter(iIndeliveries);
                if (isDateSelected) {
                    iPrinter.addParameter("dateFrom", iDialog.getDateFrom());
                    iPrinter.addParameter("dateTo", iDialog.getDateTo());
                }
                if (isProductSelected) {
                    SSProduct iProduct = iDialog.getProduct();
                    iPrinter.addParameter("periodTitle", SSBundle.getBundle().getString("indeliverylistreport.producttitle"));
                    iPrinter.addParameter("periodText", iProduct == null ? null : iProduct.getNumber());
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void OutdeliveryList(final SSMainFrame iMainFrame) {
        final SSOutdeliveryListDialog iDialog = new SSOutdeliveryListDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final List<SSOutdelivery> iOutdeliveries = iDialog.getElementsToPrint();
        final boolean isDateSelected = iDialog.isDateSelected();
        final boolean isProductSelected = iDialog.isProductSelected();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSOutdeliveryListPrinter iPrinter = new SSOutdeliveryListPrinter(iOutdeliveries);
                if (isDateSelected) {
                    iPrinter.addParameter("dateFrom", iDialog.getDateFrom());
                    iPrinter.addParameter("dateTo", iDialog.getDateTo());
                }
                if (isProductSelected) {
                    SSProduct iProduct = iDialog.getProduct();
                    iPrinter.addParameter("periodTitle", SSBundle.getBundle().getString("indeliverylistreport.producttitle"));
                    iPrinter.addParameter("periodText", iProduct == null ? null : iProduct.getNumber());
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void InpaymentList(final SSMainFrame iMainFrame) {
        final SSInpaymentListDialog iDialog = new SSInpaymentListDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final List<SSInpayment> iInpayments = iDialog.getElementsToPrint();
        final boolean isDateSelected = iDialog.isDateSelected();
        final boolean isInvoiceSelected = iDialog.isInvoiceSelected();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSInpaymentListPrinter iPrinter = new SSInpaymentListPrinter(iInpayments);
                if (isDateSelected) {
                    iPrinter.addParameter("dateFrom", iDialog.getDateFrom());
                    iPrinter.addParameter("dateTo", iDialog.getDateTo());
                }
                if (isInvoiceSelected) {
                    SSInvoice iInvoice = iDialog.getInvoice();
                    iPrinter.addParameter("periodTitle", SSBundle.getBundle().getString("inpaymentlistreport.invoicetitle"));
                    iPrinter.addParameter("periodText", iInvoice == null ? null : iInvoice.getNumber().toString());
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void OutpaymentList(final SSMainFrame iMainFrame) {
        final SSOutpaymentListDialog iDialog = new SSOutpaymentListDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final List<SSOutpayment> iInpayments = iDialog.getElementsToPrint();
        final boolean isDateSelected = iDialog.isDateSelected();
        final boolean isInvoiceSelected = iDialog.isInvoiceSelected();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSOutpaymentListPrinter iPrinter = new SSOutpaymentListPrinter(iInpayments);
                if (isDateSelected) {
                    iPrinter.addParameter("dateFrom", iDialog.getDateFrom());
                    iPrinter.addParameter("dateTo", iDialog.getDateTo());
                }
                if (isInvoiceSelected) {
                    SSSupplierInvoice iInvoice = iDialog.getInvoice();
                    iPrinter.addParameter("periodTitle", SSBundle.getBundle().getString("outpaymentlistreport.invoicetitle"));
                    iPrinter.addParameter("periodText", iInvoice == null ? null : iInvoice.getNumber().toString());
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void StockValue(final SSMainFrame iMainFrame) {
        SSStockValueDialog iDialog = new SSStockValueDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iDate = iDialog.getDate();
        final boolean isDateSelected = iDialog.isDateSelected();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSStockValuePrinter iPrinter = isDateSelected ? new SSStockValuePrinter(iDate) : new SSStockValuePrinter();
                if (isDateSelected) {
                    // empty if block
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void StockAccount(final SSMainFrame iMainFrame) {
        SSStockAccountDialog iDialog = new SSStockAccountDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iDate = iDialog.getDate();
        final boolean iDateSelected = iDialog.isDateSelected();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSStockAccountPrinter iPrinter = iDateSelected ? new SSStockAccountPrinter(iDate) : new SSStockAccountPrinter();
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void AccountsRecievableReport(final SSMainFrame iMainFrame) {
        SSAccountsrecievableDialog iDialog = new SSAccountsrecievableDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iDate = iDialog.getDate();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSAccountsRecievablePrinter iPrinter = new SSAccountsRecievablePrinter(iDate);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void CustomerClaimReport(final SSMainFrame iMainFrame) {
        SSCustomerclaimDialog iDialog = new SSCustomerclaimDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iDate = iDialog.getDate();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSCustomerclaimPrinter iPrinter = new SSCustomerclaimPrinter(SSDateMath.ceil(iDate));
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void AccountsPayableReport(final SSMainFrame iMainFrame) {
        SSAccountsPayableDialog iDialog = new SSAccountsPayableDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iDate = iDialog.getDate();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSAccountsPayablePrinter iPrinter = new SSAccountsPayablePrinter(iDate);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void SupplierDebtReport(final SSMainFrame iMainFrame) {
        SSSupplierdebtDialog iDialog = new SSSupplierdebtDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iDate = iDialog.getDate();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSSupplierdebtPrinter iPrinter = new SSSupplierdebtPrinter(iDate);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void SaleReport(final SSMainFrame iMainFrame) {
        SSSaleReportDialog iDialog = new SSSaleReportDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        final SSSaleReportPrinter.SortingMode iSortingMode = iDialog.getSortingMode();
        final boolean iAscending = iDialog.getAscending();
        SSProgressDialog.runProgress(iMainFrame, SSBundle.getBundle().getString("salereport.title"), new Runnable(){

            @Override
            public void run() {
                SSSaleReportPrinter iPrinter = new SSSaleReportPrinter(iFrom, iTo, iSortingMode, iAscending);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void Salevalues(final SSMainFrame iMainFrame, ResourceBundle bundle, SSNewAccountingYear iAccountingYear) {
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(iMainFrame, bundle.getString("salevalues.perioddialog.title"));
        if (iAccountingYear != null) {
            iDialog.setFrom(iAccountingYear.getFrom());
            iDialog.setTo(iAccountingYear.getTo());
        } else {
            Calendar iCal = Calendar.getInstance();
            iDialog.setFrom(iCal.getTime());
            iCal.add(2, 1);
            iDialog.setTo(iCal.getTime());
        }
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSSalevaluesPrinter iPrinter = new SSSalevaluesPrinter(iFrom, iTo);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void Purchasevalues(final SSMainFrame iMainFrame, ResourceBundle bundle, SSNewAccountingYear iAccountingYear) {
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(iMainFrame, bundle.getString("purchasevalues.perioddialog.title"));
        if (iAccountingYear != null) {
            iDialog.setFrom(iAccountingYear.getFrom());
            iDialog.setTo(iAccountingYear.getTo());
        } else {
            Calendar iCal = Calendar.getInstance();
            iDialog.setFrom(iCal.getTime());
            iCal.add(2, 1);
            iDialog.setTo(iCal.getTime());
        }
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSPurchasevaluePrinter iPrinter = new SSPurchasevaluePrinter(iFrom, iTo);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void InvoiceReport(final SSMainFrame iMainFrame, final List<SSInvoice> iInvoices) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.invoice"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        for (SSInvoice iInvoice : iInvoices) {
            iInvoice.setPrinted();
            SSDB.getInstance().updateInvoice(iInvoice);
        }
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                for (SSInvoice iInvoice : iInvoices) {
                    SSInvoicePrinter iInvoicePrinter = new SSInvoicePrinter(iInvoice, iLanguage);
                    iPrinter.addReport(iInvoicePrinter);
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void EmailInvoiceReport(SSMainFrame iMainFrame, final SSInvoice iInvoice) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.invoice"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        iInvoice.setPrinted();
        SSDB.getInstance().updateInvoice(iInvoice);
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                SSInvoicePrinter iInvoicePrinter = new SSInvoicePrinter(iInvoice, iLanguage);
                iPrinter.addReport(iInvoicePrinter);
                iPrinter.generateReport();
                iPrinter.getPrinter();
                String iFileName = "faktura.pdf";
                if (!PDF_FILE_DIR.exists()) {
                    PDF_FILE_DIR.mkdirs();
                }
                try {
                    JasperExportManager.exportReportToPdfFile(iPrinter.getPrinter(), new File(PDF_FILE_DIR, iFileName).getPath());
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                String iSubject = "Faktura " + iInvoice.getNumber() + " fr\u00e5n " + SSDB.getInstance().getCurrentCompany().getName();
                try {
                    if (!SSMail.sendMail(iInvoice.getCustomer().getEMail(), iSubject, iFileName)) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    new SSErrorDialog(SSMainFrame.getInstance(), "mail.somethingwrong");
                    return;
                }
                SSInformationDialog.showDialog(SSMainFrame.getInstance(), "mail.success");
            }
        });
    }

    public static void OCRInvoiceReport(final SSMainFrame iMainFrame, final List<SSInvoice> iInvoices) {
        SSOCRInvoiceDialog iDialog = new SSOCRInvoiceDialog(iMainFrame, SSBundle.getBundle().getString("report.title.ocrinvoice"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        final boolean iShowBackground = iDialog.doShowBackground();
        for (SSInvoice iInvoice : iInvoices) {
            iInvoice.setPrinted();
            String iOCRNumber = SSOCRNumber.getOCRNumber(iInvoice);
            iInvoice.setOCRNumber(iOCRNumber);
            SSDB.getInstance().updateInvoice(iInvoice);
        }
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                for (SSInvoice iInvoice : iInvoices) {
                    SSOCRInvoicePrinter iInvoicePrinter = new SSOCRInvoicePrinter(iInvoice, iLanguage, iShowBackground);
                    iPrinter.addReport(iInvoicePrinter);
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void CreditInvoiceReport(final SSMainFrame iMainFrame, final List<SSCreditInvoice> iCreditInvoices) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.creditinvoice"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            iCreditInvoice.setPrinted();
            SSDB.getInstance().updateCreditInvoice(iCreditInvoice);
        }
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
                    SSCreditinvoicePrinter iCreditinvoicePrinter = new SSCreditinvoicePrinter(iCreditInvoice, iLanguage);
                    iPrinter.addReport(iCreditinvoicePrinter);
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void EmailCreditInvoiceReport(SSMainFrame iMainFrame, final SSCreditInvoice iCreditInvoice) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.creditinvoice"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        iCreditInvoice.setPrinted();
        SSDB.getInstance().updateCreditInvoice(iCreditInvoice);
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                SSCreditinvoicePrinter iCreditInvoicePrinter = new SSCreditinvoicePrinter(iCreditInvoice, iLanguage);
                iPrinter.addReport(iCreditInvoicePrinter);
                iPrinter.generateReport();
                iPrinter.getPrinter();
                String iFileName = "kreditfaktura.pdf";
                if (!PDF_FILE_DIR.exists()) {
                    PDF_FILE_DIR.mkdirs();
                }
                try {
                    JasperExportManager.exportReportToPdfFile(iPrinter.getPrinter(), new File(PDF_FILE_DIR, iFileName).getPath());
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                String iSubject = "Kreditfaktura " + iCreditInvoice.getNumber() + " fr\u00e5n " + SSDB.getInstance().getCurrentCompany().getName();
                try {
                    if (!SSMail.sendMail(iCreditInvoice.getCustomer().getEMail(), iSubject, iFileName)) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    new SSErrorDialog(SSMainFrame.getInstance(), "mail.somethingwrong");
                    return;
                }
                SSInformationDialog.showDialog(SSMainFrame.getInstance(), "mail.success");
            }
        });
    }

    public static void OrderReport(final SSMainFrame iMainFrame, final List<SSOrder> iOrders) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.order"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        for (SSOrder iOrder : iOrders) {
            iOrder.setPrinted();
            SSDB.getInstance().updateOrder(iOrder);
        }
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                for (SSOrder iOrder : iOrders) {
                    SSOrderPrinter iOrderPrinter = new SSOrderPrinter(iOrder, iLanguage);
                    iPrinter.addReport(iOrderPrinter);
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void EmailOrderReport(SSMainFrame iMainFrame, final SSOrder iOrder) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.order"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        iOrder.setPrinted();
        SSDB.getInstance().updateOrder(iOrder);
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                SSOrderPrinter iOrderPrinter = new SSOrderPrinter(iOrder, iLanguage);
                iPrinter.addReport(iOrderPrinter);
                iPrinter.generateReport();
                iPrinter.getPrinter();
                String iFileName = "order.pdf";
                if (!PDF_FILE_DIR.exists()) {
                    PDF_FILE_DIR.mkdirs();
                }
                try {
                    JasperExportManager.exportReportToPdfFile(iPrinter.getPrinter(), new File(PDF_FILE_DIR, iFileName).getPath());
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                String iSubject = "Order " + iOrder.getNumber() + " fr\u00e5n " + SSDB.getInstance().getCurrentCompany().getName();
                try {
                    if (iOrder.getCustomer() != null && !SSMail.sendMail(iOrder.getCustomer().getEMail(), iSubject, iFileName)) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    new SSErrorDialog(SSMainFrame.getInstance(), "mail.somethingwrong");
                    return;
                }
                SSInformationDialog.showDialog(SSMainFrame.getInstance(), "mail.success");
            }
        });
    }

    public static void TenderReport(final SSMainFrame iMainFrame, final List<SSTender> iTenders) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.tender"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        for (SSTender iTender : iTenders) {
            iTender.setPrinted();
            SSDB.getInstance().updateTender(iTender);
        }
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                for (SSTender iTender : iTenders) {
                    SSTenderPrinter iTenderPrinter = new SSTenderPrinter(iTender, iLanguage);
                    iPrinter.addReport(iTenderPrinter);
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void EmailTenderReport(SSMainFrame iMainFrame, final SSTender iTender) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.tender"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        iTender.setPrinted();
        SSDB.getInstance().updateTender(iTender);
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                SSTenderPrinter iTenderPrinter = new SSTenderPrinter(iTender, iLanguage);
                iPrinter.addReport(iTenderPrinter);
                iPrinter.generateReport();
                iPrinter.getPrinter();
                String iFileName = "offert.pdf";
                if (!PDF_FILE_DIR.exists()) {
                    PDF_FILE_DIR.mkdirs();
                }
                try {
                    JasperExportManager.exportReportToPdfFile(iPrinter.getPrinter(), new File(PDF_FILE_DIR, iFileName).getPath());
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                String iSubject = "Offert " + iTender.getNumber() + " fr\u00e5n " + SSDB.getInstance().getCurrentCompany().getName();
                try {
                    if (iTender.getCustomer() != null && !SSMail.sendMail(iTender.getCustomer().getEMail(), iSubject, iFileName)) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    new SSErrorDialog(SSMainFrame.getInstance(), "mail.somethingwrong");
                    return;
                }
                SSInformationDialog.showDialog(SSMainFrame.getInstance(), "mail.success");
            }
        });
    }

    public static void PickingslipReport(final SSMainFrame iMainFrame, final List<SSOrder> iOrders) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.pickingslip"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                for (SSOrder iOrder : iOrders) {
                    SSPickingslipPrinter iPickingslipPrinter = new SSPickingslipPrinter(iOrder, iLanguage);
                    iPrinter.addReport(iPickingslipPrinter);
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void DeliverynoteReport(final SSMainFrame iMainFrame, final List<SSOrder> iOrders) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.deliverynote"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                for (SSOrder iOrder : iOrders) {
                    SSDeliverynotePrinter iDeliverynotePrinter = new SSDeliverynotePrinter(iOrder, iLanguage);
                    iPrinter.addReport(iDeliverynotePrinter);
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void PurchaseOrderReport(final SSMainFrame iMainFrame, final List<SSPurchaseOrder> iPurchaseOrders) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.purchaseorder"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        for (SSPurchaseOrder iPurchaseOrder : iPurchaseOrders) {
            iPurchaseOrder.setPrinted();
            SSDB.getInstance().updatePurchaseOrder(iPurchaseOrder);
        }
        final Locale iLanguage = iDialog.getLanguage();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                for (SSPurchaseOrder iPurchaseOrder : iPurchaseOrders) {
                    SSPurchaseOrderPrinter iPurchaseOrderPrinter = new SSPurchaseOrderPrinter(iPurchaseOrder, iLanguage);
                    iPrinter.addReport(iPurchaseOrderPrinter);
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void EmailPurchaseOrderReport(SSMainFrame iMainFrame, final SSPurchaseOrder iPurchaseOrder) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.purchaseorder"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        iPurchaseOrder.setPrinted();
        SSDB.getInstance().updatePurchaseOrder(iPurchaseOrder);
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                SSPurchaseOrderPrinter iPurchaseOrderPrinter = new SSPurchaseOrderPrinter(iPurchaseOrder, iLanguage);
                iPrinter.addReport(iPurchaseOrderPrinter);
                iPrinter.generateReport();
                iPrinter.getPrinter();
                String iFileName = "inkopsorder.pdf";
                if (!PDF_FILE_DIR.exists()) {
                    PDF_FILE_DIR.mkdirs();
                }
                try {
                    JasperExportManager.exportReportToPdfFile(iPrinter.getPrinter(), new File(PDF_FILE_DIR, iFileName).getPath());
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                String iSubject = "Ink\u00f6psorder " + iPurchaseOrder.getNumber() + " fr\u00e5n " + SSDB.getInstance().getCurrentCompany().getName();
                try {
                    if (!SSMail.sendMail(iPurchaseOrder.getSupplier().getEMail(), iSubject, iFileName)) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    new SSErrorDialog(SSMainFrame.getInstance(), "mail.somethingwrong");
                    return;
                }
                SSInformationDialog.showDialog(SSMainFrame.getInstance(), "mail.success");
            }
        });
    }

    public static void InquiryReport(final SSMainFrame iMainFrame, final List<SSPurchaseOrder> iPurchaseOrders) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.inquiry"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                for (SSPurchaseOrder iPurchaseOrder : iPurchaseOrders) {
                    SSInquiryPrinter iInquiryPrinter = new SSInquiryPrinter(iPurchaseOrder, iLanguage);
                    iPrinter.addReport(iInquiryPrinter);
                }
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void EmailInquiryReport(SSMainFrame iMainFrame, final SSPurchaseOrder iPurchaseOrder) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.inquiry"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                SSInquiryPrinter iInquiryPrinter = new SSInquiryPrinter(iPurchaseOrder, iLanguage);
                iPrinter.addReport(iInquiryPrinter);
                iPrinter.generateReport();
                iPrinter.getPrinter();
                String iFileName = "forfragan.pdf";
                if (!PDF_FILE_DIR.exists()) {
                    PDF_FILE_DIR.mkdirs();
                }
                try {
                    JasperExportManager.exportReportToPdfFile(iPrinter.getPrinter(), new File(PDF_FILE_DIR, iFileName).getPath());
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                String iSubject = "F\u00f6rfr\u00e5gan fr\u00e5n " + SSDB.getInstance().getCurrentCompany().getName();
                try {
                    if (!SSMail.sendMail(iPurchaseOrder.getSupplier().getEMail(), iSubject, iFileName)) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    new SSErrorDialog(SSMainFrame.getInstance(), "mail.somethingwrong");
                    return;
                }
                SSInformationDialog.showDialog(SSMainFrame.getInstance(), "mail.success");
            }
        });
    }

    public static void ReminderReport(final SSMainFrame iMainFrame, final List<SSInvoice> iInvoices) {
        SSLanguageDialog iDialog = new SSLanguageDialog(iMainFrame, SSBundle.getBundle().getString("report.title.reminder"));
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Locale iLanguage = iDialog.getLanguage();
        final InternalFrameAdapter iRegisterAdapter = new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "invoiceframe.registerremainder", new Object[0]) != 0) {
                    return;
                }
                for (SSInvoice iInvoice : iInvoices) {
                    iInvoice.setNumRemainders(iInvoice.getNumReminders() + 1);
                    SSDB.getInstance().updateInvoice(iInvoice);
                }
            }
        };
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                LinkedList<SSInvoice> iInvoicesForCustomer;
                HashMap<SSCustomer, LinkedList<SSInvoice>> iInvoicesPerCustomer = new HashMap<SSCustomer, LinkedList<SSInvoice>>();
                for (SSInvoice iInvoice : iInvoices) {
                    SSCustomer iCustomer = iInvoice.getCustomer();
                    iInvoicesForCustomer = (LinkedList<SSInvoice>)iInvoicesPerCustomer.get(iCustomer);
                    if (iInvoicesForCustomer == null) {
                        iInvoicesForCustomer = new LinkedList<SSInvoice>();
                        iInvoicesPerCustomer.put(iCustomer, iInvoicesForCustomer);
                    }
                    iInvoicesForCustomer.add(iInvoice);
                }
                SSMultiPrinter iMultiPrinter = new SSMultiPrinter();
                for (Map.Entry ssCustomerListEntry : iInvoicesPerCustomer.entrySet()) {
                    iInvoicesForCustomer = (List)ssCustomerListEntry.getValue();
                    SSReminderPrinter iPrinter = new SSReminderPrinter(iInvoicesForCustomer, (SSCustomer)ssCustomerListEntry.getKey(), iLanguage);
                    iMultiPrinter.addReport(iPrinter);
                }
                iMultiPrinter.preview(iMainFrame, iRegisterAdapter);
            }
        });
    }

    public static void QuarterReport(final SSMainFrame iMainFrame) {
        SSQuarterReportDialog iDialog = new SSQuarterReportDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            return;
        }
        final Date iDate = iDialog.getDate();
        final Date iEndDate = iDialog.getEndDate();
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSQuarterReportPrinter iPrinter = new SSQuarterReportPrinter(Locale.getDefault(), iDate, iEndDate);
                iPrinter.preview(iMainFrame);
            }
        });
    }

    public static void InvoiceJournal(final SSMainFrame iMainFrame) {
        final String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "voucheriscreated");
            return;
        }
        SSAutoIncrement iAutoIncrement = SSDB.getInstance().getCurrentCompany().getAutoIncrement();
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(iMainFrame, SSBundle.getBundle().getString("invoicejournal.dialog.title"));
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.add(2, -1);
        iCalendar.set(5, iCalendar.getActualMinimum(5));
        Date iFirstDayOfMonth = iCalendar.getTime();
        iCalendar.set(5, iCalendar.getActualMaximum(5));
        Date iLastDayOfMonth = iCalendar.getTime();
        iDialog.setFrom(iFirstDayOfMonth);
        iDialog.setTo(iLastDayOfMonth);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            SSPostLock.removeLock(lockString);
            return;
        }
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        final LinkedList<SSInvoice> iFiltered = new LinkedList<SSInvoice>();
        for (SSInvoice iInvoice : iInvoices) {
            if (iInvoice.isEntered() || !SSInvoiceMath.inPeriod(iInvoice, iFrom, iTo)) continue;
            iFiltered.add(iInvoice);
        }
        if (iFiltered.isEmpty()) {
            SSPostLock.removeLock(lockString);
            new SSInformationDialog(iMainFrame, "invoicejournal.dialog.norows");
            return;
        }
        final Integer iNumber = iAutoIncrement.getNumber("invoicejournal") + 1;
        SSVoucher iVoucher = new SSVoucher();
        iVoucher.setDescription(String.format(SSBundle.getBundle().getString("invoicejournal.voucher.description"), iNumber));
        iVoucher.setDate(iTo);
        for (SSInvoice iInvoice : iFiltered) {
            SSVoucher iCurrent = iInvoice.generateVoucher();
            for (SSVoucherRow iRow : iCurrent.getRows()) {
                iVoucher.addVoucherRow(new SSVoucherRow(iRow));
            }
        }
        final SSVoucher iVoucher1 = SSVoucherMath.compress(iVoucher);
        final ActionListener iCloseListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSQueryDialog iDialog = new SSQueryDialog((JFrame)iMainFrame, SSBundle.getBundle(), "invoicejournal.dialog.register", iNumber, iVoucher1.getNumber());
                if (iDialog.getResponce() != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                for (SSInvoice iInvoice : iFiltered) {
                    iInvoice.setEntered();
                    SSDB.getInstance().updateInvoice(iInvoice);
                }
                SSNewCompany iCurrentCompany = SSDB.getInstance().getCurrentCompany();
                iCurrentCompany.getAutoIncrement().doAutoIncrement("invoicejournal");
                SSDB.getInstance().updateCompany(iCurrentCompany);
                SSDB.getInstance().addVoucher(iVoucher1, false);
                if (SSVoucherFrame.getInstance() != null) {
                    SSVoucherFrame.getInstance().getModel().fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
            }
        };
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSInvoicejournalPrinter iPrinter1 = new SSInvoicejournalPrinter(iFiltered, iNumber, iTo);
                SSVoucherPrinter iPrinter2 = new SSVoucherPrinter(iVoucher1, iPrinter1.getTitle());
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                iPrinter.addReport(iPrinter1);
                iPrinter.addReport(iPrinter2);
                iPrinter.preview(iMainFrame, iCloseListener);
            }
        });
    }

    public static void CreditInvoiceJournal(final SSMainFrame iMainFrame) {
        final String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "voucheriscreated");
            return;
        }
        SSAutoIncrement iAutoIncrement = SSDB.getInstance().getCurrentCompany().getAutoIncrement();
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(iMainFrame, SSBundle.getBundle().getString("creditinvoicejournal.dialog.title"));
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.add(2, -1);
        iCalendar.set(5, iCalendar.getActualMinimum(5));
        Date iFirstDayOfMonth = iCalendar.getTime();
        iCalendar.set(5, iCalendar.getActualMaximum(5));
        Date iLastDayOfMonth = iCalendar.getTime();
        iDialog.setFrom(iFirstDayOfMonth);
        iDialog.setTo(iLastDayOfMonth);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            SSPostLock.removeLock(lockString);
            return;
        }
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        final LinkedList<SSCreditInvoice> iFiltered = new LinkedList<SSCreditInvoice>();
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            if (iCreditInvoice.isEntered() || !SSInvoiceMath.inPeriod(iCreditInvoice, iFrom, iTo)) continue;
            iFiltered.add(iCreditInvoice);
        }
        if (iFiltered.isEmpty()) {
            SSPostLock.removeLock(lockString);
            new SSInformationDialog(iMainFrame, "creditinvoicejournal.dialog.norows");
            return;
        }
        final Integer iNumber = iAutoIncrement.getNumber("creditinvoicejournal") + 1;
        SSVoucher iVoucher = new SSVoucher();
        iVoucher.setDescription(String.format(SSBundle.getBundle().getString("creditinvoicejournal.voucher.description"), iNumber));
        iVoucher.setDate(iTo);
        for (SSCreditInvoice iCreditInvoice : iFiltered) {
            SSVoucher iCurrent = iCreditInvoice.generateVoucher();
            for (SSVoucherRow iRow : iCurrent.getRows()) {
                iVoucher.addVoucherRow(new SSVoucherRow(iRow));
            }
        }
        final SSVoucher iVoucher1 = SSVoucherMath.compress(iVoucher);
        final ActionListener iCloseListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSQueryDialog iDialog = new SSQueryDialog((JFrame)iMainFrame, SSBundle.getBundle(), "creditinvoicejournal.dialog.register", iNumber, iVoucher1.getNumber());
                if (iDialog.getResponce() != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                for (SSCreditInvoice iCreditInvoice : iFiltered) {
                    iCreditInvoice.setEntered();
                    SSDB.getInstance().updateCreditInvoice(iCreditInvoice);
                }
                SSNewCompany iCurrentCompany = SSDB.getInstance().getCurrentCompany();
                iCurrentCompany.getAutoIncrement().doAutoIncrement("creditinvoicejournal");
                SSDB.getInstance().updateCompany(iCurrentCompany);
                SSDB.getInstance().addVoucher(iVoucher1, false);
                if (SSVoucherFrame.getInstance() != null) {
                    SSVoucherFrame.getInstance().getModel().fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
            }
        };
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSCreditinvoicejournalPrinter iPrinter1 = new SSCreditinvoicejournalPrinter(iFiltered, iNumber, iTo);
                SSVoucherPrinter iPrinter2 = new SSVoucherPrinter(iVoucher1, iPrinter1.getTitle());
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                iPrinter.addReport(iPrinter1);
                iPrinter.addReport(iPrinter2);
                iPrinter.preview(iMainFrame, iCloseListener);
            }
        });
    }

    public static void InpaymentJournal(final SSMainFrame iMainFrame) {
        final String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "voucheriscreated");
            return;
        }
        SSAutoIncrement iAutoIncrement = SSDB.getInstance().getCurrentCompany().getAutoIncrement();
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(iMainFrame, SSBundle.getBundle().getString("inpaymentjournal.dialog.title"));
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.add(2, -1);
        iCalendar.set(5, iCalendar.getActualMinimum(5));
        Date iFirstDayOfMonth = iCalendar.getTime();
        iCalendar.set(5, iCalendar.getActualMaximum(5));
        Date iLastDayOfMonth = iCalendar.getTime();
        iDialog.setFrom(iFirstDayOfMonth);
        iDialog.setTo(iLastDayOfMonth);
        iDialog.setLocationRelativeTo(iMainFrame);
        if (iDialog.showDialog() != 0) {
            SSPostLock.removeLock(lockString);
            return;
        }
        List<SSInpayment> iInpayments = SSDB.getInstance().getInpayments();
        Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        final LinkedList<SSInpayment> iFiltered = new LinkedList<SSInpayment>();
        for (SSInpayment iInpayment : iInpayments) {
            if (iInpayment.isEntered() || !SSInpaymentMath.inPeriod(iInpayment, iFrom, iTo)) continue;
            iFiltered.add(iInpayment);
        }
        if (iFiltered.isEmpty()) {
            SSPostLock.removeLock(lockString);
            new SSInformationDialog(iMainFrame, "inpaymentjournal.dialog.norows");
            return;
        }
        final Integer iNumber = iAutoIncrement.getNumber("inpaymentjournal") + 1;
        SSVoucher iVoucher = new SSVoucher();
        iVoucher.setDescription(String.format(SSBundle.getBundle().getString("inpaymentjournal.voucher.description"), iNumber));
        iVoucher.setDate(iTo);
        for (SSInpayment iInpayment : iFiltered) {
            SSVoucher iCurrent = iInpayment.generateVoucher();
            for (SSVoucherRow iRow : iCurrent.getRows()) {
                iVoucher.addVoucherRow(new SSVoucherRow(iRow));
            }
        }
        final SSVoucher iVoucher1 = SSVoucherMath.compress(iVoucher);
        final ActionListener iCloseListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSQueryDialog iDialog = new SSQueryDialog((JFrame)iMainFrame, SSBundle.getBundle(), "inpaymentjournal.dialog.register", iNumber, iVoucher1.getNumber());
                if (iDialog.getResponce() != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                for (SSInpayment iInpayment : iFiltered) {
                    iInpayment.setEntered();
                    SSDB.getInstance().updateInpayment(iInpayment);
                }
                SSNewCompany iCurrentCompany = SSDB.getInstance().getCurrentCompany();
                iCurrentCompany.getAutoIncrement().doAutoIncrement("inpaymentjournal");
                SSDB.getInstance().updateCompany(iCurrentCompany);
                SSDB.getInstance().addVoucher(iVoucher1, false);
                if (SSVoucherFrame.getInstance() != null) {
                    SSVoucherFrame.getInstance().getModel().fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
            }
        };
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSInpaymentjournalPrinter iPrinter1 = new SSInpaymentjournalPrinter(iFiltered, iNumber, iTo);
                SSVoucherPrinter iPrinter2 = new SSVoucherPrinter(iVoucher1, iPrinter1.getTitle());
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                iPrinter.addReport(iPrinter1);
                iPrinter.addReport(iPrinter2);
                iPrinter.preview(iMainFrame, iCloseListener);
            }
        });
    }

    public static void SupplierInvoiceJournal(final SSMainFrame iMainFrame) {
        final String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "voucheriscreated");
            return;
        }
        SSAutoIncrement iAutoIncrement = SSDB.getInstance().getCurrentCompany().getAutoIncrement();
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(iMainFrame, SSBundle.getBundle().getString("supplierinvoicejournal.dialog.title"));
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.add(2, -1);
        iCalendar.set(5, iCalendar.getActualMinimum(5));
        Date iFirstDayOfMonth = iCalendar.getTime();
        iCalendar.set(5, iCalendar.getActualMaximum(5));
        Date iLastDayOfMonth = iCalendar.getTime();
        iDialog.setFrom(iFirstDayOfMonth);
        iDialog.setTo(iLastDayOfMonth);
        iDialog.setLocationRelativeTo(iMainFrame);
        int iResponce = iDialog.showDialog();
        if (iResponce != 0) {
            SSPostLock.removeLock(lockString);
            return;
        }
        List<SSSupplierInvoice> iInvoices = SSDB.getInstance().getSupplierInvoices();
        Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        final LinkedList<SSSupplierInvoice> iFiltered = new LinkedList<SSSupplierInvoice>();
        for (SSSupplierInvoice iInvoice : iInvoices) {
            if (iInvoice.isEntered() || !SSSupplierInvoiceMath.inPeriod(iInvoice, iFrom, iTo)) continue;
            iFiltered.add(iInvoice);
        }
        if (iFiltered.isEmpty()) {
            SSPostLock.removeLock(lockString);
            new SSInformationDialog(iMainFrame, "supplierinvoicejournal.dialog.norows");
            return;
        }
        final Integer iNumber = iAutoIncrement.getNumber("supplierinvoicejournal") + 1;
        SSVoucher iVoucher = new SSVoucher();
        iVoucher.setDescription(String.format(SSBundle.getBundle().getString("supplierinvoicejournal.voucher.description"), iNumber));
        iVoucher.setDate(iTo);
        for (SSSupplierInvoice iInvoice : iFiltered) {
            SSVoucher iCurrent = iInvoice.generateVoucher();
            for (SSVoucherRow iRow : iCurrent.getRows()) {
                iVoucher.addVoucherRow(new SSVoucherRow(iRow));
            }
        }
        final SSVoucher iVoucher1 = SSVoucherMath.compress(iVoucher);
        final ActionListener iCloseListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSQueryDialog iDialog = new SSQueryDialog((JFrame)iMainFrame, SSBundle.getBundle(), "supplierinvoicejournal.dialog.register", iNumber, iVoucher1.getNumber());
                int iResponce = iDialog.getResponce();
                if (iResponce != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                for (SSSupplierInvoice iInvoice : iFiltered) {
                    iInvoice.setEntered();
                    SSDB.getInstance().updateSupplierInvoice(iInvoice);
                }
                SSNewCompany iCurrentCompany = SSDB.getInstance().getCurrentCompany();
                iCurrentCompany.getAutoIncrement().doAutoIncrement("supplierinvoicejournal");
                SSDB.getInstance().updateCompany(iCurrentCompany);
                SSDB.getInstance().addVoucher(iVoucher1, false);
                if (SSVoucherFrame.getInstance() != null) {
                    SSVoucherFrame.getInstance().getModel().fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
            }
        };
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSSupplierInvoicejournalPrinter iPrinter1 = new SSSupplierInvoicejournalPrinter(iFiltered, iNumber, iTo);
                SSVoucherPrinter iPrinter2 = new SSVoucherPrinter(iVoucher1, iPrinter1.getTitle());
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                iPrinter.addReport(iPrinter1);
                iPrinter.addReport(iPrinter2);
                iPrinter.preview(iMainFrame, iCloseListener);
            }
        });
    }

    public static void SupplierCreditInvoiceJournal(final SSMainFrame iMainFrame) {
        final String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "voucheriscreated");
            return;
        }
        SSAutoIncrement iAutoIncrement = SSDB.getInstance().getCurrentCompany().getAutoIncrement();
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(iMainFrame, SSBundle.getBundle().getString("suppliercreditinvoicejournal.dialog.title"));
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.add(2, -1);
        iCalendar.set(5, iCalendar.getActualMinimum(5));
        Date iFirstDayOfMonth = iCalendar.getTime();
        iCalendar.set(5, iCalendar.getActualMaximum(5));
        Date iLastDayOfMonth = iCalendar.getTime();
        iDialog.setFrom(iFirstDayOfMonth);
        iDialog.setTo(iLastDayOfMonth);
        iDialog.setLocationRelativeTo(iMainFrame);
        int iResponce = iDialog.showDialog();
        if (iResponce != 0) {
            SSPostLock.removeLock(lockString);
            return;
        }
        List<SSSupplierCreditInvoice> iInvoices = SSDB.getInstance().getSupplierCreditInvoices();
        Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        final LinkedList<SSSupplierCreditInvoice> iFiltered = new LinkedList<SSSupplierCreditInvoice>();
        for (SSSupplierCreditInvoice iInvoice : iInvoices) {
            if (iInvoice.isEntered() || !SSSupplierCreditInvoiceMath.inPeriod(iInvoice, iFrom, iTo)) continue;
            iFiltered.add(iInvoice);
        }
        if (iFiltered.isEmpty()) {
            SSPostLock.removeLock(lockString);
            new SSInformationDialog(iMainFrame, "suppliercreditinvoicejournal.dialog.norows");
            return;
        }
        final Integer iNumber = iAutoIncrement.getNumber("suppliercreditinvoicejournal") + 1;
        SSVoucher iVoucher = new SSVoucher();
        iVoucher.setDescription(String.format(SSBundle.getBundle().getString("suppliercreditinvoicejournal.voucher.description"), iNumber));
        iVoucher.setDate(iTo);
        for (SSSupplierCreditInvoice iInvoice : iFiltered) {
            SSVoucher iCurrent = iInvoice.generateVoucher();
            for (SSVoucherRow iRow : iCurrent.getRows()) {
                iVoucher.addVoucherRow(new SSVoucherRow(iRow));
            }
        }
        final SSVoucher iVoucher1 = SSVoucherMath.compress(iVoucher);
        final ActionListener iCloseListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSQueryDialog iDialog = new SSQueryDialog((JFrame)iMainFrame, SSBundle.getBundle(), "suppliercreditinvoicejournal.dialog.register", iNumber, iVoucher1.getNumber());
                int iResponce = iDialog.getResponce();
                if (iResponce != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                for (SSSupplierCreditInvoice iInvoice : iFiltered) {
                    iInvoice.setEntered();
                    SSDB.getInstance().updateSupplierCreditInvoice(iInvoice);
                }
                SSNewCompany iCurrentCompany = SSDB.getInstance().getCurrentCompany();
                iCurrentCompany.getAutoIncrement().doAutoIncrement("suppliercreditinvoicejournal");
                SSDB.getInstance().updateCompany(iCurrentCompany);
                SSDB.getInstance().addVoucher(iVoucher1, false);
                if (SSVoucherFrame.getInstance() != null) {
                    SSVoucherFrame.getInstance().getModel().fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
            }
        };
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSSuppliercreditinvoicejournalPrinter iPrinter1 = new SSSuppliercreditinvoicejournalPrinter(iFiltered, iNumber, iTo);
                SSVoucherPrinter iPrinter2 = new SSVoucherPrinter(iVoucher1, iPrinter1.getTitle());
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                iPrinter.addReport(iPrinter1);
                iPrinter.addReport(iPrinter2);
                iPrinter.preview(iMainFrame, iCloseListener);
            }
        });
    }

    public static void OutpaymentJournal(final SSMainFrame iMainFrame) {
        final String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "voucheriscreated");
            return;
        }
        SSAutoIncrement iAutoIncrement = SSDB.getInstance().getCurrentCompany().getAutoIncrement();
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(iMainFrame, SSBundle.getBundle().getString("outpaymentjournal.dialog.title"));
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.add(2, -1);
        iCalendar.set(5, iCalendar.getActualMinimum(5));
        Date iFirstDayOfMonth = iCalendar.getTime();
        iCalendar.set(5, iCalendar.getActualMaximum(5));
        Date iLastDayOfMonth = iCalendar.getTime();
        iDialog.setFrom(iFirstDayOfMonth);
        iDialog.setTo(iLastDayOfMonth);
        iDialog.setLocationRelativeTo(iMainFrame);
        int iResponce = iDialog.showDialog();
        if (iResponce != 0) {
            SSPostLock.removeLock(lockString);
            return;
        }
        List<SSOutpayment> iOutpayments = SSDB.getInstance().getOutpayments();
        Date iFrom = iDialog.getFrom();
        final Date iTo = iDialog.getTo();
        final LinkedList<SSOutpayment> iFiltered = new LinkedList<SSOutpayment>();
        for (SSOutpayment iOutpayment : iOutpayments) {
            if (iOutpayment.isEntered() || !SSOutpaymentMath.inPeriod(iOutpayment, iFrom, iTo)) continue;
            iFiltered.add(iOutpayment);
        }
        if (iFiltered.isEmpty()) {
            SSPostLock.removeLock(lockString);
            new SSInformationDialog(iMainFrame, "outpaymentjournal.dialog.norows");
            return;
        }
        final Integer iNumber = iAutoIncrement.getNumber("outpaymentjournal") + 1;
        SSVoucher iVoucher = new SSVoucher();
        iVoucher.setDescription(String.format(SSBundle.getBundle().getString("outpaymentjournal.voucher.description"), iNumber));
        iVoucher.setDate(iTo);
        for (SSOutpayment iOutpayment : iFiltered) {
            SSVoucher iCurrent = iOutpayment.generateVoucher();
            for (SSVoucherRow iRow : iCurrent.getRows()) {
                iVoucher.addVoucherRow(new SSVoucherRow(iRow));
            }
        }
        final SSVoucher iVoucher1 = SSVoucherMath.compress(iVoucher);
        final ActionListener iCloseListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSQueryDialog iDialog = new SSQueryDialog((JFrame)iMainFrame, SSBundle.getBundle(), "outpaymentjournal.dialog.register", iNumber, iVoucher1.getNumber());
                int iResponce = iDialog.getResponce();
                if (iResponce != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                for (SSOutpayment iOutpayment : iFiltered) {
                    iOutpayment.setEntered();
                    SSDB.getInstance().updateOutpayment(iOutpayment);
                }
                SSNewCompany iCurrentCompany = SSDB.getInstance().getCurrentCompany();
                iCurrentCompany.getAutoIncrement().doAutoIncrement("outpaymentjournal");
                SSDB.getInstance().updateCompany(iCurrentCompany);
                SSDB.getInstance().addVoucher(iVoucher1, false);
                if (SSVoucherFrame.getInstance() != null) {
                    SSVoucherFrame.getInstance().getModel().fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
            }
        };
        SSProgressDialog.runProgress(iMainFrame, new Runnable(){

            @Override
            public void run() {
                SSOutpaymentjournalPrinter iPrinter1 = new SSOutpaymentjournalPrinter(iFiltered, iNumber, iTo);
                SSVoucherPrinter iPrinter2 = new SSVoucherPrinter(iVoucher1, iPrinter1.getTitle());
                SSMultiPrinter iPrinter = new SSMultiPrinter();
                iPrinter.addReport(iPrinter1);
                iPrinter.addReport(iPrinter2);
                iPrinter.preview(iMainFrame, iCloseListener);
            }
        });
    }
}

