/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.dialog;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.swedsoft.bookkeeping.calc.math.SSOutdeliveryMath;
import se.swedsoft.bookkeeping.calc.math.SSProductMath;
import se.swedsoft.bookkeeping.calc.util.SSFilter;
import se.swedsoft.bookkeeping.calc.util.SSFilterFactory;
import se.swedsoft.bookkeeping.data.SSOutdelivery;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.product.util.SSProductTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;

public class SSOutdeliveryListDialog
extends SSDialog {
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private JCheckBox iCheckDate;
    private JCheckBox iCheckProduct;
    private SSTableComboBox<SSProduct> iProduct;
    private SSDateChooser iToDate;
    private SSDateChooser iFromDate;

    public SSOutdeliveryListDialog(SSMainFrame iMainFrame) {
        super(iMainFrame, SSBundle.getBundle().getString("outdeliverylistreport.dialog.title"));
        this.$$$setupUI$$$();
        this.setPanel(this.iPanel);
        this.iButtonPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutdeliveryListDialog.this.setModalResult(2, true);
            }
        });
        this.iButtonPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutdeliveryListDialog.this.setModalResult(0, true);
            }
        });
        this.getRootPane().setDefaultButton(this.iButtonPanel.getOkButton());
        this.iProduct.setModel(SSProductTableModel.getDropDownModel(SSProductMath.getNormalProducts()));
        this.iProduct.setSearchColumns(0);
        this.iProduct.setSelected(this.iProduct.getFirst());
        ChangeListener iChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SSOutdeliveryListDialog.this.iProduct.setEnabled(SSOutdeliveryListDialog.this.iCheckProduct.isSelected());
                SSOutdeliveryListDialog.this.iFromDate.setEnabled(SSOutdeliveryListDialog.this.iCheckDate.isSelected());
                SSOutdeliveryListDialog.this.iToDate.setEnabled(SSOutdeliveryListDialog.this.iCheckDate.isSelected());
            }
        };
        this.iCheckDate.addChangeListener(iChangeListener);
        this.iCheckProduct.addChangeListener(iChangeListener);
        iChangeListener.stateChanged(null);
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public List<SSOutdelivery> getElementsToPrint() {
        List<SSOutdelivery> iOutdeliveries = SSDB.getInstance().getOutdeliveries();
        if (this.iCheckProduct.isSelected() && this.iProduct.getSelected() != null) {
            final SSProduct iProduct = this.iProduct.getSelected();
            iOutdeliveries = SSFilterFactory.doFilter(iOutdeliveries, new SSFilter<SSOutdelivery>(){

                @Override
                public boolean applyFilter(SSOutdelivery iIndelivery) {
                    return SSOutdeliveryMath.hasProduct(iIndelivery, iProduct);
                }
            });
        }
        if (this.iCheckDate.isSelected()) {
            final Date iDateFrom = this.iFromDate.getDate();
            final Date iDateTo = this.iToDate.getDate();
            iOutdeliveries = SSFilterFactory.doFilter(iOutdeliveries, new SSFilter<SSOutdelivery>(){

                @Override
                public boolean applyFilter(SSOutdelivery iIndelivery) {
                    return SSOutdeliveryMath.inPeriod(iIndelivery, iDateFrom, iDateTo);
                }
            });
        }
        return iOutdeliveries;
    }

    public boolean isDateSelected() {
        return this.iCheckDate.isSelected();
    }

    public boolean isProductSelected() {
        return this.iCheckProduct.isSelected();
    }

    public Date getDateFrom() {
        return this.iFromDate.getDate();
    }

    public Date getDateTo() {
        return this.iToDate.getDate();
    }

    public SSProduct getProduct() {
        return this.iProduct.getSelected();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.dialog.SSOutdeliveryListDialog");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iCheckDate=").append(this.iCheckDate);
        sb.append(", iCheckProduct=").append(this.iCheckProduct);
        sb.append(", iFromDate=").append(this.iFromDate);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iProduct=").append(this.iProduct);
        sb.append(", iToDate=").append(this.iToDate);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        SSDateChooser sSDateChooser;
        SSDateChooser sSDateChooser2;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(4, 4, new Insets(4, 4, 4, 4), 4, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("date.separator"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.iFromDate = sSDateChooser2 = new SSDateChooser();
        sSDateChooser2.setFocusTraversalPolicyProvider(false);
        sSDateChooser2.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel2.add((Component)sSDateChooser2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        this.iToDate = sSDateChooser = new SSDateChooser();
        sSDateChooser.setFocusTraversalPolicyProvider(false);
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel2.add((Component)sSDateChooser, new GridConstraints(2, 3, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("outdeliverylistreport.dialog.description"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.iCheckProduct = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("book").getString("outdeliverylistreport.dialog.product"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iCheckDate = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("outdeliverylistreport.dialog.date"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iProduct = sSTableComboBox;
        jPanel2.add(sSTableComboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

