/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.dialog;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.swedsoft.bookkeeping.calc.math.SSSupplierCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.util.SSFilter;
import se.swedsoft.bookkeeping.calc.util.SSFilterFactory;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierCreditInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.supplier.util.SSSupplierTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;

public class SSSupplierCreditInvoiceListDialog
extends SSDialog {
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private JCheckBox iCheckDate;
    private JCheckBox iCheckSupplier;
    private SSTableComboBox<SSSupplier> iSupplier;
    private SSDateChooser iToDate;
    private SSDateChooser iFromDate;

    public SSSupplierCreditInvoiceListDialog(SSMainFrame iMainFrame) {
        super(iMainFrame, SSBundle.getBundle().getString("suppliercreditinvoicelistreport.dialog.title"));
        this.$$$setupUI$$$();
        this.setPanel(this.iPanel);
        this.iButtonPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierCreditInvoiceListDialog.this.setModalResult(2, true);
            }
        });
        this.iButtonPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierCreditInvoiceListDialog.this.setModalResult(0, true);
            }
        });
        this.getRootPane().setDefaultButton(this.iButtonPanel.getOkButton());
        this.iSupplier.setModel(SSSupplierTableModel.getDropDownModel());
        this.iSupplier.setSearchColumns(0);
        ChangeListener iChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SSSupplierCreditInvoiceListDialog.this.iSupplier.setEnabled(SSSupplierCreditInvoiceListDialog.this.iCheckSupplier.isSelected());
                SSSupplierCreditInvoiceListDialog.this.iFromDate.setEnabled(SSSupplierCreditInvoiceListDialog.this.iCheckDate.isSelected());
                SSSupplierCreditInvoiceListDialog.this.iToDate.setEnabled(SSSupplierCreditInvoiceListDialog.this.iCheckDate.isSelected());
            }
        };
        this.iCheckDate.addChangeListener(iChangeListener);
        this.iCheckSupplier.addChangeListener(iChangeListener);
        iChangeListener.stateChanged(null);
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public List<SSSupplierCreditInvoice> getElementsToPrint() {
        List<SSSupplierCreditInvoice> iInvoices = SSDB.getInstance().getSupplierCreditInvoices();
        SSFilterFactory<SSSupplierCreditInvoice> iFactory = new SSFilterFactory<SSSupplierCreditInvoice>(iInvoices);
        if (this.iCheckSupplier.isSelected() && this.iSupplier.getSelected() != null) {
            final SSSupplier iSupplier = this.iSupplier.getSelected();
            iFactory.applyFilter(new SSFilter<SSSupplierCreditInvoice>(){

                @Override
                public boolean applyFilter(SSSupplierCreditInvoice iInvoice) {
                    return iInvoice.hasSupplier(iSupplier);
                }
            });
        }
        if (this.iCheckDate.isSelected()) {
            final Date iDateFrom = this.iFromDate.getDate();
            final Date iDateTo = this.iToDate.getDate();
            iFactory.applyFilter(new SSFilter<SSSupplierCreditInvoice>(){

                @Override
                public boolean applyFilter(SSSupplierCreditInvoice iInvoice) {
                    return SSSupplierCreditInvoiceMath.inPeriod(iInvoice, iDateFrom, iDateTo);
                }
            });
        }
        return iFactory.getObjects();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.dialog.SSSupplierCreditInvoiceListDialog");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iCheckDate=").append(this.iCheckDate);
        sb.append(", iCheckSupplier=").append(this.iCheckSupplier);
        sb.append(", iFromDate=").append(this.iFromDate);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iSupplier=").append(this.iSupplier);
        sb.append(", iToDate=").append(this.iToDate);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        SSDateChooser sSDateChooser;
        SSDateChooser sSDateChooser2;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(4, 4, new Insets(4, 4, 4, 4), 4, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("date.separator"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.iFromDate = sSDateChooser2 = new SSDateChooser();
        sSDateChooser2.setFocusTraversalPolicyProvider(false);
        sSDateChooser2.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel2.add((Component)sSDateChooser2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        this.iToDate = sSDateChooser = new SSDateChooser();
        sSDateChooser.setFocusTraversalPolicyProvider(false);
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel2.add((Component)sSDateChooser, new GridConstraints(2, 3, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("suppliercreditinvoicelistreport.dialog.description"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.iCheckSupplier = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("book").getString("suppliercreditinvoicelistreport.dialog.supplier"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iCheckDate = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("suppliercreditinvoicelistreport.dialog.date"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iSupplier = sSTableComboBox;
        jPanel2.add(sSTableComboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

