/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSAccountPlanPrinter
extends SSPrinter {
    SSAccountPlan iAccountPlan;

    public SSAccountPlanPrinter() {
        this(SSDB.getInstance().getCurrentYear().getAccountPlan());
    }

    public SSAccountPlanPrinter(SSAccountPlan pAccountPlan) {
        this.iAccountPlan = pAccountPlan;
        this.setPageHeader("header.jrxml");
        this.setColumnHeader("accountplan.jrxml");
        this.setDetail("accountplan.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("accountplanreport.title");
    }

    @Override
    protected String getSubTitle() {
        return this.iAccountPlan.getName();
    }

    @Override
    protected SSDefaultTableModel getModel() {
        SSDefaultTableModel<SSAccount> iModel = new SSDefaultTableModel<SSAccount>(){

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                SSAccount iAccount = (SSAccount)this.getObject(rowIndex);
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iAccount.getNumber();
                        break;
                    }
                    case 1: {
                        value = iAccount.getDescription();
                        break;
                    }
                    case 2: {
                        value = iAccount.getVATCode();
                        break;
                    }
                    case 3: {
                        value = iAccount.getSRUCode();
                        break;
                    }
                    case 4: {
                        value = iAccount.getReportCode();
                    }
                }
                return value;
            }
        };
        iModel.addColumn("account.number");
        iModel.addColumn("account.description");
        iModel.addColumn("account.vat");
        iModel.addColumn("account.sru");
        iModel.addColumn("account.report");
        iModel.setObjects(this.iAccountPlan.getActiveAccounts());
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSAccountPlanPrinter");
        sb.append("{iAccountPlan=").append(this.iAccountPlan);
        sb.append('}');
        return sb.toString();
    }
}

