/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSOutpaymentMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierMath;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSAccountsPayablePrinter
extends SSPrinter {
    private SSInvoicePrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSSupplier> iSuppliers;
    private Date iDate;
    Map<String, List<SSSupplierInvoice>> iSupplierInvoicesMap;
    HashMap<Integer, BigDecimal> iOutpaymentSum;
    HashMap<Integer, BigDecimal> iSupplierCreditInvoiceSum;

    public SSAccountsPayablePrinter(Date iDate) {
        this(iDate, SSDB.getInstance().getSuppliers());
    }

    public SSAccountsPayablePrinter(Date iDate, List<SSSupplier> iSuppliers) {
        this.iSuppliers = iSuppliers;
        this.iDate = iDate;
        Date iCeiledDate = SSDateMath.ceil(this.iDate);
        this.iOutpaymentSum = SSOutpaymentMath.getSumsForSupplierInvoices(iCeiledDate);
        this.iSupplierCreditInvoiceSum = SSSupplierCreditInvoiceMath.getSumsForSupplierInvoices(iCeiledDate);
        this.iSupplierInvoicesMap = new HashMap<String, List<SSSupplierInvoice>>();
        for (String iSupplierNumber : SSSupplierMath.iInvoicesForSuppliers.keySet()) {
            LinkedList<SSSupplierInvoice> iInvoicesForCustomer = new LinkedList<SSSupplierInvoice>();
            for (SSSupplierInvoice iInvoice : SSSupplierMath.iInvoicesForSuppliers.get(iSupplierNumber)) {
                if (!iInvoice.getDate().before(iCeiledDate)) continue;
                iInvoicesForCustomer.add(iInvoice);
            }
            this.iSupplierInvoicesMap.put(iSupplierNumber, iInvoicesForCustomer);
        }
        this.addParameter("periodTitle", this.iBundle.getString("accountspayablereport.periodtitle"));
        this.addParameter("periodText", iDate);
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("accountspayable.jrxml");
        this.setDetail("accountspayable.jrxml");
        this.setSummary("accountspayable.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("accountspayablereport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSInvoicePrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSSupplier> iModel = new SSDefaultTableModel<SSSupplier>(){

            @Override
            public Class getType() {
                return SSSupplier.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSSupplier iSupplier = (SSSupplier)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iSupplier.getNumber();
                        break;
                    }
                    case 1: {
                        value = iSupplier.getName();
                        break;
                    }
                    case 2: {
                        List<SSSupplierInvoice> iInvoices = SSAccountsPayablePrinter.this.iSupplierInvoicesMap.get(iSupplier.getNumber());
                        BigDecimal iSum = new BigDecimal(0);
                        for (SSSupplierInvoice iInvoice : iInvoices) {
                            BigDecimal iSaldo = SSSupplierInvoiceMath.getTotalSum(iInvoice);
                            if (SSAccountsPayablePrinter.this.iOutpaymentSum.containsKey(iInvoice.getNumber())) {
                                iSaldo = iSaldo.subtract(SSAccountsPayablePrinter.this.iOutpaymentSum.get(iInvoice.getNumber()));
                            }
                            if (SSAccountsPayablePrinter.this.iSupplierCreditInvoiceSum.containsKey(iInvoice.getNumber())) {
                                iSaldo = iSaldo.subtract(SSAccountsPayablePrinter.this.iSupplierCreditInvoiceSum.get(iInvoice.getNumber()));
                            }
                            iSum = iSum.add(SSSupplierInvoiceMath.convertToLocal(iInvoice, iSaldo));
                        }
                        value = iSum;
                        break;
                    }
                    case 3: {
                        SSAccountsPayablePrinter.this.iPrinter.setSupplier(iSupplier);
                        SSAccountsPayablePrinter.this.iDataSource.reset();
                        value = SSAccountsPayablePrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("supplier.number");
        iModel.addColumn("supplier.name");
        iModel.addColumn("supplier.saldosum");
        iModel.addColumn("supplier.invoices");
        Collections.sort(this.iSuppliers, new Comparator<SSSupplier>(){

            @Override
            public int compare(SSSupplier o1, SSSupplier o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        iModel.setObjects(this.iSuppliers);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSAccountsPayablePrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iOutpaymentSum=").append(this.iOutpaymentSum);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append(", iSupplierCreditInvoiceSum=").append(this.iSupplierCreditInvoiceSum);
        sb.append(", iSupplierInvoicesMap=").append(this.iSupplierInvoicesMap);
        sb.append(", iSuppliers=").append(this.iSuppliers);
        sb.append('}');
        return sb.toString();
    }

    private class SSInvoicePrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSSupplierInvoice> iModel;

        public SSInvoicePrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("accountspayable.row.jrxml");
            this.setSummary("accountspayable.row.jrxml");
            this.iModel = new SSDefaultTableModel<SSSupplierInvoice>(){
                DateFormat iFormat = DateFormat.getDateInstance(3);

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSSupplierInvoice iInvoice = (SSSupplierInvoice)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iInvoice.getNumber();
                            break;
                        }
                        case 1: {
                            value = this.iFormat.format(iInvoice.getDate());
                            break;
                        }
                        case 2: {
                            value = iInvoice.getCurrency() == null ? null : iInvoice.getCurrency().getName();
                            break;
                        }
                        case 3: {
                            value = SSSupplierInvoiceMath.getTotalSum(iInvoice);
                            break;
                        }
                        case 4: {
                            value = SSAccountsPayablePrinter.this.iSupplierCreditInvoiceSum.get(iInvoice.getNumber()) == null ? new BigDecimal(0) : SSAccountsPayablePrinter.this.iSupplierCreditInvoiceSum.get(iInvoice.getNumber());
                            break;
                        }
                        case 5: {
                            value = SSAccountsPayablePrinter.this.iOutpaymentSum.get(iInvoice.getNumber()) == null ? new BigDecimal(0) : SSAccountsPayablePrinter.this.iOutpaymentSum.get(iInvoice.getNumber());
                            break;
                        }
                        case 6: {
                            value = iInvoice.getCurrencyRate();
                            break;
                        }
                        case 7: {
                            BigDecimal iSaldo = SSSupplierInvoiceMath.getTotalSum(iInvoice);
                            if (SSAccountsPayablePrinter.this.iOutpaymentSum.containsKey(iInvoice.getNumber())) {
                                iSaldo = iSaldo.subtract(SSAccountsPayablePrinter.this.iOutpaymentSum.get(iInvoice.getNumber()));
                            }
                            if (SSAccountsPayablePrinter.this.iSupplierCreditInvoiceSum.containsKey(iInvoice.getNumber())) {
                                iSaldo = iSaldo.subtract(SSAccountsPayablePrinter.this.iSupplierCreditInvoiceSum.get(iInvoice.getNumber()));
                            }
                            value = SSSupplierInvoiceMath.convertToLocal(iInvoice, iSaldo);
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("supplierinvoice.number");
            this.iModel.addColumn("supplierinvoice.date");
            this.iModel.addColumn("supplierinvoice.currency");
            this.iModel.addColumn("supplierinvoice.value");
            this.iModel.addColumn("supplierinvoice.credited");
            this.iModel.addColumn("supplierinvoice.payed");
            this.iModel.addColumn("supplierinvoice.currencyrate");
            this.iModel.addColumn("supplierinvoice.localsaldo");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setSupplier(SSSupplier iSupplier) {
            List<SSSupplierInvoice> iInvoices = SSAccountsPayablePrinter.this.iSupplierInvoicesMap.get(iSupplier.getNumber());
            this.iModel.setObjects(iInvoices);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSAccountsPayablePrinter.SSInvoicePrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

