/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSCustomerMath;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSInpaymentMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSInvoiceType;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSAccountsRecievablePrinter
extends SSPrinter {
    private SSInvoicePrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSCustomer> iCustomers;
    private Date iDate;
    Map<String, List<SSInvoice>> iCustomerInvoicesMap;
    HashMap<Integer, BigDecimal> iInpaymentSum;
    HashMap<Integer, BigDecimal> iCreditInvoiceSum;

    public SSAccountsRecievablePrinter(Date iDate) {
        this(iDate, SSDB.getInstance().getCustomers());
    }

    public SSAccountsRecievablePrinter(Date iDate, List<SSCustomer> iCustomers) {
        this.iCustomers = iCustomers;
        this.iDate = iDate;
        Date iCeiledDate = SSDateMath.ceil(this.iDate);
        this.iInpaymentSum = SSInpaymentMath.getSumsForInvoices(iCeiledDate);
        this.iCreditInvoiceSum = SSCreditInvoiceMath.getSumsForInvoices(iCeiledDate);
        this.iCustomerInvoicesMap = new HashMap<String, List<SSInvoice>>();
        for (String iCustomerNumber : SSCustomerMath.iInvoicesForCustomers.keySet()) {
            LinkedList<SSInvoice> iInvoicesForCustomer = new LinkedList<SSInvoice>();
            for (SSInvoice iInvoice : SSCustomerMath.iInvoicesForCustomers.get(iCustomerNumber)) {
                if (!iInvoice.getDate().before(iCeiledDate) || iInvoice.getType() == SSInvoiceType.CASH) continue;
                iInvoicesForCustomer.add(iInvoice);
            }
            this.iCustomerInvoicesMap.put(iCustomerNumber, iInvoicesForCustomer);
        }
        this.addParameter("periodTitle", this.iBundle.getString("accountsrecievablereport.periodtitle"));
        this.addParameter("periodText", iDate);
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("accountsrecievable.jrxml");
        this.setDetail("accountsrecievable.jrxml");
        this.setSummary("accountsrecievable.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("accountsrecievablereport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSInvoicePrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSCustomer> iModel = new SSDefaultTableModel<SSCustomer>(){

            @Override
            public Class getType() {
                return SSCustomer.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSCustomer iCustomer = (SSCustomer)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iCustomer.getNumber();
                        break;
                    }
                    case 1: {
                        value = iCustomer.getName();
                        break;
                    }
                    case 2: {
                        List<SSInvoice> iInvoices = SSAccountsRecievablePrinter.this.iCustomerInvoicesMap.get(iCustomer.getNumber());
                        BigDecimal iSum = new BigDecimal(0);
                        for (SSInvoice iInvoice : iInvoices) {
                            BigDecimal iSaldo = SSInvoiceMath.getTotalSum(iInvoice);
                            if (SSAccountsRecievablePrinter.this.iInpaymentSum.containsKey(iInvoice.getNumber())) {
                                iSaldo = iSaldo.subtract(SSAccountsRecievablePrinter.this.iInpaymentSum.get(iInvoice.getNumber()));
                            }
                            if (SSAccountsRecievablePrinter.this.iCreditInvoiceSum.containsKey(iInvoice.getNumber())) {
                                iSaldo = iSaldo.subtract(SSAccountsRecievablePrinter.this.iCreditInvoiceSum.get(iInvoice.getNumber()));
                            }
                            iSum = iSum.add(SSInvoiceMath.convertToLocal(iInvoice, iSaldo));
                        }
                        value = iSum;
                        break;
                    }
                    case 3: {
                        SSAccountsRecievablePrinter.this.iPrinter.setCustomer(iCustomer);
                        SSAccountsRecievablePrinter.this.iDataSource.reset();
                        value = SSAccountsRecievablePrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("customer.number");
        iModel.addColumn("customer.name");
        iModel.addColumn("customer.saldosum");
        iModel.addColumn("customer.invoices");
        Collections.sort(this.iCustomers, new Comparator<SSCustomer>(){

            @Override
            public int compare(SSCustomer o1, SSCustomer o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        iModel.setObjects(this.iCustomers);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSAccountsRecievablePrinter");
        sb.append("{iCreditInvoiceSum=").append(this.iCreditInvoiceSum);
        sb.append(", iCustomerInvoicesMap=").append(this.iCustomerInvoicesMap);
        sb.append(", iCustomers=").append(this.iCustomers);
        sb.append(", iDataSource=").append(this.iDataSource);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iInpaymentSum=").append(this.iInpaymentSum);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSInvoicePrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSInvoice> iModel;

        public SSInvoicePrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("accountsrecievable.row.jrxml");
            this.setSummary("accountsrecievable.row.jrxml");
            this.iModel = new SSDefaultTableModel<SSInvoice>(){
                DateFormat iFormat = DateFormat.getDateInstance(3);

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSInvoice iInvoice = (SSInvoice)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iInvoice.getNumber();
                            break;
                        }
                        case 1: {
                            value = this.iFormat.format(iInvoice.getDate());
                            break;
                        }
                        case 2: {
                            value = iInvoice.getCurrency() == null ? null : iInvoice.getCurrency().getName();
                            break;
                        }
                        case 3: {
                            value = SSInvoiceMath.getTotalSum(iInvoice);
                            break;
                        }
                        case 4: {
                            value = SSAccountsRecievablePrinter.this.iCreditInvoiceSum.get(iInvoice.getNumber()) == null ? new BigDecimal(0) : SSAccountsRecievablePrinter.this.iCreditInvoiceSum.get(iInvoice.getNumber());
                            break;
                        }
                        case 5: {
                            value = SSAccountsRecievablePrinter.this.iInpaymentSum.get(iInvoice.getNumber()) == null ? new BigDecimal(0) : SSAccountsRecievablePrinter.this.iInpaymentSum.get(iInvoice.getNumber());
                            break;
                        }
                        case 6: {
                            value = iInvoice.getCurrencyRate();
                            break;
                        }
                        case 7: {
                            BigDecimal iSaldo = SSInvoiceMath.getTotalSum(iInvoice);
                            if (SSAccountsRecievablePrinter.this.iInpaymentSum.containsKey(iInvoice.getNumber())) {
                                iSaldo = iSaldo.subtract(SSAccountsRecievablePrinter.this.iInpaymentSum.get(iInvoice.getNumber()));
                            }
                            if (SSAccountsRecievablePrinter.this.iCreditInvoiceSum.containsKey(iInvoice.getNumber())) {
                                iSaldo = iSaldo.subtract(SSAccountsRecievablePrinter.this.iCreditInvoiceSum.get(iInvoice.getNumber()));
                            }
                            value = SSInvoiceMath.convertToLocal(iInvoice, iSaldo);
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("invoice.number");
            this.iModel.addColumn("invoice.date");
            this.iModel.addColumn("invoice.currency");
            this.iModel.addColumn("invoice.value");
            this.iModel.addColumn("invoice.credited");
            this.iModel.addColumn("invoice.payed");
            this.iModel.addColumn("invoice.currencyrate");
            this.iModel.addColumn("invoice.localsaldo");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setCustomer(SSCustomer iCustomer) {
            List<SSInvoice> iInvoices = SSAccountsRecievablePrinter.this.iCustomerInvoicesMap.get(iCustomer.getNumber());
            this.iModel.setObjects(iInvoices);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSAccountsRecievablePrinter.SSInvoicePrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

