/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSInpaymentMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSInpayment;
import se.swedsoft.bookkeeping.data.SSInpaymentRow;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSInpaymentListPrinter
extends SSPrinter {
    private SSInpaymentRowPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSInpayment> iInpayments;

    public SSInpaymentListPrinter() {
        this(SSDB.getInstance().getInpayments());
    }

    public SSInpaymentListPrinter(List<SSInpayment> iInpayments) {
        this.iInpayments = iInpayments;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("inpaymentlist.jrxml");
        this.setDetail("inpaymentlist.jrxml");
        this.setSummary("inpaymentlist.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("inpaymentlistreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSInpaymentRowPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSInpayment> iModel = new SSDefaultTableModel<SSInpayment>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSInpayment iInpayment = (SSInpayment)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iInpayment.getNumber();
                        break;
                    }
                    case 1: {
                        value = this.iFormat.format(iInpayment.getDate());
                        break;
                    }
                    case 2: {
                        value = iInpayment.getText();
                        break;
                    }
                    case 3: {
                        value = SSInpaymentMath.getSum(iInpayment);
                        break;
                    }
                    case 4: {
                        SSInpaymentListPrinter.this.iPrinter.setInpayment(iInpayment);
                        SSInpaymentListPrinter.this.iDataSource.reset();
                        value = SSInpaymentListPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("inpayment.number");
        iModel.addColumn("inpayment.date");
        iModel.addColumn("inpayment.text");
        iModel.addColumn("inpayment.sum");
        iModel.addColumn("inpayment.rows");
        Collections.sort(this.iInpayments, new Comparator<SSInpayment>(){

            @Override
            public int compare(SSInpayment o1, SSInpayment o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        iModel.setObjects(this.iInpayments);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSInpaymentListPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iInpayments=").append(this.iInpayments);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSInpaymentRowPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSInpaymentRow> iModel;

        public SSInpaymentRowPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("inpaymentlist.row.jrxml");
            this.setSummary("inpaymentlist.row.jrxml");
            this.iModel = new SSDefaultTableModel<SSInpaymentRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Number value = null;
                    SSInpaymentRow iRow = (SSInpaymentRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getInvoiceNr();
                            break;
                        }
                        case 1: {
                            value = iRow.getInvoiceCurrencyRate();
                            break;
                        }
                        case 2: {
                            value = iRow.getInvoiceCurrency() == null ? null : iRow.getInvoiceCurrency().getName();
                            break;
                        }
                        case 3: {
                            value = iRow.getValue();
                            break;
                        }
                        case 4: {
                            value = iRow.getCurrencyRate();
                            break;
                        }
                        case 5: {
                            value = iRow.getLocalValue();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("invoice.number");
            this.iModel.addColumn("invoice.currencyrate");
            this.iModel.addColumn("invoice.currency");
            this.iModel.addColumn("inpaymentrow.value");
            this.iModel.addColumn("inpaymentrow.currencyrate");
            this.iModel.addColumn("inpaymentrow.payed");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setInpayment(SSInpayment iInpayment) {
            this.iModel.setObjects(iInpayment.getRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSInpaymentListPrinter.SSInpaymentRowPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

