/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSInvoiceListPrinter
extends SSPrinter {
    private SSInvoiceRowPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSInvoice> iInvoices;

    public SSInvoiceListPrinter() {
        this(SSDB.getInstance().getInvoices());
    }

    public SSInvoiceListPrinter(List<SSInvoice> iInvoices) {
        this.iInvoices = iInvoices;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("invoicelist.jrxml");
        this.setDetail("invoicelist.jrxml");
        this.setSummary("invoicelist.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("invoicelistreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSInvoiceRowPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSInvoice> iModel = new SSDefaultTableModel<SSInvoice>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSInvoice iInvoice = (SSInvoice)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iInvoice.getNumber();
                        break;
                    }
                    case 1: {
                        value = iInvoice.getCustomerNr();
                        break;
                    }
                    case 2: {
                        value = iInvoice.getCustomerName();
                        break;
                    }
                    case 3: {
                        value = this.iFormat.format(iInvoice.getDate());
                        break;
                    }
                    case 4: {
                        SSInvoiceListPrinter.this.iPrinter.setInvoice(iInvoice);
                        SSInvoiceListPrinter.this.iDataSource.reset();
                        value = SSInvoiceListPrinter.this.iDataSource;
                        break;
                    }
                    case 5: {
                        value = iInvoice.getCurrency() == null ? null : iInvoice.getCurrency().getName();
                        break;
                    }
                    case 6: {
                        value = SSInvoiceMath.getTotalSum(iInvoice);
                        break;
                    }
                    case 7: {
                        value = SSInvoiceMath.getTotalTaxSum(iInvoice);
                        break;
                    }
                    case 8: {
                        BigDecimal iSum = new BigDecimal(0);
                        iSum = iSum.add(SSInvoiceMath.getTotalSum(iInvoice).multiply(iInvoice.getCurrencyRate()));
                        value = iSum;
                        break;
                    }
                    case 9: {
                        BigDecimal iTaxSum = new BigDecimal(0);
                        iTaxSum = iTaxSum.add(SSInvoiceMath.getTotalTaxSum(iInvoice).multiply(iInvoice.getCurrencyRate()));
                        value = iTaxSum;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("invoice.number");
        iModel.addColumn("invoice.customernr");
        iModel.addColumn("invoice.customername");
        iModel.addColumn("invoice.date");
        iModel.addColumn("invoice.rows");
        iModel.addColumn("invoice.currency");
        iModel.addColumn("invoice.sum");
        iModel.addColumn("invoice.tax");
        iModel.addColumn("invoice.totalsum");
        iModel.addColumn("invoice.totaltax");
        Collections.sort(this.iInvoices, new Comparator<SSInvoice>(){

            @Override
            public int compare(SSInvoice o1, SSInvoice o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        iModel.setObjects(this.iInvoices);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSInvoiceListPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iInvoices=").append(this.iInvoices);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSInvoiceRowPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSSaleRow> iModel;

        public SSInvoiceRowPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("invoicelist.row.jrxml");
            this.setSummary("invoicelist.row.jrxml");
            this.iModel = new SSDefaultTableModel<SSSaleRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSSaleRow iRow = (SSSaleRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getProductNr();
                            break;
                        }
                        case 1: {
                            value = iRow.getDescription();
                            break;
                        }
                        case 2: {
                            value = iRow.getQuantity();
                            break;
                        }
                        case 3: {
                            value = iRow.getUnit() == null ? null : iRow.getUnit().getName();
                            break;
                        }
                        case 4: {
                            value = iRow.getUnitprice();
                            break;
                        }
                        case 5: {
                            value = iRow.getDiscount();
                            break;
                        }
                        case 6: {
                            value = iRow.getSum();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("row.number");
            this.iModel.addColumn("row.description");
            this.iModel.addColumn("row.count");
            this.iModel.addColumn("row.unit");
            this.iModel.addColumn("row.unitprice");
            this.iModel.addColumn("row.discount");
            this.iModel.addColumn("row.sum");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setInvoice(SSInvoice iInvoice) {
            this.iModel.setObjects(iInvoice.getRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSInvoiceListPrinter.SSInvoiceRowPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

