/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.SSMainBookCalculator;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSMainBookPrinter
extends SSPrinter {
    SSNewAccountingYear iYearData;
    SSAccount iAccountFrom;
    SSAccount iAccountTo;
    Date iDateFrom;
    Date iDateTo;
    private SSNewProject iProject;
    private SSNewResultUnit iResultUnit;

    public SSMainBookPrinter(SSAccount pAccountFrom, SSAccount pAccountTo, Date pDateFrom, Date pDateTo, SSNewProject iProject, SSNewResultUnit iResultUnit) {
        this(SSDB.getInstance().getCurrentYear(), pAccountFrom, pAccountTo, pDateFrom, pDateTo, iProject, iResultUnit);
    }

    public SSMainBookPrinter(SSNewAccountingYear pYearData, SSAccount pAccountFrom, SSAccount pAccountTo, Date pDateFrom, Date pDateTo, SSNewProject iProject, SSNewResultUnit iResultUnit) {
        this.iYearData = pYearData;
        this.iAccountFrom = pAccountFrom;
        this.iAccountTo = pAccountTo;
        this.iDateFrom = pDateFrom;
        this.iDateTo = pDateTo;
        this.iProject = iProject;
        this.iResultUnit = iResultUnit;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("mainbook.jrxml");
        this.setDetail("mainbook.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("mainbookreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        final DateFormat iFormat = DateFormat.getDateInstance(3);
        this.addParameter("dateFrom", this.iDateFrom);
        this.addParameter("dateTo", this.iDateTo);
        String iPeriodText = String.format(SSBundle.getBundle().getString("mainbookreport.period.account"), this.iAccountFrom.getNumber(), this.iAccountTo.getNumber());
        if (this.iProject != null) {
            iPeriodText = iPeriodText + String.format(SSBundle.getBundle().getString("mainbookreport.period.project"), this.iProject.getNumber());
        }
        if (this.iResultUnit != null) {
            iPeriodText = iPeriodText + String.format(SSBundle.getBundle().getString("mainbookreport.period.resultunit"), this.iResultUnit.getNumber());
        }
        this.addParameter("periodTitle", iPeriodText);
        this.addParameter("periodText", "");
        SSMainBookCalculator iCalculator = new SSMainBookCalculator(this.iYearData, this.iAccountFrom, this.iAccountTo, this.iDateFrom, this.iDateTo, this.iProject, this.iResultUnit);
        iCalculator.calculate();
        List<SSMainBookCalculator.SSMainBookRow> iRows = iCalculator.getRows();
        final Map<SSAccount, BigDecimal> iInBalance = iCalculator.getInBalance();
        final Map<SSAccount, BigDecimal> iInSaldo = iCalculator.getInSaldo();
        SSDefaultTableModel<SSMainBookCalculator.SSMainBookRow> iModel = new SSDefaultTableModel<SSMainBookCalculator.SSMainBookRow>(){

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                SSMainBookCalculator.SSMainBookRow iRow = (SSMainBookCalculator.SSMainBookRow)this.getObject(rowIndex);
                SSAccount iAccount = iRow.getAccount();
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iAccount.getNumber();
                        break;
                    }
                    case 1: {
                        value = iAccount.getDescription();
                        break;
                    }
                    case 2: {
                        value = iInSaldo.get(iAccount);
                        break;
                    }
                    case 3: {
                        value = iInBalance.get(iAccount);
                        break;
                    }
                    case 4: {
                        value = iRow.getHasdata();
                        break;
                    }
                    case 5: {
                        value = iRow.getNumber();
                        break;
                    }
                    case 6: {
                        value = iRow.getDate();
                        if (value == null) break;
                        value = iFormat.format(iRow.getDate());
                        break;
                    }
                    case 7: {
                        value = iRow.getDescription();
                        break;
                    }
                    case 8: {
                        value = iRow.isAdded();
                        break;
                    }
                    case 9: {
                        value = iRow.isCrossed();
                        break;
                    }
                    case 10: {
                        value = iRow.getDebet();
                        break;
                    }
                    case 11: {
                        value = iRow.getCredit();
                        break;
                    }
                    case 12: {
                        value = iRow.getSum();
                    }
                }
                return value;
            }
        };
        iModel.addColumn("account.number");
        iModel.addColumn("account.description");
        iModel.addColumn("account.insaldo");
        iModel.addColumn("account.inbalance");
        iModel.addColumn("isrow");
        iModel.addColumn("voucher.number");
        iModel.addColumn("voucher.date");
        iModel.addColumn("voucher.description");
        iModel.addColumn("voucherrow.added");
        iModel.addColumn("voucherrow.crossed");
        iModel.addColumn("voucherrow.debet");
        iModel.addColumn("voucherrow.credit");
        iModel.addColumn("voucherrow.sum");
        Collections.sort(iRows, new Comparator<SSMainBookCalculator.SSMainBookRow>(){

            @Override
            public int compare(SSMainBookCalculator.SSMainBookRow o1, SSMainBookCalculator.SSMainBookRow o2) {
                return o1.getAccount().getNumber().compareTo(o2.getAccount().getNumber());
            }
        });
        iModel.setObjects(iRows);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSMainBookPrinter");
        sb.append("{iAccountFrom=").append(this.iAccountFrom);
        sb.append(", iAccountTo=").append(this.iAccountTo);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iProject=").append(this.iProject);
        sb.append(", iResultUnit=").append(this.iResultUnit);
        sb.append(", iYearData=").append(this.iYearData);
        sb.append('}');
        return sb.toString();
    }
}

