/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSInventory;
import se.swedsoft.bookkeeping.data.SSOutdelivery;
import se.swedsoft.bookkeeping.data.SSOutdeliveryRow;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSOutdeliveryListPrinter
extends SSPrinter {
    private SSInventoryRowPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSOutdelivery> iOutdeliveries;

    public SSOutdeliveryListPrinter() {
        this(SSDB.getInstance().getOutdeliveries());
    }

    public SSOutdeliveryListPrinter(List<SSOutdelivery> iOutdeliveries) {
        this.iOutdeliveries = iOutdeliveries;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("outdeliverylist.jrxml");
        this.setDetail("outdeliverylist.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("outdeliverylistreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSInventoryRowPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSOutdelivery> iModel = new SSDefaultTableModel<SSOutdelivery>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSInventory.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSOutdelivery iOutdelivery = (SSOutdelivery)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iOutdelivery.getNumber();
                        break;
                    }
                    case 1: {
                        value = this.iFormat.format(iOutdelivery.getDate());
                        break;
                    }
                    case 2: {
                        value = iOutdelivery.getText();
                        break;
                    }
                    case 3: {
                        SSOutdeliveryListPrinter.this.iPrinter.setOutdelivery(iOutdelivery);
                        SSOutdeliveryListPrinter.this.iDataSource.reset();
                        value = SSOutdeliveryListPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("outdelivery.number");
        iModel.addColumn("outdelivery.date");
        iModel.addColumn("outdelivery.text");
        iModel.addColumn("outdelivery.rows");
        Collections.sort(this.iOutdeliveries, new Comparator<SSOutdelivery>(){

            @Override
            public int compare(SSOutdelivery o1, SSOutdelivery o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        iModel.setObjects(this.iOutdeliveries);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSOutdeliveryListPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iOutdeliveries=").append(this.iOutdeliveries);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSInventoryRowPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSOutdeliveryRow> iModel;

        public SSInventoryRowPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("outdeliverylist.row.jrxml");
            this.setSummary("outdeliverylist.row.jrxml");
            this.iModel = new SSDefaultTableModel<SSOutdeliveryRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSOutdeliveryRow iRow = (SSOutdeliveryRow)this.getObject(rowIndex);
                    SSProduct iProduct = iRow.getProduct();
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getProductNr();
                            break;
                        }
                        case 1: {
                            value = iProduct == null ? null : iProduct.getDescription();
                            break;
                        }
                        case 2: {
                            value = iRow.getChange();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("outdeliveryrow.product");
            this.iModel.addColumn("outdeliveryrow.descripion");
            this.iModel.addColumn("outdeliveryrow.change");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setOutdelivery(SSOutdelivery iOutdelivery) {
            this.iModel.setObjects(iOutdelivery.getRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSOutdeliveryListPrinter.SSInventoryRowPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

