/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSOutpaymentMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSOutpayment;
import se.swedsoft.bookkeeping.data.SSOutpaymentRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSOutpaymentListPrinter
extends SSPrinter {
    private SSOutpaymentRowPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSOutpayment> iOutpayments;

    public SSOutpaymentListPrinter() {
        this(SSDB.getInstance().getOutpayments());
    }

    public SSOutpaymentListPrinter(List<SSOutpayment> iInpayments) {
        this.iOutpayments = iInpayments;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("outpaymentlist.jrxml");
        this.setDetail("outpaymentlist.jrxml");
        this.setSummary("outpaymentlist.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("outpaymentlistreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSOutpaymentRowPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSOutpayment> iModel = new SSDefaultTableModel<SSOutpayment>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSOutpayment iOutpayment = (SSOutpayment)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iOutpayment.getNumber();
                        break;
                    }
                    case 1: {
                        value = this.iFormat.format(iOutpayment.getDate());
                        break;
                    }
                    case 2: {
                        value = iOutpayment.getText();
                        break;
                    }
                    case 3: {
                        value = SSOutpaymentMath.getSum(iOutpayment);
                        break;
                    }
                    case 4: {
                        SSOutpaymentListPrinter.this.iPrinter.setOutpayment(iOutpayment);
                        SSOutpaymentListPrinter.this.iDataSource.reset();
                        value = SSOutpaymentListPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("outpayment.number");
        iModel.addColumn("outpayment.date");
        iModel.addColumn("outpayment.text");
        iModel.addColumn("outpayment.sum");
        iModel.addColumn("outpayment.rows");
        Collections.sort(this.iOutpayments, new Comparator<SSOutpayment>(){

            @Override
            public int compare(SSOutpayment o1, SSOutpayment o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        iModel.setObjects(this.iOutpayments);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSOutpaymentListPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iOutpayments=").append(this.iOutpayments);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSOutpaymentRowPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSOutpaymentRow> iModel;

        public SSOutpaymentRowPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("outpaymentlist.row.jrxml");
            this.setSummary("outpaymentlist.row.jrxml");
            this.iModel = new SSDefaultTableModel<SSOutpaymentRow>(){

                @Override
                public Class getType() {
                    return SSOutpaymentRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Number value = null;
                    SSOutpaymentRow iRow = (SSOutpaymentRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getInvoiceNr();
                            break;
                        }
                        case 1: {
                            value = iRow.getInvoiceCurrencyRate();
                            break;
                        }
                        case 2: {
                            value = iRow.getInvoiceCurrency() == null ? null : iRow.getInvoiceCurrency().getName();
                            break;
                        }
                        case 3: {
                            value = iRow.getValue();
                            break;
                        }
                        case 4: {
                            value = iRow.getCurrencyRate();
                            break;
                        }
                        case 5: {
                            value = iRow.getLocalValue();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("invoice.number");
            this.iModel.addColumn("invoice.currencyrate");
            this.iModel.addColumn("invoice.currency");
            this.iModel.addColumn("row.value");
            this.iModel.addColumn("row.currencyrate");
            this.iModel.addColumn("row.payed");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setOutpayment(SSOutpayment iInpayment) {
            this.iModel.setObjects(iInpayment.getRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSOutpaymentListPrinter.SSOutpaymentRowPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

