/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.util.Date;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.calc.SSResultCalculator;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.print.report.SSResultPrinter;

public class SSProjectResultPrinter
extends SSResultPrinter {
    private static ResourceBundle bundle = SSBundle.getBundle();
    SSNewProject iProject;

    public SSProjectResultPrinter(Date pFrom, Date pTo, SSNewProject pProject) {
        super(pFrom, pTo, false, false);
        this.iProject = pProject;
        this.addParameter("periodTitle", SSBundle.getBundle().getString("resultreport.projectperiod"));
        this.addParameter("periodText", this.iProject != null ? this.iProject.getName() : SSBundle.getBundle().getString("resultreport.projectperiod.all"));
    }

    public SSProjectResultPrinter(SSNewAccountingYear pYearData, Date pFrom, Date pTo, SSNewProject pProject) {
        super(pYearData, pFrom, pTo, false, false);
        this.iProject = pProject;
        this.addParameter("periodTitle", SSBundle.getBundle().getString("resultreport.projectperiod"));
        this.addParameter("periodText", this.iProject != null ? this.iProject.getName() : SSBundle.getBundle().getString("resultreport.projectperiod.all"));
    }

    @Override
    protected SSResultCalculator getCalculator() {
        return new SSResultCalculator(this.iYearData, this.iDateFrom, this.iDateTo, this.iProject, null);
    }

    @Override
    protected void getColumns(SSResultCalculator iCalculator) {
        this.addParameter("column.text.2", bundle.getString("resultreport.column.1"));
        this.addParameter("column.text.3", bundle.getString("resultreport.column.7"));
        this.iColumn1 = null;
        this.iColumn2 = iCalculator.getProjectChangePeriod();
        this.iColumn3 = iCalculator.getProjectChange();
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("resultreport.project.title");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSProjectResultPrinter");
        sb.append("{iProject=").append(this.iProject);
        sb.append('}');
        return sb.toString();
    }
}

