/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSProjectRevenuePrinter
extends SSPrinter {
    private SSMonthlyDistributionPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSNewProject> iProjects;
    private Date iDateFrom;
    private Date iDateTo;
    Map<String, Map<SSMonth, BigDecimal>> iProjectRevenue;

    public SSProjectRevenuePrinter(List<SSNewProject> pProjects, Date pFrom, Date pTo) {
        this.iProjects = pProjects;
        this.iDateFrom = SSDateMath.floor(pFrom);
        this.iDateTo = SSDateMath.ceil(pTo);
        this.calculate();
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("projectrevenue.jrxml");
        this.setDetail("projectrevenue.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("projectrevenue.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iDateFrom);
        this.addParameter("dateTo", this.iDateTo);
        this.iPrinter = new SSMonthlyDistributionPrinter(this.iDateFrom, this.iDateTo);
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSNewProject> iModel = new SSDefaultTableModel<SSNewProject>(){

            @Override
            public Class getType() {
                return SSNewProject.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSNewProject iProject = (SSNewProject)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iProject.getNumber();
                        break;
                    }
                    case 1: {
                        value = iProject.getName();
                        break;
                    }
                    case 2: {
                        SSProjectRevenuePrinter.this.iPrinter.setProject(iProject, SSProjectRevenuePrinter.this.iProjectRevenue.get(iProject.getNumber()));
                        SSProjectRevenuePrinter.this.iDataSource.reset();
                        value = SSProjectRevenuePrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("project.number");
        iModel.addColumn("project.description");
        iModel.addColumn("month.data");
        iModel.setObjects(this.iProjects);
        return iModel;
    }

    private void calculate() {
        this.iProjectRevenue = new HashMap<String, Map<SSMonth, BigDecimal>>();
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        for (SSInvoice iInvoice : iInvoices) {
            if (!iInvoice.getDate().after(this.iDateFrom) || !iInvoice.getDate().before(this.iDateTo)) continue;
            Calendar iCal = Calendar.getInstance();
            iCal.setTime(iInvoice.getDate());
            iCal.set(5, 1);
            Date iFrom = iCal.getTime();
            iCal.set(5, iCal.getActualMaximum(5));
            Date iTo = iCal.getTime();
            SSMonth iMonth = new SSMonth(iFrom, iTo);
            for (SSSaleRow iRow : iInvoice.getRows()) {
                Map<Object, Object> iRevenueInMonth;
                if (iRow.getProjectNr() == null || iRow.getSum() == null) continue;
                BigDecimal iSum = SSInvoiceMath.convertToLocal(iInvoice, iRow.getSum());
                if (this.iProjectRevenue.containsKey(iRow.getProjectNr())) {
                    iRevenueInMonth = this.iProjectRevenue.get(iRow.getProjectNr());
                    if (iRevenueInMonth.containsKey(iMonth)) {
                        iRevenueInMonth.put(iMonth, ((BigDecimal)iRevenueInMonth.get(iMonth)).add(iSum));
                    } else {
                        iRevenueInMonth.put(iMonth, iSum);
                    }
                } else {
                    iRevenueInMonth = new HashMap<SSMonth, BigDecimal>();
                    iRevenueInMonth.put(iMonth, iSum);
                }
                this.iProjectRevenue.put(iRow.getProjectNr(), iRevenueInMonth);
            }
        }
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            if (!iCreditInvoice.getDate().after(this.iDateFrom) || !iCreditInvoice.getDate().before(this.iDateTo)) continue;
            Calendar iCal = Calendar.getInstance();
            iCal.setTime(iCreditInvoice.getDate());
            iCal.set(5, 1);
            Date iFrom = iCal.getTime();
            iCal.set(5, iCal.getActualMaximum(5));
            Date iTo = iCal.getTime();
            SSMonth iMonth = new SSMonth(iFrom, iTo);
            for (SSSaleRow iRow : iCreditInvoice.getRows()) {
                Map<Object, Object> iRevenueInMonth;
                if (iRow.getProjectNr() == null || iRow.getSum() == null) continue;
                BigDecimal iSum = SSCreditInvoiceMath.convertToLocal(iCreditInvoice, iRow.getSum());
                if (this.iProjectRevenue.containsKey(iRow.getProjectNr())) {
                    iRevenueInMonth = this.iProjectRevenue.get(iRow.getProjectNr());
                    if (iRevenueInMonth.containsKey(iMonth)) {
                        iRevenueInMonth.put(iMonth, ((BigDecimal)iRevenueInMonth.get(iMonth)).subtract(iSum));
                    } else {
                        iRevenueInMonth.put(iMonth, iSum.negate());
                    }
                } else {
                    iRevenueInMonth = new HashMap<SSMonth, BigDecimal>();
                    iRevenueInMonth.put(iMonth, iSum.negate());
                }
                this.iProjectRevenue.put(iRow.getProjectNr(), iRevenueInMonth);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSProjectRevenuePrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append(", iProjectRevenue=").append(this.iProjectRevenue);
        sb.append(", iProjects=").append(this.iProjects);
        sb.append('}');
        return sb.toString();
    }

    private class SSMonthlyDistributionPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSMonth> iModel;
        private SSNewProject iProject;
        private Date iFrom;
        private Date iTo;
        private Map<SSMonth, BigDecimal> iRevenue;

        public SSMonthlyDistributionPrinter(Date pFrom, Date pTo) {
            this.iFrom = pFrom;
            this.iTo = pTo;
            this.setMargins(0, 0, 0, 0);
            this.setDetail("projectrevenue.monthly.jrxml");
            this.setSummary("projectrevenue.monthly.jrxml");
            this.iModel = new SSDefaultTableModel<SSMonth>(SSMonth.splitYearIntoMonths(this.iFrom, this.iTo)){

                @Override
                public Class getType() {
                    return SSMonth.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSMonth iMonth = (SSMonth)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iMonth.toString();
                            break;
                        }
                        case 1: {
                            value = iMonth.getName();
                            break;
                        }
                        case 2: {
                            if (SSMonthlyDistributionPrinter.this.iProject != null && SSMonthlyDistributionPrinter.this.iRevenue.containsKey(iMonth)) {
                                value = SSMonthlyDistributionPrinter.this.iRevenue.get(iMonth);
                                break;
                            }
                            value = new BigDecimal(0);
                            break;
                        }
                        case 3: {
                            value = iMonth.isBetween(SSMonthlyDistributionPrinter.this.iFrom, SSMonthlyDistributionPrinter.this.iTo);
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("month.date");
            this.iModel.addColumn("month.description");
            this.iModel.addColumn("month.value");
            this.iModel.addColumn("month.visible");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setProject(SSNewProject pProject, Map<SSMonth, BigDecimal> iMap) {
            this.iProject = pProject;
            this.iRevenue = iMap;
            if (this.iRevenue == null) {
                this.iRevenue = new HashMap<SSMonth, BigDecimal>();
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSProjectRevenuePrinter.SSMonthlyDistributionPrinter");
            sb.append("{iFrom=").append(this.iFrom);
            sb.append(", iModel=").append(this.iModel);
            sb.append(", iProject=").append(this.iProject);
            sb.append(", iRevenue=").append(this.iRevenue);
            sb.append(", iTo=").append(this.iTo);
            sb.append('}');
            return sb.toString();
        }
    }
}

