/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSPurchasevaluePrinter
extends SSPrinter {
    private Date iFrom;
    private Date iTo;
    private List<SSMonth> iMonths;

    public SSPurchasevaluePrinter(Date iFrom, Date iTo) {
        this.iFrom = iFrom;
        this.iTo = iTo;
        this.iMonths = SSMonth.splitYearIntoMonths(iFrom, iTo);
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("purchasevalues.jrxml");
        this.setDetail("purchasevalues.jrxml");
        this.setSummary("purchasevalues.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("purchasevalues.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iFrom);
        this.addParameter("dateTo", this.iTo);
        SSDefaultTableModel<SSMonth> iModel = new SSDefaultTableModel<SSMonth>(){

            @Override
            public Class getType() {
                return SSProduct.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSMonth iMonth = (SSMonth)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iMonth.toString();
                        break;
                    }
                    case 1: {
                        value = SSDB.getInstance().getCurrentCompany().getPurchaseOrderValueForMonth(iMonth);
                        break;
                    }
                    case 2: {
                        value = SSDB.getInstance().getCurrentCompany().getSupplierInvoiceValueForMonth(iMonth);
                    }
                }
                return value;
            }
        };
        iModel.addColumn("month.name");
        iModel.addColumn("month.purchaseorder");
        iModel.addColumn("month.supplierinvoice");
        iModel.setObjects(this.iMonths);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSPurchasevaluePrinter");
        sb.append("{iFrom=").append(this.iFrom);
        sb.append(", iMonths=").append(this.iMonths);
        sb.append(", iTo=").append(this.iTo);
        sb.append('}');
        return sb.toString();
    }
}

