/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.calc.math.SSCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSSalePrinterUtils;

public class SSQuarterReportPrinter
extends SSPrinter {
    private Locale iLocale;
    private Date iFrom;
    private Date iTo;
    private List<SSCustomer> iCustomers = SSDB.getInstance().getCustomers();
    private Map<SSCustomer, BigDecimal> iEuSaleCommodity;
    private Map<SSCustomer, BigDecimal> iEuSaleThirdPartCommodity;

    public SSQuarterReportPrinter(Locale iLocale, Date iFrom, Date iTo) {
        this.iLocale = iLocale;
        this.iFrom = iFrom;
        this.iTo = iTo;
        ResourceBundle iBundle = ResourceBundle.getBundle("reports.quarterreport");
        this.setBundle(iBundle);
        this.setLocale(iLocale);
        this.setPageHeader("quarterreport.jrxml");
        this.setDetail("quarterreport.jrxml");
        this.setColumnHeader("quarterreport.jrxml");
        this.setSummary("quarterreport.jrxml");
        this.setPageFooter("quarterreport.jrxml");
        this.addParameters();
        this.iEuSaleCommodity = new HashMap<SSCustomer, BigDecimal>();
        this.iEuSaleThirdPartCommodity = new HashMap<SSCustomer, BigDecimal>();
        Map<String, List<SSInvoice>> iInvoicesForCustomers = SSInvoiceMath.getInvoicesforCustomers();
        Map<String, List<SSCreditInvoice>> iCreditInvoicesForCustomers = SSCreditInvoiceMath.getCreditInvoicesforCustomers();
        for (SSCustomer iCustomer : this.iCustomers) {
            BigDecimal iSum;
            BigDecimal iTotalSum;
            List<SSInvoice> iInvoicesForCustomer = iInvoicesForCustomers.get(iCustomer.getNumber());
            List<SSCreditInvoice> iCreditInvoicesForCustomer = iCreditInvoicesForCustomers.get(iCustomer.getNumber());
            this.iEuSaleCommodity.put(iCustomer, new BigDecimal(0));
            this.iEuSaleThirdPartCommodity.put(iCustomer, new BigDecimal(0));
            if (iInvoicesForCustomer != null) {
                for (SSInvoice iInvoice : iInvoicesForCustomer) {
                    if (!SSInvoiceMath.inPeriod(iInvoice, iFrom, iTo)) continue;
                    iTotalSum = SSInvoiceMath.getTotalSum(iInvoice);
                    iTotalSum = SSInvoiceMath.convertToLocal(iInvoice, iTotalSum);
                    if (iInvoice.getEuSaleCommodity()) {
                        iSum = this.iEuSaleCommodity.get(iCustomer);
                        this.iEuSaleCommodity.put(iCustomer, iSum.add(iTotalSum));
                    }
                    if (!iInvoice.getEuSaleThirdPartCommodity()) continue;
                    iSum = this.iEuSaleThirdPartCommodity.get(iCustomer);
                    this.iEuSaleThirdPartCommodity.put(iCustomer, iSum.add(iTotalSum));
                }
            }
            if (iCreditInvoicesForCustomer == null) continue;
            for (SSCreditInvoice iCreditInvoice : iCreditInvoicesForCustomer) {
                if (!SSCreditInvoiceMath.inPeriod(iCreditInvoice, iFrom, iTo)) continue;
                iTotalSum = SSCreditInvoiceMath.getTotalSum(iCreditInvoice);
                iTotalSum = SSCreditInvoiceMath.convertToLocal(iCreditInvoice, iTotalSum);
                if (iCreditInvoice.getEuSaleCommodity()) {
                    iSum = this.iEuSaleCommodity.get(iCustomer);
                    this.iEuSaleCommodity.put(iCustomer, iSum.subtract(iTotalSum));
                }
                if (!iCreditInvoice.getEuSaleThirdPartCommodity()) continue;
                iSum = this.iEuSaleThirdPartCommodity.get(iCustomer);
                this.iEuSaleThirdPartCommodity.put(iCustomer, iSum.subtract(iTotalSum));
            }
        }
    }

    @Override
    public String getTitle() {
        return this.iBundle.getString("quarterreport.title");
    }

    private void addParameters() {
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        SSSalePrinterUtils.addParametersForCompany(iCompany, this);
        this.addParameter("number", iCompany.getVATNumber());
        this.addParameter("date", this.getPeriodText());
        this.addParameter("quarter", this.getQuarterText());
    }

    private String getQuarterText() {
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTime(this.iFrom);
        String iYear = Integer.toString(iCalendar.get(1)).substring(2);
        String iMonth = Integer.toString(iCalendar.get(2) / 3 + 1);
        return iYear + '-' + iMonth;
    }

    private String getPeriodText() {
        String[] iMonths = new DateFormatSymbols().getMonths();
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTime(this.iFrom);
        String iMonthFrom = iMonths[iCalendar.get(2)];
        iCalendar.setTime(this.iTo);
        String iMonthTo = iMonths[iCalendar.get(2)];
        String iYear = Integer.toString(iCalendar.get(1));
        return iMonthFrom + " - " + iMonthTo + ' ' + iYear;
    }

    @Override
    protected SSDefaultTableModel getModel() {
        SSDefaultTableModel<SSCustomer> iModel = new SSDefaultTableModel<SSCustomer>(){

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String value = null;
                SSCustomer iCustomer = (SSCustomer)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iCustomer.getNumber();
                        break;
                    }
                    case 1: {
                        value = iCustomer.getName();
                        break;
                    }
                    case 2: {
                        value = iCustomer.getVATNumber();
                        break;
                    }
                    case 3: {
                        value = SSQuarterReportPrinter.this.iEuSaleCommodity.get(iCustomer);
                        break;
                    }
                    case 4: {
                        value = SSQuarterReportPrinter.this.iEuSaleThirdPartCommodity.get(iCustomer);
                    }
                }
                return value;
            }
        };
        iModel.addColumn("customer.number");
        iModel.addColumn("customer.name");
        iModel.addColumn("customer.vatnumber");
        iModel.addColumn("customer.eusalecommodity");
        iModel.addColumn("customer.eusalethirdpartcommodity");
        Collections.sort(this.iCustomers, new Comparator<SSCustomer>(){

            @Override
            public int compare(SSCustomer o1, SSCustomer o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        iModel.setObjects(this.iCustomers);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSQuarterReportPrinter");
        sb.append("{iCustomers=").append(this.iCustomers);
        sb.append(", iEuSaleCommodity=").append(this.iEuSaleCommodity);
        sb.append(", iEuSaleThirdPartCommodity=").append(this.iEuSaleThirdPartCommodity);
        sb.append(", iFrom=").append(this.iFrom);
        sb.append(", iLocale=").append(this.iLocale);
        sb.append(", iTo=").append(this.iTo);
        sb.append('}');
        return sb.toString();
    }
}

