/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSStartingAmountPrinter
extends SSPrinter {
    private Map<SSAccount, BigDecimal> iInBalance;
    private Date iFrom;
    private Date iTo;

    public SSStartingAmountPrinter() {
        this(SSDB.getInstance().getCurrentYear());
    }

    public SSStartingAmountPrinter(SSNewAccountingYear iAccountingYear) {
        this(iAccountingYear.getInBalance(), iAccountingYear.getFrom(), iAccountingYear.getTo());
    }

    public SSStartingAmountPrinter(Map<SSAccount, BigDecimal> iInBalance, Date iFrom, Date iTo) {
        this.iInBalance = iInBalance;
        this.iFrom = iFrom;
        this.iTo = iTo;
        this.setPageHeader("header.jrxml");
        this.setColumnHeader("startingammount.jrxml");
        this.setDetail("startingammount.jrxml");
        this.setSummary("startingammount.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("inbalancereport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iFrom);
        this.addParameter("dateTo", this.iTo);
        LinkedList<SSAccount> iAccounts = new LinkedList<SSAccount>();
        for (SSAccount iAccount : this.iInBalance.keySet()) {
            iAccounts.add(iAccount);
        }
        SSDefaultTableModel<SSAccount> iModel = new SSDefaultTableModel<SSAccount>(){

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                SSAccount iAccount = (SSAccount)this.getObject(rowIndex);
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iAccount.getNumber();
                        break;
                    }
                    case 1: {
                        value = iAccount.getDescription();
                        break;
                    }
                    case 2: {
                        value = SSStartingAmountPrinter.this.iInBalance.get(iAccount);
                    }
                }
                return value;
            }
        };
        iModel.addColumn("account");
        iModel.addColumn("description");
        iModel.addColumn("inbalance");
        Collections.sort(iAccounts, new Comparator<SSAccount>(){

            @Override
            public int compare(SSAccount o1, SSAccount o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        iModel.setObjects((List<SSAccount>)iAccounts);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSStartingAmountPrinter");
        sb.append("{iFrom=").append(this.iFrom);
        sb.append(", iInBalance=").append(this.iInBalance);
        sb.append(", iTo=").append(this.iTo);
        sb.append('}');
        return sb.toString();
    }
}

