/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSProductMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSStock;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSStockAccountPrinter
extends SSPrinter {
    private SSDefaultJasperDataSource iDataSource;
    private List<SSProduct> iProducts = SSProductMath.getStockProducts(SSDB.getInstance().getProducts());
    private SSStock iStock = new SSStock();
    private Date iDate;

    public SSStockAccountPrinter() {
        this.iDate = null;
        this.iStock.update();
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("stockaccount.jrxml");
        this.setDetail("stockaccount.jrxml");
    }

    public SSStockAccountPrinter(Date iDate) {
        this.iDate = iDate;
        this.iStock.update(iDate);
        this.addParameter("periodTitle", SSBundle.getBundle().getString("stockvaluereport.periodtitle"));
        this.addParameter("periodText", iDate);
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("stockaccount.jrxml");
        this.setDetail("stockaccount.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("stockaccountreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        SSDefaultTableModel<SSProduct> iModel = new SSDefaultTableModel<SSProduct>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSProduct iProduct = (SSProduct)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iProduct.getNumber();
                        break;
                    }
                    case 1: {
                        value = iProduct.getDescription();
                        break;
                    }
                    case 2: {
                        value = iProduct.getOrderpoint();
                        break;
                    }
                    case 3: {
                        value = iProduct.getOrdercount();
                        break;
                    }
                    case 4: {
                        value = SSStockAccountPrinter.this.iStock.getQuantity(iProduct);
                        break;
                    }
                    case 5: {
                        value = SSStockAccountPrinter.this.iStock.getReserved(iProduct);
                        break;
                    }
                    case 6: {
                        value = SSStockAccountPrinter.this.iStock.getOrdered(iProduct);
                    }
                }
                return value;
            }
        };
        iModel.addColumn("product.number");
        iModel.addColumn("product.description");
        iModel.addColumn("product.orderpoint");
        iModel.addColumn("product.ordercount");
        iModel.addColumn("product.quantity");
        iModel.addColumn("product.reserved");
        iModel.addColumn("product.ordered");
        Collections.sort(this.iProducts, new Comparator<SSProduct>(){

            @Override
            public int compare(SSProduct o1, SSProduct o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        iModel.setObjects(this.iProducts);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSStockAccountPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iProducts=").append(this.iProducts);
        sb.append(", iStock=").append(this.iStock);
        sb.append('}');
        return sb.toString();
    }
}

