/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSProductMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSStock;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.graphics.SSImage;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSStockValuePrinter
extends SSPrinter {
    private List<SSProduct> iProducts = SSProductMath.getStockProducts(SSDB.getInstance().getProducts());
    private SSStock iStock = new SSStock();
    private Date iDate;
    private Map<SSProduct, BigDecimal> iInprices;

    public SSStockValuePrinter() {
        this.iDate = null;
        this.iInprices = SSProductMath.getInprices(this.iProducts);
        this.iStock.update();
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("stockvalue.jrxml");
        this.setDetail("stockvalue.jrxml");
        this.setSummary("stockvalue.jrxml");
    }

    public SSStockValuePrinter(Date iDate) {
        this.iDate = iDate;
        this.iInprices = SSProductMath.getInprices(this.iProducts, iDate);
        this.iStock.update(iDate);
        this.addParameter("periodTitle", SSBundle.getBundle().getString("stockvaluereport.periodtitle"));
        this.addParameter("periodText", iDate);
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("stockvalue.jrxml");
        this.setDetail("stockvalue.jrxml");
        this.setSummary("stockvalue.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("stockvaluereport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("image.check", SSImage.getImage("CHECK"));
        SSDefaultTableModel<SSProduct> iModel = new SSDefaultTableModel<SSProduct>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSProduct iProduct = (SSProduct)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iProduct.getNumber();
                        break;
                    }
                    case 1: {
                        value = iProduct.getDescription();
                        break;
                    }
                    case 2: {
                        value = iProduct.isExpired();
                        break;
                    }
                    case 3: {
                        value = SSStockValuePrinter.this.iStock.getQuantity(iProduct);
                        break;
                    }
                    case 4: {
                        value = iProduct.getUnit() == null ? null : iProduct.getUnit().getName();
                        break;
                    }
                    case 5: {
                        value = SSStockValuePrinter.this.iInprices.get(iProduct);
                    }
                }
                return value;
            }
        };
        iModel.addColumn("product.number");
        iModel.addColumn("product.description");
        iModel.addColumn("product.expired");
        iModel.addColumn("product.stockquantity");
        iModel.addColumn("product.unit");
        iModel.addColumn("product.inprice");
        Collections.sort(this.iProducts, new Comparator<SSProduct>(){

            @Override
            public int compare(SSProduct o1, SSProduct o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        iModel.setObjects(this.iProducts);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSStockValuePrinter");
        sb.append("{iDate=").append(this.iDate);
        sb.append(", iInprices=").append(this.iInprices);
        sb.append(", iProducts=").append(this.iProducts);
        sb.append(", iStock=").append(this.iStock);
        sb.append('}');
        return sb.toString();
    }
}

