/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoiceRow;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSSupplierInvoiceListPrinter
extends SSPrinter {
    private SSInvoiceRowPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSSupplierInvoice> iInvoices;

    public SSSupplierInvoiceListPrinter() {
        this(SSDB.getInstance().getSupplierInvoices());
    }

    public SSSupplierInvoiceListPrinter(List<SSSupplierInvoice> iInvoices) {
        this.iInvoices = iInvoices;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("supplierinvoicelist.jrxml");
        this.setDetail("supplierinvoicelist.jrxml");
        this.setSummary("supplierinvoicelist.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("supplierinvoicelistreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSInvoiceRowPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSSupplierInvoice> iModel = new SSDefaultTableModel<SSSupplierInvoice>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSSupplierInvoice iInvoice = (SSSupplierInvoice)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iInvoice.getNumber();
                        break;
                    }
                    case 1: {
                        value = iInvoice.getSupplierNr();
                        break;
                    }
                    case 2: {
                        value = iInvoice.getSupplierName();
                        break;
                    }
                    case 3: {
                        value = this.iFormat.format(iInvoice.getDate());
                        break;
                    }
                    case 4: {
                        value = iInvoice.getCurrency() == null ? null : iInvoice.getCurrency().getName();
                        break;
                    }
                    case 5: {
                        value = SSSupplierInvoiceMath.getTotalSum(iInvoice);
                        break;
                    }
                    case 6: {
                        value = iInvoice.getTaxSum();
                        break;
                    }
                    case 7: {
                        SSSupplierInvoiceListPrinter.this.iPrinter.setInvoice(iInvoice);
                        SSSupplierInvoiceListPrinter.this.iDataSource.reset();
                        value = SSSupplierInvoiceListPrinter.this.iDataSource;
                        break;
                    }
                    case 8: {
                        BigDecimal iSum = new BigDecimal(0);
                        iSum = iSum.add(SSSupplierInvoiceMath.getTotalSum(iInvoice).multiply(iInvoice.getCurrencyRate()));
                        value = iSum;
                        break;
                    }
                    case 9: {
                        BigDecimal iTaxSum = new BigDecimal(0);
                        iTaxSum = iTaxSum.add(iInvoice.getTaxSum().multiply(iInvoice.getCurrencyRate()));
                        value = iTaxSum;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("supplierinvoice.number");
        iModel.addColumn("supplierinvoice.suppliernr");
        iModel.addColumn("supplierinvoice.suppliername");
        iModel.addColumn("supplierinvoice.date");
        iModel.addColumn("supplierinvoice.currency");
        iModel.addColumn("supplierinvoice.sum");
        iModel.addColumn("supplierinvoice.tax");
        iModel.addColumn("supplierinvoice.rows");
        iModel.addColumn("invoice.totalsum");
        iModel.addColumn("invoice.totaltax");
        Collections.sort(this.iInvoices, new Comparator<SSSupplierInvoice>(){

            @Override
            public int compare(SSSupplierInvoice o1, SSSupplierInvoice o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        iModel.setObjects(this.iInvoices);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSSupplierInvoiceListPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iInvoices=").append(this.iInvoices);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSInvoiceRowPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSSupplierInvoiceRow> iModel;

        public SSInvoiceRowPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("supplierinvoicelist.row.jrxml");
            this.setSummary("supplierinvoicelist.row.jrxml");
            this.iModel = new SSDefaultTableModel<SSSupplierInvoiceRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSSupplierInvoiceRow iRow = (SSSupplierInvoiceRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getProductNr();
                            break;
                        }
                        case 1: {
                            value = iRow.getDescription();
                            break;
                        }
                        case 2: {
                            value = iRow.getQuantity();
                            break;
                        }
                        case 3: {
                            value = iRow.getUnit() == null ? null : iRow.getUnit().getName();
                            break;
                        }
                        case 4: {
                            value = iRow.getUnitprice();
                            break;
                        }
                        case 5: {
                            value = iRow.getSum();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("row.number");
            this.iModel.addColumn("row.description");
            this.iModel.addColumn("row.count");
            this.iModel.addColumn("row.unit");
            this.iModel.addColumn("row.unitprice");
            this.iModel.addColumn("row.sum");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setInvoice(SSSupplierInvoice iInvoice) {
            this.iModel.setObjects(iInvoice.getRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSSupplierInvoiceListPrinter.SSInvoiceRowPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

