/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSSupplierdebtPrinter
extends SSPrinter {
    private Map<SSSupplierInvoice, BigDecimal> iSaldos;

    public SSSupplierdebtPrinter(Date iDate) {
        this(iDate, SSDB.getInstance().getSupplierInvoices());
    }

    public SSSupplierdebtPrinter(Date iDate, List<SSSupplierInvoice> iInvoices) {
        this.iSaldos = SSSupplierInvoiceMath.getSaldo(iInvoices, iDate);
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("supplierdebt.jrxml");
        this.setDetail("supplierdebt.jrxml");
        this.setSummary("supplierdebt.jrxml");
        this.addParameter("periodTitle", this.iBundle.getString("supplierdebtreport.periodtitle"));
        this.addParameter("periodText", iDate);
    }

    @Override
    public String getTitle() {
        return this.iBundle.getString("supplierdebtreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        LinkedList<SSSupplierInvoice> iInvoices = new LinkedList<SSSupplierInvoice>(this.iSaldos.keySet());
        Collections.sort(iInvoices, new Comparator<SSSupplierInvoice>(){

            @Override
            public int compare(SSSupplierInvoice o1, SSSupplierInvoice o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        SSDefaultTableModel<SSSupplierInvoice> iModel = new SSDefaultTableModel<SSSupplierInvoice>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSSupplierInvoice.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSSupplierInvoice iInvoice = (SSSupplierInvoice)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iInvoice.getNumber();
                        break;
                    }
                    case 1: {
                        value = iInvoice.getSupplierNr();
                        break;
                    }
                    case 2: {
                        value = iInvoice.getSupplierName();
                        break;
                    }
                    case 3: {
                        value = iInvoice.getDate() == null ? null : this.iFormat.format(iInvoice.getDate());
                        break;
                    }
                    case 4: {
                        value = iInvoice.getCurrency() == null ? null : iInvoice.getCurrency().getName();
                        break;
                    }
                    case 5: {
                        value = SSSupplierInvoiceMath.getTotalSum(iInvoice);
                        break;
                    }
                    case 6: {
                        value = SSSupplierdebtPrinter.this.iSaldos.get(iInvoice);
                        break;
                    }
                    case 7: {
                        BigDecimal iSaldo = (BigDecimal)SSSupplierdebtPrinter.this.iSaldos.get(iInvoice);
                        value = SSSupplierInvoiceMath.convertToLocal(iInvoice, iSaldo);
                    }
                }
                return value;
            }
        };
        iModel.addColumn("supplierinvoice.number");
        iModel.addColumn("supplier.number");
        iModel.addColumn("supplier.name");
        iModel.addColumn("supplierinvoice.date");
        iModel.addColumn("supplierinvoice.currency");
        iModel.addColumn("supplierinvoice.sum");
        iModel.addColumn("supplierinvoice.saldo");
        iModel.addColumn("supplierinvoice.localsaldo");
        iModel.setObjects((List<SSSupplierInvoice>)iInvoices);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSSupplierdebtPrinter");
        sb.append("{iSaldos=").append(this.iSaldos);
        sb.append('}');
        return sb.toString();
    }
}

