/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSAccountMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSVATControl2007Printer
extends SSPrinter {
    private SSNewAccountingYear iAccountingYear;
    private Date iDateFrom;
    private Date iDateTo;
    private List<SSAccount> iAccounts;
    private Map<String, List<SSAccount>> iAccountsByVatCode;
    private Map<SSAccount, BigDecimal> iCreditMinusDebetSum;
    private Map<SSAccount, BigDecimal> iDebetMinusCreditSum;

    public SSVATControl2007Printer(SSNewAccountingYear iAccountingYear, Date iDateFrom, Date iDateTo) {
        this.iAccountingYear = iAccountingYear;
        this.iDateFrom = iDateFrom;
        this.iDateTo = iDateTo;
        this.iAccounts = iAccountingYear.getAccounts();
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("vatcontrol2007.jrxml");
        this.setDetail("vatcontrol2007.jrxml");
        this.setSummary("vatcontrol2007.jrxml");
        this.calculate();
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("vatcontrol2007.title");
    }

    private void calculate() {
        List<SSVoucher> iVouchers = SSVoucherMath.getVouchers(this.iAccountingYear.getVouchers(), this.iDateFrom, this.iDateTo);
        this.iCreditMinusDebetSum = SSVoucherMath.getCreditMinusDebetSum(iVouchers);
        this.iDebetMinusCreditSum = SSVoucherMath.getDebetMinusCreditSum(iVouchers);
        this.iAccountsByVatCode = new HashMap<String, List<SSAccount>>();
        for (SSAccount iAccount : this.iAccounts) {
            String iVATCode = iAccount.getVATCode();
            List<SSAccount> iAccountsForVatCode = this.iAccountsByVatCode.get(iVATCode);
            if (iAccountsForVatCode == null) {
                iAccountsForVatCode = new LinkedList<SSAccount>();
                this.iAccountsByVatCode.put(iVATCode, iAccountsForVatCode);
            }
            iAccountsForVatCode.add(iAccount);
        }
    }

    public SSVoucher getVoucher(SSAccount iAccountR1, SSAccount iAccountR2, SSAccount iAccountA) {
        SSVoucherRow iRow;
        DateFormat iFormat = DateFormat.getDateInstance(3);
        String iDescription = String.format(SSBundle.getBundle().getString("vatreport2007.voucherdescription"), iFormat.format(this.iDateFrom), iFormat.format(this.iDateTo));
        List<SSAccount> iAccounts = SSAccountMath.getAccountsByVATCode(SSDB.getInstance().getAccounts(), "U1", "U2", "U3", "UVL", "UEU", "UTFU", "U1MI", "U2MI", "U3MI", "I", "IVL");
        SSVoucher iVoucher = new SSVoucher();
        iVoucher.doAutoIncrecement();
        iVoucher.setDescription(iDescription);
        iVoucher.setDate(this.iDateTo);
        BigDecimal iSum = new BigDecimal(0);
        BigDecimal iRoundedSum = new BigDecimal(0);
        for (SSAccount iAccount : iAccounts) {
            BigDecimal iValue = this.iCreditMinusDebetSum.get(iAccount);
            if (iValue == null || iValue.signum() == 0) continue;
            iRow = new SSVoucherRow();
            iRow.setAccount(iAccount);
            iRow.setValue(iValue);
            iVoucher.addVoucherRow(iRow);
            iSum = iSum.add(iValue);
            iRoundedSum = iRoundedSum.add(iValue.setScale(0, RoundingMode.DOWN));
        }
        if (iSum.signum() != 0) {
            iRow = new SSVoucherRow();
            if (iRoundedSum.signum() > 0) {
                iRow.setAccount(iAccountR2);
                iRow.setCredit(iRoundedSum);
            } else {
                iRow.setAccount(iAccountR1);
                iRow.setDebet(iRoundedSum.abs());
            }
            iVoucher.addVoucherRow(iRow);
            if (iRoundedSum.subtract(iSum).signum() != 0) {
                iRow = new SSVoucherRow();
                iRow.setAccount(iAccountA);
                iRow.setValue(iRoundedSum.subtract(iSum));
                iVoucher.addVoucherRow(iRow);
            }
        }
        return iVoucher;
    }

    private BigDecimal getValueForGroup(Integer group) {
        switch (group) {
            case 1: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "MP1", "MPFF", "MBBU", "MU1");
            }
            case 2: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "MP2", "MU2");
            }
            case 3: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "MP3", "MU3");
            }
        }
        return new BigDecimal(0);
    }

    private BigDecimal getTaxForGroup(Integer group) {
        BigDecimal iValue = this.getValueForGroup(group);
        switch (group) {
            case 1: {
                return iValue.multiply(new BigDecimal("0.25"));
            }
            case 2: {
                return iValue.multiply(new BigDecimal("0.12"));
            }
            case 3: {
                return iValue.multiply(new BigDecimal("0.06"));
            }
        }
        return new BigDecimal(0);
    }

    private BigDecimal getReportedTaxForGroup(Integer group) {
        switch (group) {
            case 1: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "U1", "UVL");
            }
            case 2: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "U2");
            }
            case 3: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "U3");
            }
        }
        return new BigDecimal(0);
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iDateFrom);
        this.addParameter("dateTo", this.iDateTo);
        SSDefaultTableModel<Integer> iModel = new SSDefaultTableModel<Integer>(){

            @Override
            public Class getType() {
                return String.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Integer iNumber = (Integer)this.getObject(rowIndex);
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iNumber;
                        break;
                    }
                    case 1: {
                        value = SSBundle.getBundle().getString("vatcontrol2007.group." + iNumber);
                        break;
                    }
                    case 2: {
                        value = SSVATControl2007Printer.this.getValueForGroup(iNumber);
                        break;
                    }
                    case 3: {
                        value = SSVATControl2007Printer.this.getTaxForGroup(iNumber);
                        break;
                    }
                    case 4: {
                        value = SSVATControl2007Printer.this.getReportedTaxForGroup(iNumber);
                    }
                }
                return value;
            }
        };
        iModel.addColumn("group.number");
        iModel.addColumn("group.description");
        iModel.addColumn("group.turnover");
        iModel.addColumn("group.calculated");
        iModel.addColumn("group.reported");
        iModel.add(1);
        iModel.add(2);
        iModel.add(3);
        return iModel;
    }

    private BigDecimal getSumForAccounts(Map<SSAccount, BigDecimal> iSums, String ... iVATCodes) {
        BigDecimal iSum = new BigDecimal(0);
        for (SSAccount iAccount : this.iAccounts) {
            BigDecimal iSumForAccount;
            if (!this.hasVATCode(iAccount, iVATCodes) || (iSumForAccount = iSums.get(iAccount)) == null) continue;
            iSum = iSum.add(iSumForAccount);
        }
        return iSum;
    }

    private boolean hasVATCode(SSAccount iAccount, String ... iVATCodes) {
        String iVATCodeForAccount = iAccount.getVATCode();
        for (String iVATCode : iVATCodes) {
            if (!iVATCode.equals(iVATCodeForAccount)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSVATControl2007Printer");
        sb.append("{iAccountingYear=").append(this.iAccountingYear);
        sb.append(", iAccounts=").append(this.iAccounts);
        sb.append(", iAccountsByVatCode=").append(this.iAccountsByVatCode);
        sb.append(", iCreditMinusDebetSum=").append(this.iCreditMinusDebetSum);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iDebetMinusCreditSum=").append(this.iDebetMinusCreditSum);
        sb.append('}');
        return sb.toString();
    }
}

