/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.calc.SSSalesTaxCalculator;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSVATControlPrinter
extends SSPrinter {
    private SSNewAccountingYear iAccountingYear;
    private Date iDateFrom;
    private Date iDateTo;

    public SSVATControlPrinter(SSNewAccountingYear pAccountingYear, Date pDateFrom, Date pDateTo) {
        this.iAccountingYear = pAccountingYear;
        this.iDateFrom = pDateFrom;
        this.iDateTo = pDateTo;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("vatcontrol.jrxml");
        this.setDetail("vatcontrol.jrxml");
        this.setSummary("vatcontrol.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("vatcontrolreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iDateFrom);
        this.addParameter("dateTo", this.iDateTo);
        SSSalesTaxCalculator iCalculator = new SSSalesTaxCalculator(this.iAccountingYear, this.iDateFrom, this.iDateTo);
        iCalculator.calculate();
        List<SSSalesTaxCalculator.SSVATControlGroup> iControlGroups = iCalculator.getControlGroups();
        SSDefaultTableModel<SSSalesTaxCalculator.SSVATControlGroup> iModel = new SSDefaultTableModel<SSSalesTaxCalculator.SSVATControlGroup>(){

            @Override
            public Class getType() {
                return SSSalesTaxCalculator.SSVATControlGroup.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                SSSalesTaxCalculator.SSVATControlGroup iControlGroup = (SSSalesTaxCalculator.SSVATControlGroup)this.getObject(rowIndex);
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iControlGroup.getDescription();
                        break;
                    }
                    case 1: {
                        value = iControlGroup.getSum();
                        break;
                    }
                    case 2: {
                        BigDecimal d = iControlGroup.getSum();
                        switch (iControlGroup.getGroup1()) {
                            case 1: {
                                value = d.multiply(new BigDecimal("0.25"));
                                break;
                            }
                            case 2: {
                                value = d.multiply(new BigDecimal("0.12"));
                                break;
                            }
                            case 3: {
                                value = d.multiply(new BigDecimal("0.06"));
                            }
                        }
                        break;
                    }
                    case 3: {
                        value = iControlGroup.getReported();
                    }
                }
                return value;
            }
        };
        iModel.addColumn("group.title");
        iModel.addColumn("group.turnover");
        iModel.addColumn("group.calculated");
        iModel.addColumn("group.reported");
        iModel.setObjects(iControlGroups);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSVATControlPrinter");
        sb.append("{iAccountingYear=").append(this.iAccountingYear);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append('}');
        return sb.toString();
    }
}

