/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSVATReport2015Printer
extends SSPrinter {
    private SSNewAccountingYear iAccountingYear;
    private Date iDateFrom;
    private Date iDateTo;
    private int iStartVoucher;
    private SSVATReportRowPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSAccount> iAccounts;
    private Map<String, List<SSAccount>> iAccountsByVatCode;
    private Map<SSAccount, BigDecimal> iCreditMinusDebetSum;
    private Map<SSAccount, BigDecimal> iDebetMinusCreditSum;

    public SSVATReport2015Printer(SSNewAccountingYear iAccountingYear, Date iDateFrom, Date iDateTo, int iStartVoucher) {
        this.iAccountingYear = iAccountingYear;
        this.iDateFrom = iDateFrom;
        this.iDateTo = iDateTo;
        this.iStartVoucher = iStartVoucher;
        this.iAccounts = iAccountingYear.getAccounts();
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("vatreport2015.jrxml");
        this.setDetail("vatreport2015.jrxml");
        this.calculate();
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("vatreport2015.title");
    }

    private void calculate() {
        List<SSVoucher> iVouchers = SSVoucherMath.getVouchers(this.iAccountingYear.getVouchers(), this.iDateFrom, this.iDateTo);
        int iStartVoucherIndex = this.iStartVoucher - 1;
        List<SSVoucher> iVouchers2 = iVouchers;
        if (iStartVoucherIndex >= 0 && iStartVoucherIndex < iVouchers.size()) {
            iVouchers2 = iVouchers.subList(iStartVoucherIndex, iVouchers.size());
        } else {
            System.err.println("Anv\u00e4nder hela periodens verifikat d\u00e5 b\u00f6rja-med-verifikat ligger utanf\u00f6r giltigt intervall.");
        }
        this.iCreditMinusDebetSum = SSVoucherMath.getCreditMinusDebetSum(iVouchers2);
        this.iDebetMinusCreditSum = SSVoucherMath.getDebetMinusCreditSum(iVouchers2);
        this.iAccountsByVatCode = new HashMap<String, List<SSAccount>>();
        for (SSAccount iAccount : this.iAccounts) {
            String iVATCode = iAccount.getVATCode();
            List<SSAccount> iAccountsForVatCode = this.iAccountsByVatCode.get(iVATCode);
            if (iAccountsForVatCode == null) {
                iAccountsForVatCode = new LinkedList<SSAccount>();
                this.iAccountsByVatCode.put(iVATCode, iAccountsForVatCode);
            }
            iAccountsForVatCode.add(iAccount);
        }
    }

    private String getVATCodesForGroup(Integer group) {
        switch (group) {
            case 5: {
                return "MP1, MP2, MP3, PTOG";
            }
            case 6: {
                return "MU1, MU2, MU3";
            }
            case 7: {
                return "MBBU";
            }
            case 8: {
                return "MPFF";
            }
            case 10: {
                return "U1, UVL";
            }
            case 11: {
                return "U2";
            }
            case 12: {
                return "U3";
            }
            case 20: {
                return "VFEU";
            }
            case 21: {
                return "TFEU";
            }
            case 22: {
                return "TFFU";
            }
            case 23: {
                return "IVIS";
            }
            case 24: {
                return "ITIS";
            }
            case 30: {
                return "U1MI, UEU, UTFU";
            }
            case 31: {
                return "U2MI";
            }
            case 32: {
                return "U3MI";
            }
            case 35: {
                return "VTEU, \u00d6VEU";
            }
            case 36: {
                return "E";
            }
            case 37: {
                return "3VEU";
            }
            case 38: {
                return "3FEU";
            }
            case 39: {
                return "FTEU";
            }
            case 40: {
                return "OTTU";
            }
            case 41: {
                return "OMSS";
            }
            case 42: {
                return "MF";
            }
            case 48: {
                return "I, IVL";
            }
            case 49: {
                return "R1, R2";
            }
            case 50: {
                return "IBU, IBU1, IBU2, IBU3";
            }
            case 60: {
                return "UI1";
            }
            case 61: {
                return "UI2";
            }
            case 62: {
                return "UI3";
            }
        }
        return null;
    }

    private BigDecimal getValueForGroup(Integer group) {
        switch (group) {
            case 5: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "MP1", "MP2", "MP3", "PTOG");
            }
            case 6: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "MU1", "MU2", "MU3");
            }
            case 7: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "MBBU");
            }
            case 8: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "MPFF");
            }
            case 10: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "U1", "UVL");
            }
            case 11: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "U2");
            }
            case 12: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "U3");
            }
            case 20: {
                return this.getSumForAccounts(this.iDebetMinusCreditSum, "VFEU");
            }
            case 21: {
                return this.getSumForAccounts(this.iDebetMinusCreditSum, "TFEU");
            }
            case 22: {
                return this.getSumForAccounts(this.iDebetMinusCreditSum, "TFFU");
            }
            case 23: {
                return this.getSumForAccounts(this.iDebetMinusCreditSum, "IVIS");
            }
            case 24: {
                return this.getSumForAccounts(this.iDebetMinusCreditSum, "ITIS");
            }
            case 30: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "U1MI", "UEU", "UTFU");
            }
            case 31: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "U2MI");
            }
            case 32: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "U3MI");
            }
            case 35: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "VTEU", "\u00d6VEU");
            }
            case 36: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "E");
            }
            case 37: {
                return this.getSumForAccounts(this.iDebetMinusCreditSum, "3VEU");
            }
            case 38: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "3FEU");
            }
            case 39: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "FTEU");
            }
            case 40: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "OTTU");
            }
            case 41: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "OMSS");
            }
            case 42: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "MF");
            }
            case 48: {
                return this.getSumForAccounts(this.iDebetMinusCreditSum, "I", "IVL");
            }
            case 49: {
                BigDecimal iSum = new BigDecimal(0);
                iSum = iSum.add(this.getValueForGroup(10));
                iSum = iSum.add(this.getValueForGroup(11));
                iSum = iSum.add(this.getValueForGroup(12));
                iSum = iSum.add(this.getValueForGroup(30));
                iSum = iSum.add(this.getValueForGroup(31));
                iSum = iSum.add(this.getValueForGroup(32));
                iSum = iSum.add(this.getValueForGroup(60));
                iSum = iSum.add(this.getValueForGroup(61));
                iSum = iSum.add(this.getValueForGroup(62));
                iSum = iSum.subtract(this.getValueForGroup(48));
                return iSum;
            }
            case 50: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "IBU", "IBU1", "IBU2", "IBU3");
            }
            case 60: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "UI1");
            }
            case 61: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "UI2");
            }
            case 62: {
                return this.getSumForAccounts(this.iCreditMinusDebetSum, "UI3");
            }
        }
        return new BigDecimal(0);
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iDateFrom);
        this.addParameter("dateTo", this.iDateTo);
        this.iPrinter = new SSVATReportRowPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<String> iModel = new SSDefaultTableModel<String>(){

            @Override
            public Class getType() {
                return String.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String iNumber = (String)this.getObject(rowIndex);
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iNumber;
                        break;
                    }
                    case 1: {
                        value = SSBundle.getBundle().getString("vatreport2015.group." + iNumber);
                        break;
                    }
                    case 2: {
                        SSVATReport2015Printer.this.iPrinter.setGroup(iNumber.charAt(0));
                        SSVATReport2015Printer.this.iDataSource.reset();
                        value = SSVATReport2015Printer.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("group.number");
        iModel.addColumn("group.description");
        iModel.addColumn("group.rows");
        iModel.add("A");
        iModel.add("B");
        iModel.add("C");
        iModel.add("D");
        iModel.add("H");
        iModel.add("I");
        iModel.add("E");
        iModel.add("F");
        iModel.add("G");
        return iModel;
    }

    private BigDecimal getSumForAccounts(Map<SSAccount, BigDecimal> iSums, String ... iVATCodes) {
        BigDecimal iSum = new BigDecimal(0);
        for (SSAccount iAccount : this.iAccounts) {
            BigDecimal iSumForAccount;
            if (!this.hasVATCode(iAccount, iVATCodes) || (iSumForAccount = iSums.get(iAccount)) == null) continue;
            iSum = iSum.add(iSumForAccount.setScale(0, RoundingMode.DOWN));
        }
        return iSum;
    }

    private boolean hasVATCode(SSAccount iAccount, String ... iVATCodes) {
        String iVATCodeForAccount = iAccount.getVATCode();
        for (String iVATCode : iVATCodes) {
            if (!iVATCode.equals(iVATCodeForAccount)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSVATReport2015Printer");
        sb.append("{iAccountingYear=").append(this.iAccountingYear);
        sb.append(", iAccounts=").append(this.iAccounts);
        sb.append(", iAccountsByVatCode=").append(this.iAccountsByVatCode);
        sb.append(", iCreditMinusDebetSum=").append(this.iCreditMinusDebetSum);
        sb.append(", iDataSource=").append(this.iDataSource);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iDebetMinusCreditSum=").append(this.iDebetMinusCreditSum);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSVATReportRowPrinter
    extends SSPrinter {
        private SSDefaultTableModel<Integer> iModel;

        public SSVATReportRowPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("vatreport2015.rows.jrxml");
            this.iModel = new SSDefaultTableModel<Integer>(){

                @Override
                public Class getType() {
                    return Integer.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    Integer iNumber = (Integer)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iNumber;
                            break;
                        }
                        case 1: {
                            value = SSBundle.getBundle().getString("vatreport2015.group." + iNumber);
                            break;
                        }
                        case 2: {
                            value = SSVATReport2015Printer.this.getVATCodesForGroup(iNumber);
                            break;
                        }
                        case 3: {
                            value = SSVATReport2015Printer.this.getValueForGroup(iNumber).setScale(0, RoundingMode.DOWN);
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("group.number");
            this.iModel.addColumn("group.description");
            this.iModel.addColumn("group.vatcodes");
            this.iModel.addColumn("group.value");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setGroup(char iNumber) {
            LinkedList<Integer> iObjects = new LinkedList<Integer>();
            switch (iNumber) {
                case 'A': {
                    iObjects.add(5);
                    iObjects.add(6);
                    iObjects.add(7);
                    iObjects.add(8);
                    break;
                }
                case 'B': {
                    iObjects.add(10);
                    iObjects.add(11);
                    iObjects.add(12);
                    break;
                }
                case 'C': {
                    iObjects.add(20);
                    iObjects.add(21);
                    iObjects.add(22);
                    iObjects.add(23);
                    iObjects.add(24);
                    break;
                }
                case 'D': {
                    iObjects.add(30);
                    iObjects.add(31);
                    iObjects.add(32);
                    break;
                }
                case 'E': {
                    iObjects.add(35);
                    iObjects.add(36);
                    iObjects.add(37);
                    iObjects.add(38);
                    iObjects.add(39);
                    iObjects.add(40);
                    iObjects.add(41);
                    iObjects.add(42);
                    break;
                }
                case 'F': {
                    iObjects.add(48);
                    break;
                }
                case 'G': {
                    iObjects.add(49);
                    break;
                }
                case 'H': {
                    iObjects.add(50);
                    break;
                }
                case 'I': {
                    iObjects.add(60);
                    iObjects.add(61);
                    iObjects.add(62);
                }
            }
            this.iModel.setObjects((List<Integer>)iObjects);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSVATReport2015Printer.SSVATReportRowPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

