/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.calc.SSSalesTaxCalculator;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSVATReportPrinter
extends SSPrinter {
    private SSNewAccountingYear iAccountingYear;
    private Date iDateFrom;
    private Date iDateTo;

    public SSVATReportPrinter(SSNewAccountingYear pAccountingYear, Date pDateFrom, Date pDateTo) {
        this.iAccountingYear = pAccountingYear;
        this.iDateFrom = pDateFrom;
        this.iDateTo = pDateTo;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("vatreport.jrxml");
        this.setDetail("vatreport.jrxml");
        this.setSummary("vatreport.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("vatreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iDateFrom);
        this.addParameter("dateTo", this.iDateTo);
        SSSalesTaxCalculator iCalculator = new SSSalesTaxCalculator(this.iAccountingYear, this.iDateFrom, this.iDateTo);
        iCalculator.calculate();
        List<SSSalesTaxCalculator.SSVATReportGroup> iReportGroups = iCalculator.getReportGroups();
        SSDefaultTableModel<SSSalesTaxCalculator.SSVATReportGroup> iModel = new SSDefaultTableModel<SSSalesTaxCalculator.SSVATReportGroup>(){

            @Override
            public Class getType() {
                return SSSalesTaxCalculator.SSVATReportGroup.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                SSSalesTaxCalculator.SSVATReportGroup iReportGroup = (SSSalesTaxCalculator.SSVATReportGroup)this.getObject(rowIndex);
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iReportGroup.getGroup1();
                        break;
                    }
                    case 1: {
                        value = iReportGroup.getGroup1Description();
                        break;
                    }
                    case 2: {
                        value = iReportGroup.getGroup2();
                        break;
                    }
                    case 3: {
                        value = iReportGroup.getGroup2Description();
                        break;
                    }
                    case 4: {
                        value = iReportGroup.getSum().setScale(0, RoundingMode.DOWN);
                    }
                }
                return value;
            }
        };
        iModel.addColumn("group.1.number");
        iModel.addColumn("group.1.description");
        iModel.addColumn("group.2.number");
        iModel.addColumn("group.2.description");
        iModel.addColumn("group.2.sum");
        iModel.setObjects(iReportGroups);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSVATReportPrinter");
        sb.append("{iAccountingYear=").append(this.iAccountingYear);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append('}');
        return sb.toString();
    }
}

