/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSVoucherPrinter
extends SSPrinter {
    private String iTitle;
    private SSVoucher iVoucher;
    private List<SSAccount> iMarkedAccounts;
    private SSVoucherRowPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;

    public SSVoucherPrinter(SSVoucher pVoucher, String pTitle) {
        this.iVoucher = pVoucher;
        this.iTitle = pTitle;
        this.iMarkedAccounts = Collections.emptyList();
        this.setPageHeader("header.jrxml");
        this.setDetail("voucher.jrxml");
        this.setColumnHeader("voucher.jrxml");
    }

    public SSVoucherPrinter(SSVoucher pVoucher, String pTitle, SSAccount ... pMarkedAccounts) {
        this(pVoucher, pTitle);
        this.iMarkedAccounts = new LinkedList<SSAccount>();
        this.iMarkedAccounts.addAll(Arrays.asList(pMarkedAccounts));
    }

    public SSVoucherPrinter(SSVoucher pVoucher, String pTitle, List<SSAccount> pMarkedAccounts) {
        this(pVoucher, pTitle);
        this.iMarkedAccounts = pMarkedAccounts;
    }

    @Override
    public String getTitle() {
        return this.iTitle;
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSVoucherRowPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSVoucher> iModel = new SSDefaultTableModel<SSVoucher>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSInvoice.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSVoucher iVoucher = (SSVoucher)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iVoucher.getNumber();
                        break;
                    }
                    case 1: {
                        value = iVoucher.getDate() == null ? null : this.iFormat.format(iVoucher.getDate());
                        break;
                    }
                    case 2: {
                        value = iVoucher.getDescription();
                        break;
                    }
                    case 3: {
                        value = SSVoucherMath.getDebetSum(iVoucher);
                        break;
                    }
                    case 4: {
                        value = SSVoucherMath.getCreditSum(iVoucher);
                        break;
                    }
                    case 5: {
                        SSVoucherPrinter.this.iPrinter.setRows(iVoucher.getRows());
                        SSVoucherPrinter.this.iDataSource.reset();
                        value = SSVoucherPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("voucher.number");
        iModel.addColumn("voucher.date");
        iModel.addColumn("voucher.description");
        iModel.addColumn("voucher.debet");
        iModel.addColumn("voucher.credet");
        iModel.addColumn("voucher.rows");
        iModel.setObjects(this.iVoucher);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSVoucherPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iMarkedAccounts=").append(this.iMarkedAccounts);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append(", iTitle='").append(this.iTitle).append('\'');
        sb.append(", iVoucher=").append(this.iVoucher);
        sb.append('}');
        return sb.toString();
    }

    private class SSVoucherRowPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSVoucherRow> iModel;

        public SSVoucherRowPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("voucher.rows.jrxml");
            this.setSummary("voucher.rows.jrxml");
            this.iModel = new SSDefaultTableModel<SSVoucherRow>(){
                DateFormat iFormat = DateFormat.getDateInstance(3);

                @Override
                public Class getType() {
                    return SSVoucherRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Comparable<BigDecimal> value = null;
                    SSVoucherRow iRow = (SSVoucherRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getAccount() == null ? null : iRow.getAccount().getNumber();
                            break;
                        }
                        case 1: {
                            value = iRow.getAccount() == null ? null : iRow.getAccount().getDescription();
                            break;
                        }
                        case 2: {
                            value = iRow.getDebet();
                            break;
                        }
                        case 3: {
                            value = iRow.getCredit();
                            break;
                        }
                        case 4: {
                            value = iRow.getProject() == null ? null : iRow.getProject().getNumber();
                            break;
                        }
                        case 5: {
                            value = iRow.getResultUnit() == null ? null : iRow.getResultUnit().getNumber();
                            break;
                        }
                        case 6: {
                            value = iRow.isAdded();
                            break;
                        }
                        case 7: {
                            value = iRow.isCrossed();
                            break;
                        }
                        case 8: {
                            value = SSVoucherPrinter.this.iMarkedAccounts.contains(iRow.getAccount());
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("voucherrow.account");
            this.iModel.addColumn("voucherrow.description");
            this.iModel.addColumn("voucherrow.debet");
            this.iModel.addColumn("voucherrow.credet");
            this.iModel.addColumn("voucherrow.project");
            this.iModel.addColumn("voucherrow.resultunit");
            this.iModel.addColumn("voucherrow.isadded");
            this.iModel.addColumn("voucherrow.iscrossed");
            this.iModel.addColumn("voucherrow.ismarked");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setRows(List<SSVoucherRow> iRows) {
            this.iModel.setObjects(iRows);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSVoucherPrinter.SSVoucherRowPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

