/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report.journals;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSInpaymentMath;
import se.swedsoft.bookkeeping.data.SSInpayment;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSInpaymentjournalPrinter
extends SSPrinter {
    private Integer iNumber;
    private List<SSInpayment> iInpayments;
    private SSVoucherPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;

    public SSInpaymentjournalPrinter(List<SSInpayment> iInpayments, Integer iNumber, Date iDate) {
        this.iInpayments = iInpayments;
        this.iNumber = iNumber;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("journals/inpaymentjournal.jrxml");
        this.setDetail("journals/inpaymentjournal.jrxml");
        this.setSummary("journals/inpaymentjournal.jrxml");
        this.addParameter("periodTitle", this.iBundle.getString("inpaymentjournal.periodtitle"));
        this.addParameter("periodText", iDate);
    }

    @Override
    public String getTitle() {
        return String.format(this.iBundle.getString("inpaymentjournal.title"), this.iNumber);
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSVoucherPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        Collections.sort(this.iInpayments, new Comparator<SSInpayment>(){

            @Override
            public int compare(SSInpayment o1, SSInpayment o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        SSDefaultTableModel<SSInpayment> iModel = new SSDefaultTableModel<SSInpayment>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSInvoice.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSInpayment iInpayment = (SSInpayment)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iInpayment.getNumber();
                        break;
                    }
                    case 1: {
                        value = iInpayment.getText();
                        break;
                    }
                    case 2: {
                        value = iInpayment.getDate();
                        break;
                    }
                    case 3: {
                        value = SSInpaymentMath.getSum(iInpayment);
                        break;
                    }
                    case 4: {
                        SSInpaymentjournalPrinter.this.iPrinter.setInpayment(iInpayment);
                        SSInpaymentjournalPrinter.this.iDataSource.reset();
                        value = SSInpaymentjournalPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("inpayment.number");
        iModel.addColumn("inpayment.text");
        iModel.addColumn("inpayment.date");
        iModel.addColumn("inpayment.sum");
        iModel.addColumn("journal.rows");
        iModel.setObjects(this.iInpayments);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.journals.SSInpaymentjournalPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iInpayments=").append(this.iInpayments);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSVoucherPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSVoucherRow> iModel;

        public SSVoucherPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("journals/inpaymentjournal.rows.jrxml");
            this.iModel = new SSDefaultTableModel<SSVoucherRow>(){
                DateFormat iFormat = DateFormat.getDateInstance(3);

                @Override
                public Class getType() {
                    return SSVoucherRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    BigDecimal value = null;
                    SSVoucherRow iRow = (SSVoucherRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getAccount() == null ? null : iRow.getAccount().getNumber();
                            break;
                        }
                        case 1: {
                            value = iRow.getAccount() == null ? null : iRow.getAccount().getDescription();
                            break;
                        }
                        case 2: {
                            value = iRow.getDebet();
                            break;
                        }
                        case 3: {
                            value = iRow.getCredit();
                            break;
                        }
                        case 4: {
                            value = iRow.getProject() == null ? null : iRow.getProject().getNumber();
                            break;
                        }
                        case 5: {
                            value = iRow.getResultUnit() == null ? null : iRow.getResultUnit().getNumber();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("row.account");
            this.iModel.addColumn("row.description");
            this.iModel.addColumn("row.debet");
            this.iModel.addColumn("row.credet");
            this.iModel.addColumn("row.project");
            this.iModel.addColumn("row.resultunit");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setInpayment(SSInpayment iInpayment) {
            this.iModel.setObjects(iInpayment.getVoucher().getRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.journals.SSInpaymentjournalPrinter.SSVoucherPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

