/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report.sales;

import java.util.Locale;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSPurchaseOrderRow;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSSalePrinterUtils;

public class SSInquiryPrinter
extends SSPrinter {
    private SSPurchaseOrder iPurchaseOrder;
    private Locale iLocale;

    public SSInquiryPrinter(SSPurchaseOrder iPurchaseOrder, Locale iLocale) {
        this.iPurchaseOrder = iPurchaseOrder;
        this.iLocale = iLocale;
        ResourceBundle iBundle = ResourceBundle.getBundle("reports.inquiryreport", iLocale);
        this.setBundle(iBundle);
        this.setLocale(iLocale);
        this.setMargins(0, 0, 0, 0);
        this.setPageHeader("sales/sale.header.jrxml");
        this.setPageFooter("sales/sale.footer.jrxml");
        this.setDetail("sales/inquiry.jrxml");
        this.setColumnHeader("sales/inquiry.jrxml");
        this.setBackground("sales/inquiry.jrxml");
        this.addParameters();
    }

    @Override
    public String getTitle() {
        this.addParameter("title.date", this.iBundle.getString("inquiryreport.title.date"));
        this.addParameter("title.number", this.iBundle.getString("inquiryreport.title.number"));
        return this.iBundle.getString("inquiryreport.title");
    }

    private void addParameters() {
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        SSSalePrinterUtils.addParametersForCompany(iCompany, this);
        this.addParameter("number", this.iPurchaseOrder.getNumber());
        this.addParameter("date", this.iPurchaseOrder.getDate());
        this.addParameter("text", this.iPurchaseOrder.getText());
        this.addParameter("purchaseorder.deliveryadress.name", this.iPurchaseOrder.getDeliveryAddress().getName());
        this.addParameter("purchaseorder.deliveryadress.address1", this.iPurchaseOrder.getDeliveryAddress().getAddress1());
        this.addParameter("purchaseorder.deliveryadress.address2", this.iPurchaseOrder.getDeliveryAddress().getAddress2());
        this.addParameter("purchaseorder.deliveryadress.zipcode", this.iPurchaseOrder.getDeliveryAddress().getZipCode());
        this.addParameter("purchaseorder.deliveryadress.city", this.iPurchaseOrder.getDeliveryAddress().getCity());
        this.addParameter("purchaseorder.deliveryadress.country", this.iPurchaseOrder.getDeliveryAddress().getCountry());
        this.addParameter("purchaseorder.supplieraddress.name", this.iPurchaseOrder.getSupplierAddress().getName());
        this.addParameter("purchaseorder.supplieraddress.address1", this.iPurchaseOrder.getSupplierAddress().getAddress1());
        this.addParameter("purchaseorder.supplieraddress.address2", this.iPurchaseOrder.getSupplierAddress().getAddress2());
        this.addParameter("purchaseorder.supplieraddress.zipcode", this.iPurchaseOrder.getSupplierAddress().getZipCode());
        this.addParameter("purchaseorder.supplieraddress.city", this.iPurchaseOrder.getSupplierAddress().getCity());
        this.addParameter("purchaseorder.supplieraddress.country", this.iPurchaseOrder.getSupplierAddress().getCountry());
        this.addParameter("purchaseorder.ourcontact", this.iPurchaseOrder.getOurContact());
        this.addParameter("purchaseorder.yourcontact", this.iPurchaseOrder.getYourContact());
        this.addParameter("purchaseorder.deliveryterm", this.iPurchaseOrder.getDeliveryTerm(), true);
        this.addParameter("purchaseorder.deliveryway", this.iPurchaseOrder.getDeliveryWay(), true);
        this.addParameter("purchaseorder.paymentterm", this.iPurchaseOrder.getPaymentTerm(), true);
        this.addParameter("purchaseorder.currency", this.iPurchaseOrder.getCurrency(), true);
        this.addParameter("purchaseorder.totalsum", this.iPurchaseOrder.getSum());
    }

    @Override
    protected SSDefaultTableModel getModel() {
        final SSRowReport iPrinter = new SSRowReport();
        iPrinter.setBundle(this.iBundle);
        iPrinter.setLocale(this.iLocale);
        iPrinter.generateReport();
        this.addParameter("subreport.report", iPrinter.getReport());
        this.addParameter("subreport.parameters", iPrinter.getParameters());
        this.addParameter("subreport.datasource", iPrinter.getDataSource());
        SSDefaultTableModel<SSPurchaseOrder> iModel = new SSDefaultTableModel<SSPurchaseOrder>(){

            @Override
            public Class getType() {
                return SSPurchaseOrder.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                iPrinter.getDataSource().reset();
                return iPrinter.getDataSource();
            }
        };
        iModel.addColumn("subreport.datasource");
        iModel.setObjects(this.iPurchaseOrder);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.sales.SSInquiryPrinter");
        sb.append("{iLocale=").append(this.iLocale);
        sb.append(", iPurchaseOrder=").append(this.iPurchaseOrder);
        sb.append('}');
        return sb.toString();
    }

    private class SSRowReport
    extends SSPrinter {
        public SSRowReport() {
            this.setMargins(0, 0, 0, 0);
            this.setColumnHeader("sales/inquiry.rows.jrxml");
            this.setDetail("sales/inquiry.rows.jrxml");
            this.setPageFooter("sales/inquiry.rows.jrxml");
            this.setLastPageFooter("sales/inquiry.rows.jrxml");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            SSDefaultTableModel<SSPurchaseOrderRow> iModel = new SSDefaultTableModel<SSPurchaseOrderRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSPurchaseOrderRow iRow = (SSPurchaseOrderRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getSupplierArticleNr();
                            break;
                        }
                        case 1: {
                            value = iRow.getProductNr();
                            break;
                        }
                        case 2: {
                            value = iRow.getDescription(SSInquiryPrinter.this.iLocale);
                            break;
                        }
                        case 3: {
                            value = iRow.getQuantity();
                            break;
                        }
                        case 4: {
                            value = iRow.getUnit() == null ? null : iRow.getUnit().getName();
                            break;
                        }
                        case 5: {
                            value = iRow.getUnitPrice();
                            break;
                        }
                        case 6: {
                            value = iRow.getSum();
                        }
                    }
                    return value;
                }
            };
            iModel.addColumn("row.supplierarticlenr");
            iModel.addColumn("row.number");
            iModel.addColumn("row.description");
            iModel.addColumn("row.quantity");
            iModel.addColumn("row.unit");
            iModel.addColumn("row.unitprice");
            iModel.addColumn("row.sum");
            iModel.setObjects(SSInquiryPrinter.this.iPurchaseOrder.getRows());
            return iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }
    }
}

