/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report.sales;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.calc.SSOCRNumber;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.graphics.SSImage;
import se.swedsoft.bookkeeping.print.report.sales.SSInvoicePrinter;

public class SSOCRInvoicePrinter
extends SSInvoicePrinter {
    private SSORCInvoiceCodeRow iCodeRow;

    public SSOCRInvoicePrinter(SSInvoice iInvoice, Locale iLocale, boolean iShowBackground) {
        this.iInvoice = iInvoice;
        this.iLocale = iLocale;
        this.iLocale = iLocale;
        ResourceBundle iBundle = ResourceBundle.getBundle("reports.invoicereport", iLocale);
        this.setBundle(iBundle);
        this.setLocale(iLocale);
        this.setPageHeader("sales/sale.header.jrxml");
        this.setPageFooter("sales/ocrinvoice.jrxml");
        this.setDetail("sales/ocrinvoice.jrxml");
        this.setColumnHeader("sales/ocrinvoice.jrxml");
        if (iShowBackground) {
            this.setBackground("sales/ocrinvoice.jrxml");
        }
        this.setMargins(0, 0, 0, 0);
        this.iCodeRow = new SSORCInvoiceCodeRow();
        this.iCodeRow.setReferenceNumber(iInvoice.getOCRNumber());
        this.iCodeRow.setBankNumber(SSDB.getInstance().getCurrentCompany().getBankGiroNumber());
        this.iCodeRow.setValue(SSInvoiceMath.getTotalSum(iInvoice));
        this.addParameters();
    }

    @Override
    protected void addParameters() {
        super.addParameters();
        this.addParameter("number", Integer.decode(this.iInvoice.getOCRNumber()));
        this.addParameter("ocrinvoice.coderow", this.iCodeRow.toString());
        this.addParameter("ocrinvoice.background", SSImage.getImage("OCRBackground"));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.sales.SSOCRInvoicePrinter");
        sb.append("{iCodeRow=").append(this.iCodeRow);
        sb.append('}');
        return sb.toString();
    }

    public static class SSORCInvoiceCodeRow {
        private char[] iCharacters = new char[84];

        public SSORCInvoiceCodeRow() {
            for (int i = 0; i < 84; ++i) {
                this.iCharacters[i] = 32;
            }
            this.iCharacters[83] = 72;
        }

        public void setReferenceNumber(String iNumber) {
            String iText = iNumber.trim();
            for (int i = 0; i < iText.length(); ++i) {
                this.iCharacters[53 + i] = iText.charAt(iText.length() - i - 1);
            }
        }

        public void setValue(BigDecimal iValue) {
            DecimalFormat iFormat = new DecimalFormat("0.00");
            String iText = iFormat.format(iValue.doubleValue());
            for (int i = 0; i < iText.length(); ++i) {
                this.iCharacters[40 + i] = iText.charAt(iText.length() - i - 1);
            }
            iText = iText.replaceAll("\\.", "");
            iText = iText.replaceAll(",", "");
            this.iCharacters[42] = 32;
            this.iCharacters[36] = SSOCRNumber.getCheckSum(iText);
        }

        public void setBankNumber(String iNumber) {
            String iText = iNumber.replaceAll("-", "");
            int iLength = iText.length();
            for (int i = 0; i < iLength; ++i) {
                this.iCharacters[9 + i] = iText.charAt(iLength - i - 1);
            }
        }

        public String toString() {
            String iText = "";
            for (int i = 83; i > 0; --i) {
                iText = iText + this.iCharacters[i];
            }
            return iText;
        }
    }
}

