/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report.sales;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSStandardText;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSSalePrinterUtils;

public class SSReminderPrinter
extends SSPrinter {
    private List<SSInvoice> iInvoices;
    private SSCustomer iCustomer;
    private Locale iLocale;
    private Integer iMaxReminders;

    public SSReminderPrinter(List<SSInvoice> iInvoices, SSCustomer iCustomer, Locale iLocale) {
        this.iInvoices = iInvoices;
        this.iCustomer = iCustomer;
        this.iLocale = iLocale;
        ResourceBundle iBundle = ResourceBundle.getBundle("reports.reminderreport", iLocale);
        this.setBundle(iBundle);
        this.setLocale(iLocale);
        this.setMargins(0, 0, 0, 0);
        this.setPageHeader("sales/sale.header.jrxml");
        this.setPageFooter("sales/sale.footer.jrxml");
        this.setDetail("sales/reminder.jrxml");
        this.setColumnHeader("sales/reminder.jrxml");
        this.addParameters();
    }

    @Override
    public String getTitle() {
        this.addParameter("title.number", this.iBundle.getString("reminderreport.title.date"));
        return this.iBundle.getString("reminderreport.title");
    }

    private void addParameters() {
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        SSSalePrinterUtils.addParametersForCompany(iCompany, this);
        this.addParameter("date", new Date());
        this.addParameter("text", iCompany.getStandardText(SSStandardText.Reminder));
        if (this.iCustomer != null) {
            this.addParameter("customer.invoiceadress.name", this.iCustomer.getInvoiceAddress().getName());
            this.addParameter("customer.invoiceadress.address1", this.iCustomer.getInvoiceAddress().getAddress1());
            this.addParameter("customer.invoiceadress.address2", this.iCustomer.getInvoiceAddress().getAddress2());
            this.addParameter("customer.invoiceadress.zipcode", this.iCustomer.getInvoiceAddress().getZipCode());
            this.addParameter("customer.invoiceadress.city", this.iCustomer.getInvoiceAddress().getCity());
            this.addParameter("customer.invoiceadress.country", this.iCustomer.getInvoiceAddress().getCountry());
            this.addParameter("customer.customernr", this.iCustomer.getNumber());
            this.addParameter("customer.currency", this.iCustomer.getInvoiceCurrency(), true);
            this.addParameter("customer.ourcontact", this.iCustomer.getOurContactPerson());
            this.addParameter("customer.yourcontact", this.iCustomer.getYourContactPerson());
        }
        this.iMaxReminders = 0;
        for (SSInvoice iInvoice : this.iInvoices) {
            Integer iNumReminders = iInvoice.getNumReminders();
            if (iNumReminders <= this.iMaxReminders) continue;
            this.iMaxReminders = iNumReminders;
        }
        this.iMaxReminders = this.iMaxReminders + 1;
        BigDecimal iReminderfee = iCompany.getReminderfee();
        if (iReminderfee != null) {
            this.addParameter("reminder.reminderfee", iReminderfee.multiply(new BigDecimal(this.iMaxReminders)));
        } else {
            this.addParameter("reminder.reminderfee", new BigDecimal(0));
        }
    }

    @Override
    protected SSDefaultTableModel getModel() {
        final SSRowReport iPrinter = new SSRowReport();
        iPrinter.setBundle(this.iBundle);
        iPrinter.setLocale(this.iLocale);
        iPrinter.generateReport();
        this.addParameter("subreport.report", iPrinter.getReport());
        this.addParameter("subreport.parameters", iPrinter.getParameters());
        this.addParameter("subreport.datasource", iPrinter.getDataSource());
        SSDefaultTableModel<SSInvoice> iModel = new SSDefaultTableModel<SSInvoice>(){

            @Override
            public Class getType() {
                return SSInvoice.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                iPrinter.getDataSource().reset();
                return iPrinter.getDataSource();
            }
        };
        iModel.addColumn("subreport.datasource");
        iModel.setObjects(this.iInvoices.get(0));
        return iModel;
    }

    private static int getNumDelayedDays(SSInvoice iInvoice) {
        Date iDueDate = iInvoice.getDueDate();
        Date iNowDate = new Date();
        if (iDueDate == null) {
            return 0;
        }
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTimeInMillis(iNowDate.getTime() - iDueDate.getTime());
        int iYear = iCalendar.get(1) - 1970;
        int iDay = iCalendar.get(6);
        return iYear * iCalendar.getActualMaximum(6) + iDay;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.sales.SSReminderPrinter");
        sb.append("{iCustomer=").append(this.iCustomer);
        sb.append(", iInvoices=").append(this.iInvoices);
        sb.append(", iLocale=").append(this.iLocale);
        sb.append(", iMaxReminders=").append(this.iMaxReminders);
        sb.append('}');
        return sb.toString();
    }

    private class SSRowReport
    extends SSPrinter {
        public SSRowReport() {
            this.setMargins(0, 0, 0, 0);
            this.setColumnHeader("sales/reminder.rows.jrxml");
            this.setDetail("sales/reminder.rows.jrxml");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            SSDefaultTableModel<SSInvoice> iModel = new SSDefaultTableModel<SSInvoice>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSInvoice iInvoice = (SSInvoice)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            if (iInvoice.getOCRNumber() != null) {
                                value = iInvoice.getOCRNumber();
                                break;
                            }
                            value = iInvoice.getNumber().toString();
                            break;
                        }
                        case 1: {
                            value = iInvoice.getDate();
                            break;
                        }
                        case 2: {
                            value = iInvoice.getDueDate();
                            break;
                        }
                        case 3: {
                            value = SSReminderPrinter.getNumDelayedDays(iInvoice);
                            break;
                        }
                        case 4: {
                            value = iInvoice.getNumReminders() + 1;
                            break;
                        }
                        case 5: {
                            value = SSInvoiceMath.getSaldo(iInvoice.getNumber());
                            break;
                        }
                        case 6: {
                            value = iInvoice.getDelayInterest();
                            break;
                        }
                        case 7: {
                            value = SSInvoiceMath.getInterestSum(iInvoice, SSInvoiceMath.getSaldo(iInvoice.getNumber()), SSReminderPrinter.getNumDelayedDays(iInvoice));
                        }
                    }
                    return value;
                }
            };
            iModel.addColumn("invoice.number");
            iModel.addColumn("invoice.date");
            iModel.addColumn("invoice.duedate");
            iModel.addColumn("invoice.duedays");
            iModel.addColumn("invoice.numreminders");
            iModel.addColumn("invoice.saldo");
            iModel.addColumn("invoice.delayinterest");
            iModel.addColumn("invoice.delayfee");
            iModel.setObjects(SSReminderPrinter.this.iInvoices);
            return iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }
    }
}

