/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import se.swedsoft.bookkeeping.print.view.SSDocumentPanel;

public class SSViewer
extends JPanel {
    public static final int REPORT_RESOLUTION = 72;
    public static final int SCREEN_RESOLUTION = Toolkit.getDefaultToolkit().getScreenResolution();
    private Map<String, List<PropertyChangeListener>> iListenerMap;
    private JPanel iPagePanel = new JPanel();
    private SSDocumentPanel iDocumentPanel = new SSDocumentPanel();
    private JasperPrint iJasperPrint;
    private int iZoom = 100;
    private int iPageIndex;
    private float iScale = 1.0f;

    public SSViewer() {
        this.iListenerMap = new HashMap<String, List<PropertyChangeListener>>();
        this.iPagePanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.iPagePanel.add(this.iDocumentPanel.getPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)this.iPagePanel, "Center");
        this.createMouseEvents();
    }

    public void setPrinter(JasperPrint pJasperPrint) {
        this.iJasperPrint = pJasperPrint;
        this.notifyPropertyChangeListeners("page_change");
        this.notifyPropertyChangeListeners("page_zoom");
        this.setZoom(100);
        this.refreshPage();
    }

    public void firstPage() {
        this.setCurrentPage(0);
    }

    public void prevPage() {
        int index = this.iPageIndex - 1;
        this.setCurrentPage(index);
    }

    public void nextPage() {
        int index = this.iPageIndex + 1;
        this.setCurrentPage(index);
    }

    public void lastPage() {
        this.setCurrentPage(this.getPageCount() - 1);
    }

    public int getPageCount() {
        if (this.iJasperPrint != null && this.iJasperPrint.getPages() != null) {
            return this.iJasperPrint.getPages().size();
        }
        return 0;
    }

    public int getZoom() {
        return this.iZoom;
    }

    public void setZoom(int pZoom) {
        if (this.iZoom != pZoom) {
            this.iZoom = pZoom;
            this.iScale = (float)this.iZoom / 100.0f * 72.0f / (float)SCREEN_RESOLUTION;
            this.notifyPropertyChangeListeners("page_zoom");
            this.refreshPage();
        }
    }

    public void setCurrentPage(int pPageIndex) {
        if (pPageIndex >= 0 && pPageIndex < this.getPageCount() && this.iPageIndex != pPageIndex) {
            this.iPageIndex = pPageIndex;
            this.notifyPropertyChangeListeners("page_change");
            this.refreshPage();
        }
    }

    public int getCurrentPage() {
        return this.iPageIndex;
    }

    @Override
    public void addPropertyChangeListener(String pProperty, PropertyChangeListener pPropertyChangeListener) {
        List<PropertyChangeListener> iPropertyChangeListeners = this.iListenerMap.get(pProperty);
        if (iPropertyChangeListeners == null) {
            iPropertyChangeListeners = new LinkedList<PropertyChangeListener>();
            this.iListenerMap.put(pProperty, iPropertyChangeListeners);
        }
        iPropertyChangeListeners.add(pPropertyChangeListener);
    }

    private void notifyPropertyChangeListeners(String pProperty) {
        PropertyChangeEvent iEvent = new PropertyChangeEvent(this, pProperty, null, null);
        List<PropertyChangeListener> iPropertyChangeListeners = this.iListenerMap.get(pProperty);
        if (iPropertyChangeListeners != null) {
            for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners) {
                iPropertyChangeListener.propertyChange(iEvent);
            }
        }
    }

    private void refreshPage() {
        if (this.iJasperPrint == null) {
            return;
        }
        try {
            Image image = JasperPrintManager.printPageToImage(this.iJasperPrint, this.iPageIndex, this.iScale);
            int width = image.getWidth(this);
            int height = image.getHeight(this);
            Dimension iSize = new Dimension(width, height);
            Dimension iPageSize = new Dimension(width + 28, height + 28);
            this.iDocumentPanel.setDocument(image, iSize);
            this.iPagePanel.setLocation(0, 0);
            this.iPagePanel.setSize(iPageSize);
            this.setMaximumSize(iPageSize);
            this.setMinimumSize(iPageSize);
            this.setPreferredSize(iPageSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Container container = this.getParent();
        if (container instanceof JViewport) {
            ((JViewport)container).setViewPosition(new Point(0, 0));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SSViewer.this.getParent().repaint();
            }
        });
    }

    private void createMouseEvents() {
        final Point iMousePoint = new Point();
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SSViewer.this.setCursor(new Cursor(13));
                iMousePoint.x = e.getX();
                iMousePoint.y = e.getY();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SSViewer.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point iDelta = new Point(e.getX() - iMousePoint.x, e.getY() - iMousePoint.y);
                Container container = SSViewer.this.getParent();
                if (container instanceof JViewport) {
                    JViewport viewport = (JViewport)container;
                    Point iViewPosition = viewport.getViewPosition();
                    int maxX = SSViewer.this.iPagePanel.getWidth() - viewport.getWidth();
                    int maxY = SSViewer.this.iPagePanel.getHeight() - viewport.getHeight();
                    int newX = Math.max(0, Math.min(maxX, iViewPosition.x - iDelta.x));
                    int newY = Math.max(0, Math.min(maxY, iViewPosition.y - iDelta.y));
                    viewport.setViewPosition(new Point(newX, newY));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.view.SSViewer");
        sb.append("{iDocumentPanel=").append(this.iDocumentPanel);
        sb.append(", iJasperPrint=").append(this.iJasperPrint);
        sb.append(", iListenerMap=").append(this.iListenerMap);
        sb.append(", iPageIndex=").append(this.iPageIndex);
        sb.append(", iPagePanel=").append(this.iPagePanel);
        sb.append(", iScale=").append(this.iScale);
        sb.append(", iZoom=").append(this.iZoom);
        sb.append('}');
        return sb.toString();
    }
}

