/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import net.sf.jasperreports.charts.ChartContext;
import net.sf.jasperreports.charts.ChartTheme;
import net.sf.jasperreports.charts.ChartThemeBundle;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.util.JRFontUtil;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialRange;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.GanttRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class DefaultChartTheme
implements ChartTheme {
    public static final String PROPERTY_DIAL_VALUE_DISPLAY_VISIBLE = "net.sf.jasperreports.chart.dial.value.display.visible";
    public static final String PROPERTY_DIAL_LABEL = "net.sf.jasperreports.chart.dial.label";
    public static final String PROPERTY_RANGE_AXIS_TICK_COUNT = "net.sf.jasperreports.chart.range.axis.tick.count";
    public static final String PROPERTY_RANGE_AXIS_TICK_INTERVAL = "net.sf.jasperreports.chart.range.axis.tick.interval";
    public static final String PROPERTY_DOMAIN_AXIS_TICK_COUNT = "net.sf.jasperreports.chart.domain.axis.tick.count";
    public static final String PROPERTY_DOMAIN_AXIS_TICK_INTERVAL = "net.sf.jasperreports.chart.domain.axis.tick.interval";
    protected static final Color TRANSPARENT_PAINT = new Color(0, 0, 0, 0);
    private ChartContext chartContext = null;
    public static final ChartThemeBundle BUNDLE = new ChartThemeBundle(){
        private static final String NAME = "default";

        public String[] getChartThemeNames() {
            return new String[]{NAME};
        }

        public ChartTheme getChartTheme(String themeName) {
            if (NAME.equals(themeName)) {
                return new DefaultChartTheme();
            }
            return null;
        }
    };

    protected JRChart getChart() {
        return this.chartContext.getChart();
    }

    protected JRChartPlot getPlot() {
        return this.getChart().getPlot();
    }

    protected Dataset getDataset() {
        return this.chartContext.getDataset();
    }

    protected Object getLabelGenerator() {
        return this.chartContext.getLabelGenerator();
    }

    protected Locale getLocale() {
        return this.chartContext.getLocale();
    }

    protected final Object evaluateExpression(JRExpression expression) throws JRException {
        return this.chartContext.evaluateExpression(expression);
    }

    public JFreeChart createChart(ChartContext chartContext) throws JRException {
        this.chartContext = chartContext;
        JFreeChart jfreeChart = null;
        switch (this.getChart().getChartType()) {
            case 1: {
                jfreeChart = this.createAreaChart();
                break;
            }
            case 3: {
                jfreeChart = this.createBarChart();
                break;
            }
            case 2: {
                jfreeChart = this.createBar3DChart();
                break;
            }
            case 4: {
                jfreeChart = this.createBubbleChart();
                break;
            }
            case 5: {
                jfreeChart = this.createCandlestickChart();
                break;
            }
            case 6: {
                jfreeChart = this.createHighLowChart();
                break;
            }
            case 7: {
                jfreeChart = this.createLineChart();
                break;
            }
            case 17: {
                if (new Byte(3).equals(((JRMeterPlot)this.getPlot()).getShapeByte())) {
                    jfreeChart = this.createDialChart();
                    break;
                }
                jfreeChart = this.createMeterChart();
                break;
            }
            case 19: {
                break;
            }
            case 9: {
                jfreeChart = this.createPieChart();
                break;
            }
            case 8: {
                jfreeChart = this.createPie3DChart();
                break;
            }
            case 10: {
                jfreeChart = this.createScatterChart();
                break;
            }
            case 12: {
                jfreeChart = this.createStackedBarChart();
                break;
            }
            case 11: {
                jfreeChart = this.createStackedBar3DChart();
                break;
            }
            case 18: {
                jfreeChart = this.createThermometerChart();
                break;
            }
            case 16: {
                jfreeChart = this.createTimeSeriesChart();
                break;
            }
            case 13: {
                jfreeChart = this.createXyAreaChart();
                break;
            }
            case 14: {
                jfreeChart = this.createXYBarChart();
                break;
            }
            case 15: {
                jfreeChart = this.createXyLineChart();
                break;
            }
            case 20: {
                jfreeChart = this.createStackedAreaChart();
                break;
            }
            case 21: {
                jfreeChart = this.createGanttChart();
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type " + this.getChart().getChartType() + " not supported.");
            }
        }
        return jfreeChart;
    }

    protected void configureChart(JFreeChart jfreeChart) throws JRException {
        LegendTitle legend;
        String subtitleText;
        if (this.getChart().getMode() == 1) {
            jfreeChart.setBackgroundPaint(this.getChart().getBackcolor());
        } else {
            jfreeChart.setBackgroundPaint(TRANSPARENT_PAINT);
        }
        RectangleEdge titleEdge = DefaultChartTheme.getEdge(this.getChart().getTitlePositionByte(), RectangleEdge.TOP);
        if (jfreeChart.getTitle() != null) {
            TextTitle title = jfreeChart.getTitle();
            title.setPaint(this.getChart().getTitleColor());
            title.setFont(JRFontUtil.getAwtFont(this.getChart().getTitleFont(), this.getLocale()));
            title.setPosition(titleEdge);
        }
        if ((subtitleText = (String)this.evaluateExpression(this.getChart().getSubtitleExpression())) != null) {
            TextTitle subtitle = new TextTitle(subtitleText);
            subtitle.setPaint(this.getChart().getSubtitleColor());
            subtitle.setFont(JRFontUtil.getAwtFont(this.getChart().getSubtitleFont(), this.getLocale()));
            subtitle.setPosition(titleEdge);
            jfreeChart.addSubtitle(subtitle);
        }
        if ((legend = jfreeChart.getLegend()) != null) {
            legend.setItemPaint(this.getChart().getLegendColor());
            if (this.getChart().getOwnLegendBackgroundColor() == null) {
                legend.setBackgroundPaint(TRANSPARENT_PAINT);
            } else {
                legend.setBackgroundPaint(this.getChart().getLegendBackgroundColor());
            }
            legend.setItemFont(JRFontUtil.getAwtFont(this.getChart().getLegendFont(), this.getLocale()));
            legend.setPosition(DefaultChartTheme.getEdge(this.getChart().getLegendPositionByte(), RectangleEdge.BOTTOM));
        }
        this.configurePlot(jfreeChart.getPlot());
    }

    protected void configurePlot(Plot plot) {
        SortedSet seriesColors;
        plot.setOutlinePaint(TRANSPARENT_PAINT);
        if (this.getPlot().getOwnBackcolor() == null) {
            plot.setBackgroundPaint(TRANSPARENT_PAINT);
        } else {
            plot.setBackgroundPaint(this.getPlot().getBackcolor());
        }
        float backgroundAlpha = this.getPlot().getBackgroundAlphaFloat() == null ? 1.0f : this.getPlot().getBackgroundAlphaFloat().floatValue();
        float foregroundAlpha = this.getPlot().getForegroundAlphaFloat() == null ? 1.0f : this.getPlot().getForegroundAlphaFloat().floatValue();
        plot.setBackgroundAlpha(backgroundAlpha);
        plot.setForegroundAlpha(foregroundAlpha);
        if (plot instanceof CategoryPlot) {
            double labelRotation;
            CategoryAxis axis = ((CategoryPlot)plot).getDomainAxis();
            double d = labelRotation = this.getPlot().getLabelRotationDouble() == null ? 0.0 : this.getPlot().getLabelRotationDouble();
            if (labelRotation == 90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            } else if (labelRotation == -90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            } else if (labelRotation < 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions(-labelRotation / 180.0 * Math.PI));
            } else if (labelRotation > 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createDownRotationLabelPositions(labelRotation / 180.0 * Math.PI));
            }
        }
        if ((seriesColors = this.getPlot().getSeriesColors()) != null && seriesColors.size() > 0) {
            if (seriesColors.size() == 1) {
                Paint[] colors = new Paint[DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length + 1];
                colors[0] = ((JRChartPlot.JRSeriesColor)seriesColors.first()).getColor();
                for (int i = 0; i < DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length; ++i) {
                    colors[i + 1] = DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE[i];
                }
                plot.setDrawingSupplier(new DefaultDrawingSupplier(colors, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            } else if (seriesColors.size() > 1) {
                Paint[] colors = new Color[seriesColors.size()];
                JRChartPlot.JRSeriesColor[] colorSequence = new JRChartPlot.JRSeriesColor[seriesColors.size()];
                seriesColors.toArray(colorSequence);
                for (int i = 0; i < colorSequence.length; ++i) {
                    colors[i] = colorSequence[i].getColor();
                }
                plot.setDrawingSupplier(new DefaultDrawingSupplier(colors, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            }
        }
    }

    protected void configureAxis(Axis axis, JRFont labelFont, Color labelColor, JRFont tickLabelFont, Color tickLabelColor, String tickLabelMask, Color lineColor, boolean isRangeAxis, Comparable axisMinValue, Comparable axisMaxValue) {
        axis.setLabelFont(JRFontUtil.getAwtFont(labelFont, this.getLocale()));
        axis.setTickLabelFont(JRFontUtil.getAwtFont(tickLabelFont, this.getLocale()));
        if (labelColor != null) {
            axis.setLabelPaint(labelColor);
        }
        if (tickLabelColor != null) {
            axis.setTickLabelPaint(tickLabelColor);
        }
        if (lineColor != null) {
            axis.setAxisLinePaint(lineColor);
            axis.setTickMarkPaint(lineColor);
        }
        if (tickLabelMask != null) {
            if (axis instanceof NumberAxis) {
                NumberFormat fmt = NumberFormat.getInstance();
                if (fmt instanceof DecimalFormat) {
                    ((DecimalFormat)fmt).applyPattern(tickLabelMask);
                }
                ((NumberAxis)axis).setNumberFormatOverride(fmt);
            } else if (axis instanceof DateAxis) {
                DateFormat fmt = null;
                fmt = tickLabelMask.equals("SHORT") || tickLabelMask.equals("DateFormat.SHORT") ? DateFormat.getDateInstance(3) : (tickLabelMask.equals("MEDIUM") || tickLabelMask.equals("DateFormat.MEDIUM") ? DateFormat.getDateInstance(2) : (tickLabelMask.equals("LONG") || tickLabelMask.equals("DateFormat.LONG") ? DateFormat.getDateInstance(1) : (tickLabelMask.equals("FULL") || tickLabelMask.equals("DateFormat.FULL") ? DateFormat.getDateInstance(0) : new SimpleDateFormat(tickLabelMask))));
                ((DateAxis)axis).setDateFormatOverride(fmt);
            }
        }
        this.setAxisBounds(axis, isRangeAxis, axisMinValue, axisMaxValue);
    }

    protected JFreeChart createAreaChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createAreaChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)this.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis(((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis(((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createBar3DChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBarChart3D((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)this.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBar3DPlot bar3DPlot = (JRBar3DPlot)this.getPlot();
        BarRenderer3D barRenderer3D = new BarRenderer3D(bar3DPlot.getXOffsetDouble() == null ? 12.0 : bar3DPlot.getXOffsetDouble(), bar3DPlot.getYOffsetDouble() == null ? 8.0 : bar3DPlot.getYOffsetDouble());
        barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        barRenderer3D.setBaseItemLabelsVisible(bar3DPlot.getShowLabels() == null ? false : bar3DPlot.getShowLabels());
        categoryPlot.setRenderer(barRenderer3D);
        this.configureAxis(categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(bar3DPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(bar3DPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis(categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(bar3DPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(bar3DPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createBarChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBarChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)this.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        this.configureAxis(categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(barPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMaxValueExpression()));
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        this.configureAxis(categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression()));
        BarRenderer categoryRenderer = (BarRenderer)categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setBaseItemLabelsVisible(barPlot.getShowLabels() == null ? false : barPlot.getShowLabels());
        categoryRenderer.setShadowVisible(false);
        return jfreeChart;
    }

    protected JFreeChart createBubbleChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBubbleChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getXAxisLabelExpression()), (String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getYAxisLabelExpression()), (XYZDataset)this.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRBubblePlot bubblePlot = (JRBubblePlot)this.getPlot();
        int scaleType = bubblePlot.getScaleTypeInteger() == null ? 2 : bubblePlot.getScaleTypeInteger();
        XYBubbleRenderer bubbleRenderer = new XYBubbleRenderer(scaleType);
        xyPlot.setRenderer(bubbleRenderer);
        this.configureAxis(xyPlot.getDomainAxis(), bubblePlot.getXAxisLabelFont(), bubblePlot.getXAxisLabelColor(), bubblePlot.getXAxisTickLabelFont(), bubblePlot.getXAxisTickLabelColor(), bubblePlot.getXAxisTickLabelMask(), bubblePlot.getXAxisLineColor(), false, (Comparable)this.evaluateExpression(bubblePlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(bubblePlot.getDomainAxisMinValueExpression()));
        this.configureAxis(xyPlot.getRangeAxis(), bubblePlot.getYAxisLabelFont(), bubblePlot.getYAxisLabelColor(), bubblePlot.getYAxisTickLabelFont(), bubblePlot.getYAxisTickLabelColor(), bubblePlot.getYAxisTickLabelMask(), bubblePlot.getYAxisLineColor(), true, (Comparable)this.evaluateExpression(bubblePlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(bubblePlot.getRangeAxisMinValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createCandlestickChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createCandlestickChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getTimeAxisLabelExpression()), (String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getValueAxisLabelExpression()), (DefaultHighLowDataset)this.getDataset(), this.isShowLegend());
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRCandlestickPlot candlestickPlot = (JRCandlestickPlot)this.getPlot();
        CandlestickRenderer candlestickRenderer = (CandlestickRenderer)xyPlot.getRenderer();
        boolean isShowVolume = candlestickPlot.getShowVolume() == null ? true : candlestickPlot.getShowVolume();
        candlestickRenderer.setDrawVolume(isShowVolume);
        this.configureAxis(xyPlot.getDomainAxis(), candlestickPlot.getTimeAxisLabelFont(), candlestickPlot.getTimeAxisLabelColor(), candlestickPlot.getTimeAxisTickLabelFont(), candlestickPlot.getTimeAxisTickLabelColor(), candlestickPlot.getTimeAxisTickLabelMask(), candlestickPlot.getTimeAxisLineColor(), false, (Comparable)this.evaluateExpression(candlestickPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(candlestickPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis(xyPlot.getRangeAxis(), candlestickPlot.getValueAxisLabelFont(), candlestickPlot.getValueAxisLabelColor(), candlestickPlot.getValueAxisTickLabelFont(), candlestickPlot.getValueAxisTickLabelColor(), candlestickPlot.getValueAxisTickLabelMask(), candlestickPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(candlestickPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(candlestickPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createHighLowChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createHighLowChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getTimeAxisLabelExpression()), (String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getValueAxisLabelExpression()), (DefaultHighLowDataset)this.getDataset(), this.isShowLegend());
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRHighLowPlot highLowPlot = (JRHighLowPlot)this.getPlot();
        HighLowRenderer hlRenderer = (HighLowRenderer)xyPlot.getRenderer();
        boolean isShowOpenTicks = highLowPlot.getShowOpenTicks() == null ? false : highLowPlot.getShowOpenTicks();
        boolean isShowCloseTicks = highLowPlot.getShowCloseTicks() == null ? false : highLowPlot.getShowCloseTicks();
        hlRenderer.setDrawOpenTicks(isShowOpenTicks);
        hlRenderer.setDrawCloseTicks(isShowCloseTicks);
        this.configureAxis(xyPlot.getDomainAxis(), highLowPlot.getTimeAxisLabelFont(), highLowPlot.getTimeAxisLabelColor(), highLowPlot.getTimeAxisTickLabelFont(), highLowPlot.getTimeAxisTickLabelColor(), highLowPlot.getTimeAxisTickLabelMask(), highLowPlot.getTimeAxisLineColor(), false, (Comparable)this.evaluateExpression(highLowPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(highLowPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis(xyPlot.getRangeAxis(), highLowPlot.getValueAxisLabelFont(), highLowPlot.getValueAxisLabelColor(), highLowPlot.getValueAxisTickLabelFont(), highLowPlot.getValueAxisTickLabelColor(), highLowPlot.getValueAxisTickLabelMask(), highLowPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(highLowPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(highLowPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createLineChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createLineChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)this.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        LineAndShapeRenderer lineRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        boolean isShowShapes = linePlot.getShowShapes() == null ? true : linePlot.getShowShapes();
        boolean isShowLines = linePlot.getShowLines() == null ? true : linePlot.getShowLines();
        lineRenderer.setBaseShapesVisible(isShowShapes);
        lineRenderer.setBaseLinesVisible(isShowLines);
        this.configureAxis(categoryPlot.getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(linePlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getDomainAxisMaxValueExpression()));
        this.configureAxis(categoryPlot.getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(linePlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createPie3DChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createPieChart3D((String)this.evaluateExpression(this.getChart().getTitleExpression()), (PieDataset)this.getDataset(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        PiePlot3D piePlot3D = (PiePlot3D)jfreeChart.getPlot();
        JRPie3DPlot jrPlot = (JRPie3DPlot)this.getPlot();
        double depthFactor = jrPlot.getDepthFactorDouble() == null ? 0.2 : jrPlot.getDepthFactorDouble();
        boolean isCircular = jrPlot.getCircular() == null ? false : jrPlot.getCircular();
        piePlot3D.setDepthFactor(depthFactor);
        piePlot3D.setCircular(isCircular);
        PieSectionLabelGenerator labelGenerator = (PieSectionLabelGenerator)this.getLabelGenerator();
        if (labelGenerator != null) {
            piePlot3D.setLabelGenerator(labelGenerator);
        } else if (((JRPie3DPlot)this.getPlot()).getLabelFormat() != null) {
            piePlot3D.setLabelGenerator(new StandardPieSectionLabelGenerator(((JRPie3DPlot)this.getPlot()).getLabelFormat()));
        }
        if (((JRPie3DPlot)this.getPlot()).getLegendLabelFormat() != null) {
            piePlot3D.setLegendLabelGenerator(new StandardPieSectionLabelGenerator(((JRPie3DPlot)this.getPlot()).getLegendLabelFormat()));
        }
        piePlot3D.setLabelFont(JRFontUtil.getAwtFont(new JRBaseFont(this.getChart(), null), this.getLocale()));
        piePlot3D.setLabelPaint(this.getChart().getForecolor());
        return jfreeChart;
    }

    protected JFreeChart createPieChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createPieChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), (PieDataset)this.getDataset(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        PiePlot piePlot = (PiePlot)jfreeChart.getPlot();
        JRPiePlot jrPlot = (JRPiePlot)this.getPlot();
        boolean isCircular = jrPlot.getCircular() == null ? true : jrPlot.getCircular();
        piePlot.setCircular(isCircular);
        PieSectionLabelGenerator labelGenerator = (PieSectionLabelGenerator)this.getLabelGenerator();
        if (labelGenerator != null) {
            piePlot.setLabelGenerator(labelGenerator);
        } else if (((JRPiePlot)this.getPlot()).getLabelFormat() != null) {
            piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator(((JRPiePlot)this.getPlot()).getLabelFormat()));
        }
        if (((JRPiePlot)this.getPlot()).getLegendLabelFormat() != null) {
            piePlot.setLegendLabelGenerator(new StandardPieSectionLabelGenerator(((JRPiePlot)this.getPlot()).getLegendLabelFormat()));
        }
        piePlot.setLabelFont(JRFontUtil.getAwtFont(new JRBaseFont(this.getChart(), null), this.getLocale()));
        piePlot.setLabelPaint(this.getChart().getForecolor());
        return jfreeChart;
    }

    protected JFreeChart createScatterChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createScatterPlot((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getXAxisLabelExpression()), (String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getYAxisLabelExpression()), (XYDataset)this.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        XYLineAndShapeRenderer plotRenderer = (XYLineAndShapeRenderer)((XYPlot)jfreeChart.getPlot()).getRenderer();
        JRScatterPlot scatterPlot = (JRScatterPlot)this.getPlot();
        boolean isShowLines = scatterPlot.getShowLines() == null ? true : scatterPlot.getShowLines();
        boolean isShowShapes = scatterPlot.getShowShapes() == null ? true : scatterPlot.getShowShapes();
        plotRenderer.setBaseLinesVisible(isShowLines);
        plotRenderer.setBaseShapesVisible(isShowShapes);
        this.configureAxis(jfreeChart.getXYPlot().getDomainAxis(), scatterPlot.getXAxisLabelFont(), scatterPlot.getXAxisLabelColor(), scatterPlot.getXAxisTickLabelFont(), scatterPlot.getXAxisTickLabelColor(), scatterPlot.getXAxisTickLabelMask(), scatterPlot.getXAxisLineColor(), false, (Comparable)this.evaluateExpression(scatterPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(scatterPlot.getDomainAxisMinValueExpression()));
        this.configureAxis(jfreeChart.getXYPlot().getRangeAxis(), scatterPlot.getYAxisLabelFont(), scatterPlot.getYAxisLabelColor(), scatterPlot.getYAxisTickLabelFont(), scatterPlot.getYAxisTickLabelColor(), scatterPlot.getYAxisTickLabelMask(), scatterPlot.getYAxisLineColor(), true, (Comparable)this.evaluateExpression(scatterPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(scatterPlot.getRangeAxisMinValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createStackedBar3DChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedBarChart3D((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)this.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBar3DPlot bar3DPlot = (JRBar3DPlot)this.getPlot();
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D(bar3DPlot.getXOffsetDouble() == null ? 12.0 : bar3DPlot.getXOffsetDouble(), bar3DPlot.getYOffsetDouble() == null ? 8.0 : bar3DPlot.getYOffsetDouble());
        stackedBarRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        stackedBarRenderer3D.setBaseItemLabelsVisible(bar3DPlot.getShowLabels() == null ? false : bar3DPlot.getShowLabels());
        categoryPlot.setRenderer(stackedBarRenderer3D);
        this.configureAxis(categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(bar3DPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(bar3DPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis(categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(bar3DPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(bar3DPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createStackedBarChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedBarChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)this.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        StackedBarRenderer categoryRenderer = (StackedBarRenderer)categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setBaseItemLabelsVisible(isShowLabels);
        categoryRenderer.setShadowVisible(false);
        this.configureAxis(categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(barPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis(categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createStackedAreaChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedAreaChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)this.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis(((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis(((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMaxValueExpression()));
        ((CategoryPlot)jfreeChart.getPlot()).getDomainAxis().setCategoryMargin(0.0);
        return jfreeChart;
    }

    protected JFreeChart createXyAreaChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYAreaChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression()), (XYDataset)this.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis(jfreeChart.getXYPlot().getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis(jfreeChart.getXYPlot().getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createXYBarChart() throws JRException {
        IntervalXYDataset tmpDataset = (IntervalXYDataset)this.getDataset();
        boolean isDate = true;
        if (this.getChart().getDataset().getDatasetType() == 3) {
            isDate = false;
        }
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYBarChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression()), isDate, (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression()), tmpDataset, this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYBarRenderer itemRenderer = (XYBarRenderer)xyPlot.getRenderer();
        itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)this.getLabelGenerator());
        itemRenderer.setShadowVisible(false);
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        itemRenderer.setBaseItemLabelsVisible(isShowLabels);
        this.configureAxis(xyPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(barPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis(xyPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createXyLineChart() throws JRException {
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYLineChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(linePlot.getCategoryAxisLabelExpression()), (String)this.evaluateExpression(linePlot.getValueAxisLabelExpression()), (XYDataset)this.getDataset(), linePlot.getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        this.configureAxis(jfreeChart.getXYPlot().getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(linePlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getDomainAxisMaxValueExpression()));
        this.configureAxis(jfreeChart.getXYPlot().getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(linePlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getRangeAxisMaxValueExpression()));
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)jfreeChart.getXYPlot().getRenderer();
        boolean isShowShapes = linePlot.getShowShapes() == null ? true : linePlot.getShowShapes();
        boolean isShowLines = linePlot.getShowLines() == null ? true : linePlot.getShowLines();
        lineRenderer.setBaseShapesVisible(isShowShapes);
        lineRenderer.setBaseLinesVisible(isShowLines);
        return jfreeChart;
    }

    protected JFreeChart createTimeSeriesChart() throws JRException {
        String timeAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getTimeAxisLabelExpression());
        String valueAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getValueAxisLabelExpression());
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createTimeSeriesChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), timeAxisLabel, valueAxisLabel, (TimeSeriesCollection)this.getDataset(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRTimeSeriesPlot timeSeriesPlot = (JRTimeSeriesPlot)this.getPlot();
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
        boolean isShowShapes = timeSeriesPlot.getShowShapes() == null ? true : timeSeriesPlot.getShowShapes();
        boolean isShowLines = timeSeriesPlot.getShowLines() == null ? true : timeSeriesPlot.getShowLines();
        lineRenderer.setBaseLinesVisible(isShowLines);
        lineRenderer.setBaseShapesVisible(isShowShapes);
        this.configureAxis(xyPlot.getDomainAxis(), timeSeriesPlot.getTimeAxisLabelFont(), timeSeriesPlot.getTimeAxisLabelColor(), timeSeriesPlot.getTimeAxisTickLabelFont(), timeSeriesPlot.getTimeAxisTickLabelColor(), timeSeriesPlot.getTimeAxisTickLabelMask(), timeSeriesPlot.getTimeAxisLineColor(), false, (Comparable)this.evaluateExpression(timeSeriesPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(timeSeriesPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis(xyPlot.getRangeAxis(), timeSeriesPlot.getValueAxisLabelFont(), timeSeriesPlot.getValueAxisLabelColor(), timeSeriesPlot.getValueAxisTickLabelFont(), timeSeriesPlot.getValueAxisTickLabelColor(), timeSeriesPlot.getValueAxisTickLabelMask(), timeSeriesPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(timeSeriesPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(timeSeriesPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createGanttChart() throws JRException {
        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createGanttChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression()), (GanttCategoryDataset)this.getDataset(), this.isShowLegend(), true, false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        this.configureAxis(categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor(), false, null, null);
        ((DateAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((DateAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        this.configureAxis(categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression()));
        GanttRenderer categoryRenderer = (GanttRenderer)categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setBaseItemLabelsVisible(isShowLabels);
        categoryRenderer.setShadowVisible(false);
        return jfreeChart;
    }

    protected Range convertRange(JRDataRange dataRange) throws JRException {
        if (dataRange == null) {
            return null;
        }
        Number low = (Number)this.evaluateExpression(dataRange.getLowExpression());
        Number high = (Number)this.evaluateExpression(dataRange.getHighExpression());
        return new Range(low != null ? low.doubleValue() : 0.0, high != null ? high.doubleValue() : 100.0);
    }

    protected MeterInterval convertInterval(JRMeterInterval interval) throws JRException {
        String label = interval.getLabel();
        if (label == null) {
            label = "";
        }
        Range range = this.convertRange(interval.getDataRange());
        Color color = interval.getBackgroundColor() == null ? this.getChart().getBackcolor() : interval.getBackgroundColor();
        float[] components = color.getRGBColorComponents(null);
        float alpha = interval.getAlphaDouble() == null ? 1.0f : interval.getAlphaDouble().floatValue();
        Color alphaColor = new Color(components[0], components[1], components[2], alpha);
        return new MeterInterval(label, range, alphaColor, null, alphaColor);
    }

    protected JFreeChart createMeterChart() throws JRException {
        List intervals;
        JRValueDisplay display;
        JRMeterPlot jrPlot = (JRMeterPlot)this.getPlot();
        MeterPlot chartPlot = new MeterPlot((ValueDataset)this.getDataset());
        int shape = jrPlot.getShapeByte() == null ? 2 : jrPlot.getShapeByte().intValue();
        switch (shape) {
            case 0: {
                chartPlot.setDialShape(DialShape.CHORD);
                break;
            }
            case 1: {
                chartPlot.setDialShape(DialShape.CIRCLE);
                break;
            }
            default: {
                chartPlot.setDialShape(DialShape.PIE);
            }
        }
        chartPlot.setRange(this.convertRange(jrPlot.getDataRange()));
        int meterAngle = jrPlot.getMeterAngleInteger() == null ? 180 : jrPlot.getMeterAngleInteger();
        chartPlot.setMeterAngle(meterAngle);
        String units = jrPlot.getUnits();
        if (units != null && units.length() > 0) {
            chartPlot.setUnits(units);
        }
        if (jrPlot.getTickLabelFont() != null) {
            chartPlot.setTickLabelFont(JRFontUtil.getAwtFont(jrPlot.getTickLabelFont(), this.getLocale()));
        }
        double tickInterval = jrPlot.getTickIntervalDouble() == null ? 10.0 : jrPlot.getTickIntervalDouble();
        chartPlot.setTickSize(tickInterval);
        Color color = jrPlot.getMeterBackgroundColor();
        if (color != null) {
            chartPlot.setDialBackgroundPaint(color);
        }
        if ((color = jrPlot.getNeedleColor()) != null) {
            chartPlot.setNeedlePaint(color);
        }
        if ((display = jrPlot.getValueDisplay()) != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint(display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setTickLabelFormat(new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                chartPlot.setValueFont(JRFontUtil.getAwtFont(display.getFont(), this.getLocale()));
            }
        }
        if ((color = jrPlot.getTickColor()) != null) {
            chartPlot.setTickPaint(color);
        }
        if ((intervals = jrPlot.getIntervals()) != null) {
            Iterator iter = intervals.iterator();
            while (iter.hasNext()) {
                JRMeterInterval interval = (JRMeterInterval)iter.next();
                chartPlot.addInterval(this.convertInterval(interval));
            }
        }
        JFreeChart jfreeChart = new JFreeChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), null, chartPlot, this.isShowLegend());
        this.configureChart(jfreeChart);
        return jfreeChart;
    }

    protected JFreeChart createThermometerChart() throws JRException {
        JRValueDisplay display;
        JRThermometerPlot jrPlot = (JRThermometerPlot)this.getPlot();
        ThermometerPlot chartPlot = new ThermometerPlot((ValueDataset)this.getDataset());
        Range range = this.convertRange(jrPlot.getDataRange());
        chartPlot.setLowerBound(range.getLowerBound());
        chartPlot.setUpperBound(range.getUpperBound());
        chartPlot.setUnits(0);
        Color color = jrPlot.getMercuryColor();
        if (color != null) {
            chartPlot.setMercuryPaint(color);
        }
        if ((display = jrPlot.getValueDisplay()) != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint(display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setValueFormat(new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                chartPlot.setValueFont(JRFontUtil.getAwtFont(display.getFont(), this.getLocale()));
            }
        }
        int valueLocation = jrPlot.getValueLocationByte() == null ? 3 : (int)jrPlot.getValueLocationByte().byteValue();
        switch (valueLocation) {
            case 0: {
                chartPlot.setValueLocation(0);
                break;
            }
            case 1: {
                chartPlot.setValueLocation(2);
                break;
            }
            case 2: {
                chartPlot.setValueLocation(1);
                break;
            }
            default: {
                chartPlot.setValueLocation(3);
            }
        }
        range = this.convertRange(jrPlot.getLowRange());
        if (range != null) {
            chartPlot.setSubrangeInfo(2, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getMediumRange())) != null) {
            chartPlot.setSubrangeInfo(1, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getHighRange())) != null) {
            chartPlot.setSubrangeInfo(0, range.getLowerBound(), range.getUpperBound());
        }
        JFreeChart jfreeChart = new JFreeChart(chartPlot);
        this.configureChart(jfreeChart);
        return jfreeChart;
    }

    protected JFreeChart createDialChart() throws JRException {
        String label;
        JRValueDisplay display;
        String displayVisibility;
        JRMeterPlot jrPlot = (JRMeterPlot)this.getPlot();
        DialPlot dialPlot = new DialPlot();
        dialPlot.setDataset((ValueDataset)this.getDataset());
        StandardDialFrame dialFrame = new StandardDialFrame();
        dialPlot.setDialFrame(dialFrame);
        DialBackground db = new DialBackground(jrPlot.getBackcolor());
        dialPlot.setBackground(db);
        Range range = this.convertRange(jrPlot.getDataRange());
        StandardDialScale scale = new StandardDialScale(range.getLowerBound(), range.getUpperBound(), 225.0, -270.0, (range.getUpperBound() - range.getLowerBound()) / 6.0, 15);
        scale.setTickRadius(0.9);
        scale.setTickLabelOffset(0.16);
        if (jrPlot.getTickLabelFont() != null) {
            scale.setTickLabelFont(JRFontUtil.getAwtFont(jrPlot.getTickLabelFont(), this.getLocale()));
        }
        scale.setMajorTickStroke(new BasicStroke(1.0f));
        scale.setMinorTickStroke(new BasicStroke(0.3f));
        scale.setMajorTickPaint(jrPlot.getTickColor());
        scale.setMinorTickPaint(jrPlot.getTickColor());
        scale.setTickLabelsVisible(true);
        scale.setFirstTickLabelVisible(true);
        dialPlot.addScale(0, scale);
        List intervals = jrPlot.getIntervals();
        if (intervals != null && intervals.size() > 0) {
            int size = Math.min(3, intervals.size());
            int colorStep = 0;
            if (size > 0) {
                colorStep = 255 / size;
            }
            for (int i = 0; i < size; ++i) {
                JRMeterInterval interval = (JRMeterInterval)intervals.get(i);
                Range intervalRange = this.convertRange(interval.getDataRange());
                Color color = new Color(255 - colorStep * i, 0 + colorStep * i, 0);
                StandardDialRange dialRange = new StandardDialRange(intervalRange.getLowerBound(), intervalRange.getUpperBound(), interval.getBackgroundColor() == null ? color : interval.getBackgroundColor());
                dialRange.setInnerRadius(0.41);
                dialRange.setOuterRadius(0.41);
                dialPlot.addLayer(dialRange);
            }
        }
        String string = displayVisibility = (display = jrPlot.getValueDisplay()) != null && this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty(PROPERTY_DIAL_VALUE_DISPLAY_VISIBLE) : "false";
        if (Boolean.parseBoolean(displayVisibility)) {
            String pattern;
            DialValueIndicator dvi = new DialValueIndicator(0);
            dvi.setBackgroundPaint(TRANSPARENT_PAINT);
            dvi.setOutlinePaint(TRANSPARENT_PAINT);
            dvi.setPaint(Color.WHITE);
            String string2 = pattern = display.getMask() != null ? display.getMask() : "#,##0.####";
            if (pattern != null) {
                dvi.setNumberFormat(new DecimalFormat(pattern));
            }
            dvi.setRadius(0.15);
            dvi.setValueAnchor(RectangleAnchor.CENTER);
            dvi.setTextAnchor(TextAnchor.CENTER);
            dialPlot.addLayer(dvi);
        }
        String string3 = label = this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty(PROPERTY_DIAL_LABEL) : null;
        if (label != null) {
            JRFont displayFont = jrPlot.getValueDisplay().getFont();
            String[] textLines = label.split("\\n");
            for (int i = 0; i < textLines.length; ++i) {
                DialTextAnnotation dialAnnotation = new DialTextAnnotation(textLines[i]);
                if (displayFont != null) {
                    dialAnnotation.setFont(JRFontUtil.getAwtFont(displayFont, this.getLocale()));
                }
                dialAnnotation.setPaint(jrPlot.getValueDisplay().getColor());
                dialAnnotation.setRadius(Math.sin(0.7853981633974483) + (double)i / 10.0);
                dialAnnotation.setAnchor(TextAnchor.CENTER);
                dialPlot.addLayer(dialAnnotation);
            }
        }
        DialPointer.Pointer needle = new DialPointer.Pointer();
        needle.setVisible(true);
        needle.setRadius(0.91);
        dialPlot.addLayer(needle);
        DialCap cap = new DialCap();
        cap.setRadius(0.05);
        cap.setFillPaint(Color.DARK_GRAY);
        cap.setOutlinePaint(Color.GRAY);
        cap.setOutlineStroke(new BasicStroke(0.5f));
        dialPlot.setCap(cap);
        JFreeChart jfreeChart = new JFreeChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), null, dialPlot, this.isShowLegend());
        this.configureChart(jfreeChart);
        return jfreeChart;
    }

    protected AxisLocation getChartAxisLocation(JRChartAxis chartAxis) {
        return chartAxis.getPositionByte() != null && chartAxis.getPositionByte() == 2 ? AxisLocation.BOTTOM_OR_RIGHT : AxisLocation.TOP_OR_LEFT;
    }

    protected void setAxisBounds(Axis axis, boolean isRangeAxis, Comparable axisMinValue, Comparable axisMaxValue) {
        if (axis instanceof ValueAxis) {
            if (axis instanceof DateAxis) {
                if (axisMinValue != null) {
                    ((DateAxis)axis).setMinimumDate((Date)axisMinValue);
                }
                if (axisMaxValue != null) {
                    ((DateAxis)axis).setMaximumDate((Date)axisMaxValue);
                }
            } else {
                if (axisMinValue != null) {
                    ((ValueAxis)axis).setLowerBound(((Number)((Object)axisMinValue)).doubleValue());
                }
                if (axisMaxValue != null) {
                    ((ValueAxis)axis).setUpperBound(((Number)((Object)axisMaxValue)).doubleValue());
                }
            }
            this.calculateTickUnits(axis, isRangeAxis);
        }
    }

    protected void calculateTickUnits(Axis axis, boolean isRangeAxis) {
        NumberAxis numberAxis;
        int axisRange;
        Integer tickCount = null;
        Number tickInterval = null;
        if (this.getChart().hasProperties()) {
            String tickCountProperty = null;
            String tickIntervalProperty = null;
            if (isRangeAxis) {
                tickCountProperty = this.getChart().getPropertiesMap().getProperty(PROPERTY_RANGE_AXIS_TICK_COUNT);
                tickIntervalProperty = this.getChart().getPropertiesMap().getProperty(PROPERTY_RANGE_AXIS_TICK_INTERVAL);
            } else {
                tickCountProperty = this.getChart().getPropertiesMap().getProperty(PROPERTY_DOMAIN_AXIS_TICK_COUNT);
                tickIntervalProperty = this.getChart().getPropertiesMap().getProperty(PROPERTY_DOMAIN_AXIS_TICK_INTERVAL);
            }
            if (tickCountProperty != null && tickCountProperty.trim().length() > 0) {
                tickCount = Integer.valueOf(tickCountProperty);
            }
            if (tickIntervalProperty != null && tickIntervalProperty.trim().length() > 0) {
                tickInterval = Double.valueOf(tickIntervalProperty);
            }
        }
        if (tickInterval == null && tickCount == null) {
            return;
        }
        if (axis instanceof NumberAxis && (axisRange = (int)(numberAxis = (NumberAxis)axis).getRange().getLength()) > 0) {
            if (tickInterval != null) {
                if (numberAxis.getNumberFormatOverride() != null) {
                    numberAxis.setTickUnit(new NumberTickUnit(tickInterval.doubleValue(), numberAxis.getNumberFormatOverride()));
                } else {
                    numberAxis.setTickUnit(new NumberTickUnit(tickInterval.doubleValue()));
                }
            } else if (tickCount != null) {
                if (numberAxis.getNumberFormatOverride() != null) {
                    numberAxis.setTickUnit(new NumberTickUnit((double)(axisRange / tickCount), numberAxis.getNumberFormatOverride()));
                } else {
                    numberAxis.setTickUnit(new NumberTickUnit(axisRange / tickCount));
                }
            }
        }
    }

    private static RectangleEdge getEdge(Byte position, RectangleEdge defaultPosition) {
        RectangleEdge edge = defaultPosition;
        if (position != null) {
            switch (position) {
                case 1: {
                    edge = RectangleEdge.TOP;
                    break;
                }
                case 2: {
                    edge = RectangleEdge.BOTTOM;
                    break;
                }
                case 3: {
                    edge = RectangleEdge.LEFT;
                    break;
                }
                case 4: {
                    edge = RectangleEdge.RIGHT;
                }
            }
        }
        return edge;
    }

    protected boolean isShowLegend() {
        return this.getChart().getShowLegend() == null ? true : this.getChart().getShowLegend();
    }
}

