/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.xdg;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.StringTokenizer;

public class BaseDirs {
    private String[] mUserPaths;
    private String[][] mSystemPaths;

    public String getUserPath(Resource resource) {
        if (this.mUserPaths == null) {
            this.mUserPaths = new String[Resource.values().length];
        }
        if (this.mUserPaths[resource.ordinal()] == null) {
            this.cacheHomePath(resource);
        }
        return this.mUserPaths[resource.ordinal()];
    }

    public String[] getSystemPaths(Resource resource) {
        if (this.mSystemPaths == null) {
            this.mSystemPaths = new String[Resource.values().length][];
        }
        if (this.mSystemPaths[resource.ordinal()] == null) {
            this.cacheSystemPaths(resource);
        }
        return this.mSystemPaths[resource.ordinal()];
    }

    public File findResourceFile(Resource resource, String relPath) throws FileNotFoundException {
        String[] paths;
        File file = new File(this.getUserPath(resource), relPath);
        if (file.exists() && file.isFile()) {
            return file;
        }
        for (String path : paths = this.getSystemPaths(resource)) {
            file = new File(path, relPath);
            if (!file.exists() || !file.isFile()) continue;
            return file;
        }
        throw new FileNotFoundException();
    }

    public File findResourceDirectory(Resource resource, String relPath) throws FileNotFoundException {
        String[] paths;
        File file = new File(this.getUserPath(resource), relPath);
        if (file.exists() && file.isDirectory()) {
            return file;
        }
        for (String path : paths = this.getSystemPaths(resource)) {
            file = new File(path, relPath);
            if (!file.exists() || !file.isDirectory()) continue;
            return file;
        }
        throw new FileNotFoundException();
    }

    public File getSaveDirectory(Resource resource, String relPath) {
        File file = new File(this.getUserPath(resource), relPath);
        if (file.exists() ? !file.isDirectory() : !file.mkdirs()) {
            return null;
        }
        return file;
    }

    private void cacheHomePath(Resource resource) {
        File file;
        String property = System.getenv(resource.getUserPathProperty());
        if (property == null || property.length() == 0) {
            property = resource.getUserPathDefault();
        }
        if (!(file = new File(property)).isAbsolute()) {
            file = new File(System.getProperty("user.home"), property);
            this.mUserPaths[resource.ordinal()] = file.getAbsolutePath();
        } else {
            this.mUserPaths[resource.ordinal()] = property;
        }
    }

    private void cacheSystemPaths(Resource resource) {
        String property = System.getenv(resource.getSystemPathsProperty());
        if (property == null || property.length() == 0) {
            property = resource.getSystemPathsDefault();
        }
        StringTokenizer tokenizer = new StringTokenizer(property, ":");
        this.mSystemPaths[resource.ordinal()] = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            this.mSystemPaths[resource.ordinal()][i] = tokenizer.nextToken();
            ++i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("org.freedesktop.xdg.BaseDirs");
        sb.append("{mSystemPaths=").append(this.mSystemPaths == null ? "null" : Arrays.asList(this.mSystemPaths).toString());
        sb.append(", mUserPaths=").append(this.mUserPaths == null ? "null" : Arrays.asList(this.mUserPaths).toString());
        sb.append('}');
        return sb.toString();
    }

    public static enum Resource {
        CONFIG("XDG_CONFIG_HOME", ".config", "XDG_CONFIG_DIRS", "/etc/xdg"),
        DATA("XDG_DATA_HOME", ".local/share", "XDG_DATA_DIRS", "/usr/local/share:/usr/share");

        private final String mUserPathProperty;
        private final String mUserPathDefault;
        private final String mSystemPathsProperty;
        private final String mSystemPathsDefault;

        private Resource(String userPathProperty, String userPathDefault, String systemPathsProperty, String systemPathsDefault) {
            this.mUserPathProperty = userPathProperty;
            this.mUserPathDefault = userPathDefault;
            this.mSystemPathsProperty = systemPathsProperty;
            this.mSystemPathsDefault = systemPathsDefault;
        }

        public String getUserPathProperty() {
            return this.mUserPathProperty;
        }

        public String getUserPathDefault() {
            return this.mUserPathDefault;
        }

        public String getSystemPathsProperty() {
            return this.mSystemPathsProperty;
        }

        public String getSystemPathsDefault() {
            return this.mSystemPathsDefault;
        }
    }
}

