/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;

public class SSSaldoCalculator {
    private SSSaldoCalculator() {
    }

    private static void addValueToMap(Map<SSAccount, BigDecimal> iMap, SSAccount iAccount, BigDecimal iValue) {
        BigDecimal s = iMap.get(iAccount);
        if (s == null) {
            iMap.put(iAccount, iValue);
        } else {
            iMap.put(iAccount, s.add(iValue));
        }
    }

    public static Map<SSAccount, BigDecimal> getSaldo(SSNewAccountingYear pYearData, SSMonth pMonth) {
        List<SSVoucher> iVouchers = pYearData.getVouchers();
        HashMap<SSAccount, BigDecimal> iResult = new HashMap<SSAccount, BigDecimal>();
        for (SSVoucher iVoucher : iVouchers) {
            if (!SSVoucherMath.inPeriod(iVoucher, pMonth)) continue;
            for (SSVoucherRow iRow : iVoucher.getRows()) {
                SSAccount iRowAccount = iRow.getAccount();
                if (!iRow.isValid() || iRow.isCrossed()) continue;
                BigDecimal iRowSum = SSVoucherMath.getDebetMinusCredit(iRow);
                SSSaldoCalculator.addValueToMap(iResult, iRowAccount, iRowSum);
            }
        }
        return iResult;
    }

    public static Map<SSAccount, BigDecimal> getSaldo(SSNewAccountingYear pYearData, SSNewProject pProject, SSMonth pMonth) {
        List<SSVoucher> iVouchers = pYearData.getVouchers();
        HashMap<SSAccount, BigDecimal> iResult = new HashMap<SSAccount, BigDecimal>();
        for (SSVoucher iVoucher : iVouchers) {
            if (!SSVoucherMath.inPeriod(iVoucher, pMonth)) continue;
            for (SSVoucherRow iRow : iVoucher.getRows()) {
                SSAccount iRowAccount = iRow.getAccount();
                SSNewProject iRowProject = iRow.getProject();
                if (iRowProject == null || !iRow.isValid() || iRow.isCrossed() || !iRowProject.equals(pProject)) continue;
                BigDecimal iRowSum = SSVoucherMath.getDebetMinusCredit(iRow);
                SSSaldoCalculator.addValueToMap(iResult, iRowAccount, iRowSum);
            }
        }
        return iResult;
    }

    public static Map<SSAccount, BigDecimal> getSaldo(SSNewAccountingYear pYearData, SSNewResultUnit pResultUnit, SSMonth pMonth) {
        List<SSVoucher> iVouchers = pYearData.getVouchers();
        HashMap<SSAccount, BigDecimal> iResult = new HashMap<SSAccount, BigDecimal>();
        for (SSVoucher iVoucher : iVouchers) {
            if (!SSVoucherMath.inPeriod(iVoucher, pMonth)) continue;
            for (SSVoucherRow iRow : iVoucher.getRows()) {
                SSAccount iRowAccount = iRow.getAccount();
                SSNewResultUnit iRowResultUnit = iRow.getResultUnit();
                if (iRowResultUnit == null || !iRow.isValid() || iRow.isCrossed() || !iRowResultUnit.equals(pResultUnit)) continue;
                BigDecimal iRowSum = SSVoucherMath.getDebetMinusCredit(iRow);
                SSSaldoCalculator.addValueToMap(iResult, iRowAccount, iRowSum);
            }
        }
        return iResult;
    }

    public static Map<SSMonth, Map<SSAccount, BigDecimal>> getSaldo(SSNewAccountingYear pYearData) {
        List<SSMonth> iMonths = SSMonth.splitYearIntoMonths(pYearData);
        HashMap<SSMonth, Map<SSAccount, BigDecimal>> iResult = new HashMap<SSMonth, Map<SSAccount, BigDecimal>>();
        for (SSMonth iMonth : iMonths) {
            Map<SSAccount, BigDecimal> iSaldo = SSSaldoCalculator.getSaldo(pYearData, iMonth);
            iResult.put(iMonth, iSaldo);
        }
        return iResult;
    }

    public static Map<SSMonth, Map<SSAccount, BigDecimal>> getSaldo(SSNewAccountingYear pYearData, SSNewProject pProject) {
        List<SSMonth> iMonths = SSMonth.splitYearIntoMonths(pYearData);
        HashMap<SSMonth, Map<SSAccount, BigDecimal>> iResult = new HashMap<SSMonth, Map<SSAccount, BigDecimal>>();
        for (SSMonth iMonth : iMonths) {
            System.out.println(iMonth);
            Map<SSAccount, BigDecimal> iSaldo = SSSaldoCalculator.getSaldo(pYearData, pProject, iMonth);
            iResult.put(iMonth, iSaldo);
        }
        return iResult;
    }

    public static Map<SSMonth, Map<SSAccount, BigDecimal>> getSaldo(SSNewAccountingYear pYearData, SSNewResultUnit pResultUnit) {
        List<SSMonth> iMonths = SSMonth.splitYearIntoMonths(pYearData);
        HashMap<SSMonth, Map<SSAccount, BigDecimal>> iResult = new HashMap<SSMonth, Map<SSAccount, BigDecimal>>();
        for (SSMonth iMonth : iMonths) {
            System.out.println(iMonth);
            Map<SSAccount, BigDecimal> iSaldo = SSSaldoCalculator.getSaldo(pYearData, pResultUnit, iMonth);
            iResult.put(iMonth, iSaldo);
        }
        return iResult;
    }
}

