/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSCreditInvoiceMath
extends SSInvoiceMath {
    public static BigDecimal getSumForInvoice(SSInvoice iInvoice) {
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        BigDecimal iSum = new BigDecimal(0);
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            BigDecimal iRowSum = SSCreditInvoiceMath.getTotalSum(iCreditInvoice);
            if (iRowSum == null || !iCreditInvoice.isCrediting(iInvoice)) continue;
            iSum = iSum.add(iRowSum);
        }
        return iSum;
    }

    public static HashMap<Integer, BigDecimal> getSumsForInvoices() {
        HashMap<Integer, BigDecimal> iSums = new HashMap<Integer, BigDecimal>();
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            BigDecimal iRowSum = SSCreditInvoiceMath.getTotalSum(iCreditInvoice);
            if (iRowSum == null || iCreditInvoice.getCreditingNr() == null) continue;
            if (iSums.containsKey(iCreditInvoice.getCreditingNr())) {
                iSums.put(iCreditInvoice.getCreditingNr(), iSums.get(iCreditInvoice.getCreditingNr()).add(iRowSum));
                continue;
            }
            iSums.put(iCreditInvoice.getCreditingNr(), iRowSum);
        }
        return iSums;
    }

    public static HashMap<Integer, BigDecimal> getSumsForInvoices(Date iDate) {
        HashMap<Integer, BigDecimal> iSums = new HashMap<Integer, BigDecimal>();
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            BigDecimal iRowSum;
            if (!iCreditInvoice.getDate().before(iDate) || (iRowSum = SSCreditInvoiceMath.getTotalSum(iCreditInvoice)) == null || iCreditInvoice.getCreditingNr() == null) continue;
            if (iSums.containsKey(iCreditInvoice.getCreditingNr())) {
                iSums.put(iCreditInvoice.getCreditingNr(), iSums.get(iCreditInvoice.getCreditingNr()).add(iRowSum));
                continue;
            }
            iSums.put(iCreditInvoice.getCreditingNr(), iRowSum);
        }
        return iSums;
    }

    public static BigDecimal getSumForInvoice(SSInvoice iInvoice, Date iDate) {
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        iDate = SSDateMath.ceil(iDate);
        BigDecimal iSum = new BigDecimal(0);
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            Date iCurrent = SSDateMath.floor(iCreditInvoice.getDate());
            BigDecimal iRowSum = SSCreditInvoiceMath.getTotalSum(iCreditInvoice);
            if (iRowSum == null || !iCreditInvoice.isCrediting(iInvoice) || !iCurrent.before(iDate)) continue;
            iSum = iSum.add(iRowSum);
        }
        return iSum;
    }

    public static List<SSCreditInvoice> getCreditInvoicesForInvoice(SSInvoice iInvoice) {
        return SSCreditInvoiceMath.getCreditInvoicesForInvoice(SSDB.getInstance().getCreditInvoices(), iInvoice);
    }

    public static List<SSCreditInvoice> getCreditInvoicesForInvoice(List<SSCreditInvoice> iCreditInvoices, SSInvoice iInvoice) {
        LinkedList<SSCreditInvoice> iFiltered = new LinkedList<SSCreditInvoice>();
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            if (!iCreditInvoice.isCrediting(iInvoice)) continue;
            iFiltered.add(iCreditInvoice);
        }
        return iFiltered;
    }

    public static List<SSCreditInvoice> getCreditInvoicesForCustomer(SSCustomer iCustomer) {
        return SSCreditInvoiceMath.getCreditInvoicesForCustomer(SSDB.getInstance().getCreditInvoices(), iCustomer);
    }

    public static List<SSCreditInvoice> getCreditInvoicesForCustomer(List<SSCreditInvoice> iCreditInvoices, SSCustomer iCustomer) {
        LinkedList<SSCreditInvoice> iFiltered = new LinkedList<SSCreditInvoice>();
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            if (!iCreditInvoice.hasCustomer(iCustomer)) continue;
            iFiltered.add(iCreditInvoice);
        }
        return iFiltered;
    }

    public static Map<String, List<SSCreditInvoice>> getCreditInvoicesforCustomers() {
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        HashMap<String, List<SSCreditInvoice>> iMap = new HashMap<String, List<SSCreditInvoice>>();
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            if (iCreditInvoice.getCustomerNr() == null) continue;
            if (iMap.containsKey(iCreditInvoice.getCustomerNr())) {
                ((List)iMap.get(iCreditInvoice.getCustomerNr())).add(iCreditInvoice);
                continue;
            }
            LinkedList<SSCreditInvoice> iTemp = new LinkedList<SSCreditInvoice>();
            iTemp.add(iCreditInvoice);
            iMap.put(iCreditInvoice.getCustomerNr(), iTemp);
        }
        return iMap;
    }
}

