/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSCustomerMath {
    public static HashMap<String, List<SSInvoice>> iInvoicesForCustomers;

    private SSCustomerMath() {
    }

    public static BigDecimal getCustomerClain(SSCustomer iCustomer) {
        List<SSInvoice> iInvoices = SSInvoiceMath.getInvoicesForCustomer(iCustomer);
        BigDecimal iCustomerClaim = new BigDecimal(0);
        for (SSInvoice iInvoice : iInvoices) {
            BigDecimal iSaldo = SSInvoiceMath.getSaldo(iInvoice.getNumber());
            iSaldo = SSInvoiceMath.convertToLocal(iInvoice, iSaldo);
            iCustomerClaim = iCustomerClaim.add(iSaldo);
        }
        return iCustomerClaim;
    }

    public static void getInvoicesForCustomers() {
        if (iInvoicesForCustomers == null) {
            iInvoicesForCustomers = new HashMap();
        }
        List<SSCustomer> iCustomers = SSDB.getInstance().getCustomers();
        for (SSCustomer iCustomer : iCustomers) {
            List<SSInvoice> iInvoices = SSInvoiceMath.getInvoicesForCustomer(iCustomer);
            LinkedList<SSInvoice> iInvoiceNumbers = new LinkedList<SSInvoice>();
            for (SSInvoice iInvoice : iInvoices) {
                iInvoiceNumbers.add(iInvoice);
            }
            iInvoicesForCustomers.put(iCustomer.getNumber(), iInvoiceNumbers);
        }
    }
}

