/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.data.SSIndelivery;
import se.swedsoft.bookkeeping.data.SSIndeliveryRow;
import se.swedsoft.bookkeeping.data.SSProduct;

public class SSIndeliveryMath {
    private SSIndeliveryMath() {
    }

    public static boolean inPeriod(SSIndelivery iInventory, Date pTo) {
        Date iDate = iInventory.getDate();
        Date iTo = SSDateMath.ceil(pTo);
        return iDate.getTime() <= iTo.getTime();
    }

    public static boolean inPeriod(SSIndelivery iInventory, Date pFrom, Date pTo) {
        Date iDate = iInventory.getDate();
        Date iFrom = SSDateMath.floor(pFrom);
        Date iTo = SSDateMath.ceil(pTo);
        return iFrom.getTime() <= iDate.getTime() && iDate.getTime() <= iTo.getTime();
    }

    public static Integer getTotalCount(SSIndelivery iIndelivery) {
        Integer iCount = 0;
        for (SSIndeliveryRow iRow : iIndelivery.getRows()) {
            if (iRow.getChange() == null) continue;
            iCount = iCount + iRow.getChange();
        }
        return iCount;
    }

    public static boolean hasProduct(SSIndelivery iIndelivery, SSProduct iProduct) {
        for (SSIndeliveryRow iRow : iIndelivery.getRows()) {
            if (!iRow.hasProduct(iProduct)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Integer> getStockInfluencing(List<SSIndelivery> iIndeliveries) {
        HashMap<String, Integer> iIndeliveryCount = new HashMap<String, Integer>();
        for (SSIndelivery iIndelivery : iIndeliveries) {
            for (SSIndeliveryRow iRow : iIndelivery.getRows()) {
                if (iRow.getChange() == null) continue;
                Integer iReserved = iIndeliveryCount.get(iRow.getProductNr()) == null ? iRow.getChange() : (Integer)iIndeliveryCount.get(iRow.getProductNr()) + iRow.getChange();
                iIndeliveryCount.put(iRow.getProductNr(), iReserved);
            }
        }
        return iIndeliveryCount;
    }
}

