/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSInpaymentMath;
import se.swedsoft.bookkeeping.calc.math.SSSaleMath;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProductRow;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSInvoiceType;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSInvoiceMath
extends SSSaleMath {
    public static HashMap<Integer, BigDecimal> iSaldoMap;

    public static boolean expired(SSInvoice iInvoice) {
        Date iNow = new Date();
        Date iPaymentDay = iInvoice.getDueDate();
        iNow = SSDateMath.ceil(iNow);
        iPaymentDay = SSDateMath.floor(iPaymentDay);
        return iNow.after(iPaymentDay);
    }

    public static BigDecimal convertToLocal(SSInvoice iInvoice, BigDecimal iValue) {
        BigDecimal iCurrencyRate = iInvoice.getCurrencyRate();
        if (iCurrencyRate != null) {
            iValue = iValue.multiply(iCurrencyRate);
        }
        return iValue;
    }

    public static BigDecimal convertToLocal(Integer iInvoiceNr, BigDecimal iValue) {
        SSInvoice iInvoice = new SSInvoice();
        iInvoice.setNumber(iInvoiceNr);
        iInvoice = SSDB.getInstance().getInvoice(iInvoice);
        BigDecimal iCurrencyRate = iInvoice.getCurrencyRate();
        if (iCurrencyRate != null) {
            iValue = iValue.multiply(iCurrencyRate);
        }
        return iValue;
    }

    public static BigDecimal getSaldo(SSInvoice iInvoice) {
        if (iInvoice.getType() == SSInvoiceType.CASH) {
            return new BigDecimal(0);
        }
        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(iInvoice);
        BigDecimal iCreditingSum = SSCreditInvoiceMath.getSumForInvoice(iInvoice);
        BigDecimal iInpaymentSum = SSInpaymentMath.getSumForInvoice(iInvoice);
        iTotalSum = iTotalSum.subtract(iCreditingSum);
        iTotalSum = iTotalSum.subtract(iInpaymentSum);
        return iTotalSum.setScale(2, RoundingMode.HALF_UP);
    }

    public static BigDecimal getSaldo(Integer iInvoiceNumber) {
        if (iSaldoMap.containsKey(iInvoiceNumber)) {
            return iSaldoMap.get(iInvoiceNumber);
        }
        return new BigDecimal(0);
    }

    public static void calculateSaldos() {
        if (iSaldoMap == null) {
            iSaldoMap = new HashMap();
        }
        HashMap<Integer, BigDecimal> iInpaymentSum = SSInpaymentMath.getSumsForInvoices();
        HashMap<Integer, BigDecimal> iCreditInvoiceSum = SSCreditInvoiceMath.getSumsForInvoices();
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        for (SSInvoice iInvoice : iInvoices) {
            if (iInvoice.getType() == SSInvoiceType.CASH) continue;
            BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(iInvoice);
            if (iInpaymentSum.containsKey(iInvoice.getNumber())) {
                iTotalSum = iTotalSum.subtract(iInpaymentSum.get(iInvoice.getNumber()));
            }
            if (iCreditInvoiceSum.containsKey(iInvoice.getNumber())) {
                iTotalSum = iTotalSum.subtract(iCreditInvoiceSum.get(iInvoice.getNumber()));
            }
            iSaldoMap.put(iInvoice.getNumber(), iTotalSum);
        }
    }

    public static Map<Integer, BigDecimal> getSaldos(Date iDate) {
        HashMap<Integer, BigDecimal> iSaldos = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> iInpaymentSum = SSInpaymentMath.getSumsForInvoices(iDate);
        HashMap<Integer, BigDecimal> iCreditInvoiceSum = SSCreditInvoiceMath.getSumsForInvoices(iDate);
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        for (SSInvoice iInvoice : iInvoices) {
            if (iInvoice.getType() == SSInvoiceType.CASH) continue;
            BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(iInvoice);
            if (iInpaymentSum.containsKey(iInvoice.getNumber())) {
                iTotalSum = iTotalSum.subtract(iInpaymentSum.get(iInvoice.getNumber()));
            }
            if (iCreditInvoiceSum.containsKey(iInvoice.getNumber())) {
                iTotalSum = iTotalSum.subtract(iCreditInvoiceSum.get(iInvoice.getNumber()));
            }
            iSaldos.put(iInvoice.getNumber(), iTotalSum);
        }
        return iSaldos;
    }

    public static BigDecimal getSaldo(SSInvoice iInvoice, Date iDate) {
        if (iInvoice.getType() == SSInvoiceType.CASH) {
            return new BigDecimal(0);
        }
        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(iInvoice);
        BigDecimal iCreditingSum = SSCreditInvoiceMath.getSumForInvoice(iInvoice, iDate);
        BigDecimal iInpaymentSum = SSInpaymentMath.getSumForInvoice(iInvoice, iDate);
        iTotalSum = iTotalSum.subtract(iCreditingSum);
        iTotalSum = iTotalSum.subtract(iInpaymentSum);
        return iTotalSum.setScale(2, RoundingMode.HALF_UP);
    }

    public static Map<SSInvoice, BigDecimal> getSaldo(List<SSInvoice> iInvoices, Date iDate) {
        HashMap<SSInvoice, BigDecimal> iSaldos = new HashMap<SSInvoice, BigDecimal>();
        iDate = SSDateMath.ceil(iDate);
        HashMap<Integer, BigDecimal> iInpaymentSum = SSInpaymentMath.getSumsForInvoices(iDate);
        HashMap<Integer, BigDecimal> iCreditInvoiceSum = SSCreditInvoiceMath.getSumsForInvoices(iDate);
        for (SSInvoice iInvoice : iInvoices) {
            Date iCurrent = iInvoice.getDate();
            if (!iCurrent.before(iDate) || iInvoice.getType() == SSInvoiceType.CASH) continue;
            BigDecimal iSum = SSInvoiceMath.getTotalSum(iInvoice);
            if (iInpaymentSum.containsKey(iInvoice.getNumber())) {
                iSum = iSum.subtract(iInpaymentSum.get(iInvoice.getNumber()));
            }
            if (iCreditInvoiceSum.containsKey(iInvoice.getNumber())) {
                iSum = iSum.subtract(iCreditInvoiceSum.get(iInvoice.getNumber()));
            }
            iSaldos.put(iInvoice, iSum.setScale(2, RoundingMode.HALF_UP));
        }
        return iSaldos;
    }

    public static BigDecimal getSaldoSum(List<SSInvoice> iInvoices, Date iDate) {
        Map<SSInvoice, BigDecimal> iSaldos = SSInvoiceMath.getSaldo(iInvoices, iDate);
        BigDecimal iSum = new BigDecimal(0);
        for (SSInvoice iInvoice : iInvoices) {
            iSum = iSum.add(iSaldos.get(iInvoice));
        }
        return iSum;
    }

    public static BigDecimal getSumMinusCredited(SSInvoice iInvoice, Date iDate) {
        if (iInvoice.getType() == SSInvoiceType.CASH) {
            return new BigDecimal(0);
        }
        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(iInvoice);
        BigDecimal iCreditingSum = SSCreditInvoiceMath.getSumForInvoice(iInvoice, iDate);
        iTotalSum = iTotalSum.subtract(iCreditingSum);
        return iTotalSum;
    }

    public static List<SSOrder> getOrdersForInvoice(SSInvoice iInvoice) {
        return SSInvoiceMath.getOrdersForInvoice(SSDB.getInstance().getOrders(), iInvoice);
    }

    public static List<SSOrder> getOrdersForInvoice(List<SSOrder> iOrders, SSInvoice iInvoice) {
        LinkedList<SSOrder> iFiltered = new LinkedList<SSOrder>();
        for (SSOrder iOrder : iOrders) {
            if (!iOrder.hasInvoice(iInvoice)) continue;
            iFiltered.add(iOrder);
        }
        return iFiltered;
    }

    public static List<SSInvoice> getInvoicesForCustomer(SSCustomer iCustomer) {
        return SSInvoiceMath.getInvoicesForCustomer(SSDB.getInstance().getInvoices(), iCustomer);
    }

    public static List<SSInvoice> getInvoicesForCustomer(List<SSInvoice> iInvoices, SSCustomer iCustomer) {
        LinkedList<SSInvoice> iFiltered = new LinkedList<SSInvoice>();
        for (SSInvoice iInvoice : iInvoices) {
            if (!iInvoice.hasCustomer(iCustomer)) continue;
            iFiltered.add(iInvoice);
        }
        return iFiltered;
    }

    public static Map<String, List<SSInvoice>> getInvoicesforCustomers() {
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        HashMap<String, List<SSInvoice>> iMap = new HashMap<String, List<SSInvoice>>();
        for (SSInvoice iInvoice : iInvoices) {
            if (iInvoice.getCustomerNr() == null) continue;
            if (iMap.containsKey(iInvoice.getCustomerNr())) {
                ((List)iMap.get(iInvoice.getCustomerNr())).add(iInvoice);
                continue;
            }
            LinkedList<SSInvoice> iTemp = new LinkedList<SSInvoice>();
            iTemp.add(iInvoice);
            iMap.put(iInvoice.getCustomerNr(), iTemp);
        }
        return iMap;
    }

    public static List<SSInvoice> getInvoicesForCustomer(SSCustomer iCustomer, Date iDate) {
        return SSInvoiceMath.getInvoicesForCustomer(SSDB.getInstance().getInvoices(), iCustomer, iDate);
    }

    public static List<SSInvoice> getInvoicesForCustomer(List<SSInvoice> iInvoices, SSCustomer iCustomer, Date iDate) {
        LinkedList<SSInvoice> iFiltered = new LinkedList<SSInvoice>();
        for (SSInvoice iInvoice : iInvoices) {
            if (!iInvoice.hasCustomer(iCustomer) || !SSInvoiceMath.inPeriod(iInvoice, iDate)) continue;
            iFiltered.add(iInvoice);
        }
        return iFiltered;
    }

    public static List<SSInvoice> getPayedOrCreditedInvoices() {
        return SSInvoiceMath.getPayedOrCreditedInvoices(SSDB.getInstance().getInvoices());
    }

    public static List<SSInvoice> getPayedOrCreditedInvoices(List<SSInvoice> iInvoices) {
        LinkedList<SSInvoice> iFiltered = new LinkedList<SSInvoice>();
        for (SSInvoice iInvoice : iInvoices) {
            BigDecimal iSaldo = SSInvoiceMath.getSaldo(iInvoice.getNumber());
            if (iSaldo.signum() != 0) continue;
            iFiltered.add(iInvoice);
        }
        return iFiltered;
    }

    public static List<SSInvoice> getNonPayedOrCreditedInvoices() {
        return SSInvoiceMath.getNonPayedOrCreditedInvoices(SSDB.getInstance().getInvoices());
    }

    public static List<SSInvoice> getNonPayedOrCreditedInvoices(List<SSInvoice> iInvoices) {
        LinkedList<SSInvoice> iFiltered = new LinkedList<SSInvoice>();
        for (SSInvoice iInvoice : iInvoices) {
            BigDecimal iSaldo = SSInvoiceMath.getSaldo(iInvoice.getNumber());
            if (iSaldo.signum() == 0) continue;
            iFiltered.add(iInvoice);
        }
        return iFiltered;
    }

    public static int getNumDelayedDays(SSInvoice iInvoice) {
        Date iPaymentDay = iInvoice.getDueDate();
        Date iLastPayment = SSInpaymentMath.getLastInpaymentForInvoice(iInvoice);
        if (iLastPayment == null || iPaymentDay == null) {
            return 0;
        }
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTimeInMillis(iLastPayment.getTime() - iPaymentDay.getTime());
        int iYear = iCalendar.get(1) - 1970;
        int iDay = iCalendar.get(6);
        return iYear * iCalendar.getActualMaximum(6) + iDay;
    }

    public static BigDecimal getInterestSaldo(SSInvoice iInvoice) {
        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(iInvoice);
        BigDecimal iCredited = SSCreditInvoiceMath.getSumForInvoice(iInvoice);
        return iTotalSum.subtract(iCredited);
    }

    public static BigDecimal getInterestSum(SSInvoice iInvoice, BigDecimal iSaldo, int iNumDays) {
        BigDecimal iInterest = iInvoice.getDelayInterest();
        BigDecimal iNormalisedInterest = iInterest.scaleByPowerOfTen(-2);
        BigDecimal iDay = new BigDecimal(iNumDays).divide(new BigDecimal(365), 16, RoundingMode.HALF_UP);
        return iSaldo.multiply(iNormalisedInterest).multiply(iDay);
    }

    public static SSInvoice getInvoiceByReference(String iReferensNumber) {
        return SSInvoiceMath.getInvoiceByReference(SSDB.getInstance().getInvoices(), iReferensNumber);
    }

    public static SSInvoice getInvoiceByReference(List<SSInvoice> iInvoices, String iReferensNumber) {
        for (SSInvoice iInvoice : iInvoices) {
            String iNumber = iInvoice.getNumber().toString();
            String iOCRNumber = iInvoice.getOCRNumber();
            if (!iReferensNumber.equals(iOCRNumber) && !iReferensNumber.equals(iNumber)) continue;
            return iInvoice;
        }
        return null;
    }

    public static Map<String, Integer> getStockInfluencing(List<? extends SSInvoice> iInvoices) {
        HashMap<String, Integer> iInvoiceCount = new HashMap<String, Integer>();
        LinkedList<String> iParcelProducts = new LinkedList<String>();
        LinkedList<SSProduct> iProducts = new LinkedList<SSProduct>(SSDB.getInstance().getProducts());
        for (SSProduct sSProduct : iProducts) {
            if (!sSProduct.isParcel() || sSProduct.getNumber() == null) continue;
            iParcelProducts.add(sSProduct.getNumber());
        }
        for (SSInvoice sSInvoice : iInvoices) {
            for (SSSaleRow iRow : sSInvoice.getRows()) {
                Integer iReserved;
                if (iRow.getQuantity() == null) continue;
                if (iParcelProducts.contains(iRow.getProductNr())) {
                    SSProduct iProduct = iRow.getProduct();
                    if (iProduct == null) continue;
                    for (SSProductRow iProductRow : iProduct.getParcelRows()) {
                        iReserved = iInvoiceCount.get(iProductRow.getProductNr()) == null ? iProductRow.getQuantity() * iRow.getQuantity() : (Integer)iInvoiceCount.get(iProductRow.getProductNr()) + iProductRow.getQuantity() * iRow.getQuantity();
                        iInvoiceCount.put(iProductRow.getProductNr(), iReserved);
                    }
                    continue;
                }
                iReserved = iInvoiceCount.get(iRow.getProductNr()) == null ? iRow.getQuantity() : (Integer)iInvoiceCount.get(iRow.getProductNr()) + iRow.getQuantity();
                iInvoiceCount.put(iRow.getProductNr(), iReserved);
            }
        }
        return iInvoiceCount;
    }
}

