/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.data.SSOutdelivery;
import se.swedsoft.bookkeeping.data.SSOutdeliveryRow;
import se.swedsoft.bookkeeping.data.SSProduct;

public class SSOutdeliveryMath {
    private SSOutdeliveryMath() {
    }

    public static boolean inPeriod(SSOutdelivery iInventory, Date pTo) {
        Date iDate = iInventory.getDate();
        Date iTo = SSDateMath.ceil(pTo);
        return iDate.getTime() <= iTo.getTime();
    }

    public static boolean inPeriod(SSOutdelivery iInventory, Date pFrom, Date pTo) {
        Date iDate = iInventory.getDate();
        Date iFrom = SSDateMath.floor(pFrom);
        Date iTo = SSDateMath.ceil(pTo);
        return iFrom.getTime() <= iDate.getTime() && iDate.getTime() <= iTo.getTime();
    }

    public static Integer getTotalCount(SSOutdelivery iOutdelivery) {
        Integer iCount = 0;
        for (SSOutdeliveryRow iRow : iOutdelivery.getRows()) {
            if (iRow.getChange() == null) continue;
            iCount = iCount + iRow.getChange();
        }
        return iCount;
    }

    public static boolean hasProduct(SSOutdelivery iOutdelivery, SSProduct iProduct) {
        for (SSOutdeliveryRow iRow : iOutdelivery.getRows()) {
            if (!iRow.hasProduct(iProduct)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Integer> getStockInfluencing(List<SSOutdelivery> iOutdeliveries) {
        HashMap<String, Integer> iOutdeliveryCount = new HashMap<String, Integer>();
        for (SSOutdelivery iOutdelivery : iOutdeliveries) {
            for (SSOutdeliveryRow iRow : iOutdelivery.getRows()) {
                if (iRow.getChange() == null) continue;
                Integer iReserved = iOutdeliveryCount.get(iRow.getProductNr()) == null ? iRow.getChange() : (Integer)iOutdeliveryCount.get(iRow.getProductNr()) + iRow.getChange();
                iOutdeliveryCount.put(iRow.getProductNr(), iReserved);
            }
        }
        return iOutdeliveryCount;
    }
}

