/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.data.SSOutpayment;
import se.swedsoft.bookkeeping.data.SSOutpaymentRow;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSOutpaymentMath {
    private SSOutpaymentMath() {
    }

    public static boolean inPeriod(SSOutpayment iOutpayment, Date pFrom, Date pTo) {
        Date iDate = iOutpayment.getDate();
        Date iFrom = SSDateMath.floor(pFrom);
        Date iTo = SSDateMath.ceil(pTo);
        return iFrom.getTime() <= iDate.getTime() && iDate.getTime() <= iTo.getTime();
    }

    public static BigDecimal convertToLocal(SSOutpaymentRow iRow, BigDecimal iValue) {
        BigDecimal iCurrencyRate = iRow.getCurrencyRate();
        if (iCurrencyRate != null) {
            iValue = iValue.multiply(iCurrencyRate);
        }
        return iValue;
    }

    public static BigDecimal getSum(SSOutpayment iOutpayment) {
        BigDecimal iSum = new BigDecimal(0);
        for (SSOutpaymentRow iRow : iOutpayment.getRows()) {
            BigDecimal iValue = iRow.getValue();
            if (iValue == null) continue;
            iValue = SSOutpaymentMath.convertToLocal(iRow, iValue);
            iSum = iSum.add(iValue);
        }
        return iSum;
    }

    public static BigDecimal getCurrencyRateDifference(SSOutpaymentRow iOutpaymentRow) {
        BigDecimal iPaymentRate = iOutpaymentRow.getCurrencyRate();
        BigDecimal iCurrencyRate = iOutpaymentRow.getInvoiceCurrencyRate();
        BigDecimal iValue = iOutpaymentRow.getValue();
        if (iPaymentRate == null || iCurrencyRate == null || iValue == null) {
            return null;
        }
        return iValue.multiply(iCurrencyRate.subtract(iPaymentRate));
    }

    public static BigDecimal getCurrencyRateDifference(SSOutpayment iOutpayment) {
        BigDecimal iSum = new BigDecimal(0);
        for (SSOutpaymentRow iRow : iOutpayment.getRows()) {
            BigDecimal iRowSum = SSOutpaymentMath.getCurrencyRateDifference(iRow);
            if (iRowSum == null) continue;
            iSum = iSum.add(iRowSum);
        }
        return iSum;
    }

    public static BigDecimal getSumForInvoice(SSOutpayment iOutpayment, SSSupplierInvoice iInvoice) {
        BigDecimal iSum = new BigDecimal(0);
        for (SSOutpaymentRow iRow : iOutpayment.getRows()) {
            BigDecimal iRowValue = iRow.getValue();
            if (iRowValue == null || !iRow.isPaying(iInvoice)) continue;
            iSum = iSum.add(iRowValue);
        }
        return iSum;
    }

    public static BigDecimal getSumForInvoice(SSSupplierInvoice iInvoice) {
        List<SSOutpayment> iOutpayments = SSDB.getInstance().getOutpayments();
        BigDecimal iSum = new BigDecimal(0);
        for (SSOutpayment iOutpayment : iOutpayments) {
            BigDecimal iRowSum = SSOutpaymentMath.getSumForInvoice(iOutpayment, iInvoice);
            iSum = iSum.add(iRowSum);
        }
        return iSum;
    }

    public static HashMap<Integer, BigDecimal> getSumsForSupplierInvoices() {
        HashMap<Integer, BigDecimal> iSums = new HashMap<Integer, BigDecimal>();
        List<SSOutpayment> iOutpayments = SSDB.getInstance().getOutpayments();
        for (SSOutpayment iOutpayment : iOutpayments) {
            for (SSOutpaymentRow iRow : iOutpayment.getRows()) {
                if (iRow.getValue() == null) continue;
                if (iSums.containsKey(iRow.getInvoiceNr())) {
                    iSums.put(iRow.getInvoiceNr(), iSums.get(iRow.getInvoiceNr()).add(iRow.getValue()));
                    continue;
                }
                iSums.put(iRow.getInvoiceNr(), iRow.getValue());
            }
        }
        return iSums;
    }

    public static HashMap<Integer, BigDecimal> getSumsForSupplierInvoices(Date iDate) {
        HashMap<Integer, BigDecimal> iSums = new HashMap<Integer, BigDecimal>();
        List<SSOutpayment> iOutpayments = SSDB.getInstance().getOutpayments();
        for (SSOutpayment iOutpayment : iOutpayments) {
            if (!iOutpayment.getDate().before(iDate)) continue;
            for (SSOutpaymentRow iRow : iOutpayment.getRows()) {
                if (iRow.getValue() == null) continue;
                if (iSums.containsKey(iRow.getInvoiceNr())) {
                    iSums.put(iRow.getInvoiceNr(), iSums.get(iRow.getInvoiceNr()).add(iRow.getValue()));
                    continue;
                }
                iSums.put(iRow.getInvoiceNr(), iRow.getValue());
            }
        }
        return iSums;
    }

    public static BigDecimal getSumForInvoice(SSSupplierInvoice iInvoice, Date iDate) {
        List<SSOutpayment> iOutpayments = SSDB.getInstance().getOutpayments();
        iDate = SSDateMath.ceil(iDate);
        BigDecimal iSum = new BigDecimal(0);
        for (SSOutpayment iOutpayment : iOutpayments) {
            Date iCurrent = SSDateMath.floor(iOutpayment.getDate());
            BigDecimal iRowSum = SSOutpaymentMath.getSumForInvoice(iOutpayment, iInvoice);
            if (!iCurrent.before(iDate)) continue;
            iSum = iSum.add(iRowSum);
        }
        return iSum;
    }

    public static boolean hasInvoice(SSOutpayment iOutpayment, SSSupplierInvoice iInvoice) {
        for (SSOutpaymentRow iRow : iOutpayment.getRows()) {
            if (!iRow.isPaying(iInvoice)) continue;
            return true;
        }
        return false;
    }
}

