/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProductRow;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoiceRow;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSProductMath {
    private SSProductMath() {
    }

    public static SSProduct getProduct(List<SSProduct> iProducts, String iProductNr) {
        for (SSProduct iCurrent : iProducts) {
            String iNumber = iCurrent.getNumber();
            if (iNumber == null || !iNumber.equals(iProductNr)) continue;
            return iCurrent;
        }
        return null;
    }

    public static List<SSProduct> getNormalProducts() {
        List<SSProduct> iProducts = SSDB.getInstance().getProducts();
        LinkedList<SSProduct> iFiltered = new LinkedList<SSProduct>();
        for (SSProduct iProduct : iProducts) {
            if (iProduct.isParcel()) continue;
            iFiltered.add(iProduct);
        }
        return iFiltered;
    }

    public static BigDecimal getLastPurchasePrice(SSProduct iProduct, Date iDate) {
        LinkedList<SSSupplierInvoice> iSupplierInvoices = new LinkedList<SSSupplierInvoice>(SSDB.getInstance().getSupplierInvoices());
        Collections.sort(iSupplierInvoices, new Comparator<SSSupplierInvoice>(){

            @Override
            public int compare(SSSupplierInvoice o1, SSSupplierInvoice o2) {
                return o2.getDate().compareTo(o1.getDate());
            }
        });
        for (SSSupplierInvoice iSupplierInvoice : iSupplierInvoices) {
            List<SSSupplierInvoiceRow> iRows = iSupplierInvoice.getRows();
            for (SSSupplierInvoiceRow iRow : iRows) {
                if (!iRow.hasProduct(iProduct)) continue;
                return iRow.getUnitprice();
            }
        }
        return iProduct.getPurchasePrice();
    }

    public static List<SSProduct> getStockProducts(List<SSProduct> iProducts) {
        LinkedList<SSProduct> iFiltered = new LinkedList<SSProduct>();
        for (SSProduct iProduct : iProducts) {
            if (iProduct.isParcel() || !iProduct.isStockProduct()) continue;
            iFiltered.add(iProduct);
        }
        return iFiltered;
    }

    public static Integer getProductCount(SSProduct iParcel, SSProduct iProduct) {
        Integer iCount = 0;
        for (SSProductRow iRow : iParcel.getParcelRows()) {
            Integer iQuantity;
            if (!iRow.hasProduct(iProduct) || (iQuantity = iRow.getQuantity()) == null) continue;
            iCount = iCount + iQuantity;
        }
        return iCount;
    }

    public static Map<SSProduct, BigDecimal> getInprices(List<SSProduct> iProducts) {
        HashMap<SSProduct, BigDecimal> IInprices = new HashMap<SSProduct, BigDecimal>();
        for (SSProduct iProduct : iProducts) {
            IInprices.put(iProduct, SSProductMath.getInprice(iProduct));
        }
        return IInprices;
    }

    public static Map<SSProduct, BigDecimal> getInprices(List<SSProduct> iProducts, Date iDate) {
        HashMap<SSProduct, BigDecimal> IInprices = new HashMap<SSProduct, BigDecimal>();
        for (SSProduct iProduct : iProducts) {
            IInprices.put(iProduct, SSProductMath.getInprice(iProduct, iDate));
        }
        return IInprices;
    }

    public static BigDecimal getInprice(SSProduct iProduct) {
        return SSProductMath.getInprice(iProduct, null);
    }

    public static BigDecimal getInprice(SSProduct iProduct, Date iDate) {
        if (iProduct.isParcel()) {
            BigDecimal iInpriceSum = new BigDecimal(0);
            for (SSProductRow iRow : iProduct.getParcelRows()) {
                SSProduct iRowProduct = iRow.getProduct();
                if (iProduct.equals(iRowProduct)) continue;
                Integer iQuantity = iRow.getQuantity();
                if (iRowProduct == null || iQuantity == null) continue;
                BigDecimal iInprice = SSProductMath.getInprice(iRowProduct, iDate);
                if (iInprice == null) {
                    return null;
                }
                iInpriceSum = iInpriceSum.add(iInprice.multiply(new BigDecimal(iQuantity)));
            }
            return iInpriceSum;
        }
        List<SSSupplierInvoice> iSupplierInvoices = SSDB.getInstance().getSupplierInvoices();
        LinkedList<SSSupplierInvoice> iFiltered = new LinkedList<SSSupplierInvoice>(iSupplierInvoices);
        Collections.sort(iFiltered, new Comparator<SSSupplierInvoice>(){

            @Override
            public int compare(SSSupplierInvoice o1, SSSupplierInvoice o2) {
                return o2.getDate().compareTo(o1.getDate());
            }
        });
        for (SSSupplierInvoice iSupplierInvoice : iFiltered) {
            if (iDate != null && !SSSupplierInvoiceMath.inPeriod(iSupplierInvoice, iDate)) continue;
            List<SSSupplierInvoiceRow> iRows = iSupplierInvoice.getRows();
            for (SSSupplierInvoiceRow iRow : iRows) {
                if (!iRow.hasProduct(iProduct)) continue;
                BigDecimal iUnitPrice = iRow.getUnitprice();
                BigDecimal iUnitFreight = iRow.getUnitFreight();
                if (iUnitPrice == null) continue;
                BigDecimal iValue = iUnitFreight != null ? iUnitPrice.add(iUnitFreight) : iUnitPrice;
                BigDecimal iLocalValue = SSSupplierInvoiceMath.convertToLocal(iSupplierInvoice, iValue);
                return iLocalValue == null ? iProduct.getStockPrice() : iLocalValue;
            }
        }
        return iProduct.getStockPrice();
    }

    public static BigDecimal getContribution(SSProduct iProduct) {
        BigDecimal iInprice = SSProductMath.getInprice(iProduct);
        if (iInprice == null || iProduct.getSellingPrice() == null) {
            return null;
        }
        return iProduct.getSellingPrice().subtract(iInprice);
    }

    public static BigDecimal getContribution(SSProduct iProduct, Date iDate) {
        BigDecimal iInprice = SSProductMath.getInprice(iProduct, iDate);
        if (iInprice == null || iProduct.getSellingPrice() == null) {
            return null;
        }
        return iProduct.getSellingPrice().subtract(iInprice);
    }

    public static BigDecimal getContributionRate(SSProduct iProduct) {
        BigDecimal iContribution = SSProductMath.getContribution(iProduct);
        BigDecimal iSellingPrice = iProduct.getSellingPrice();
        if (iContribution == null || iSellingPrice == null) {
            return null;
        }
        if (iSellingPrice.signum() == 0) {
            return null;
        }
        return iContribution.divide(iSellingPrice, 20, RoundingMode.HALF_UP).scaleByPowerOfTen(2);
    }

    public static BigDecimal getContributionRate(SSProduct iProduct, Date iDate) {
        BigDecimal iContribution = SSProductMath.getContribution(iProduct, iDate);
        BigDecimal iSellingPrice = iProduct.getSellingPrice();
        if (iContribution == null || iSellingPrice == null) {
            return null;
        }
        if (iSellingPrice.signum() == 0) {
            return null;
        }
        return iContribution.divide(iSellingPrice, 20, RoundingMode.HALF_UP).scaleByPowerOfTen(2);
    }

    public static BigDecimal getContributionRate(SSProduct iProduct, Date iDate, BigDecimal iContribution) {
        BigDecimal iSellingPrice = iProduct.getSellingPrice();
        if (iContribution == null || iSellingPrice == null) {
            return null;
        }
        if (iSellingPrice.signum() == 0) {
            return null;
        }
        return iContribution.divide(iSellingPrice, 20, RoundingMode.HALF_UP).scaleByPowerOfTen(2);
    }

    public static Integer getSaleCount(SSProduct iProduct) {
        return SSProductMath.getSaleCount(iProduct, null, null);
    }

    public static Integer getSaleCount(SSProduct iProduct, Date iFrom, Date iTo) {
        Integer iCount;
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        Integer iSaleCount = 0;
        for (SSInvoice iInvoice : iInvoices) {
            if (!SSInvoiceMath.inPeriod(iInvoice, iFrom, iTo) || (iCount = SSInvoiceMath.getProductCount(iInvoice, iProduct)) == null) continue;
            iSaleCount = iSaleCount + iCount;
        }
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            if (!SSCreditInvoiceMath.inPeriod(iCreditInvoice, iFrom, iTo) || (iCount = SSCreditInvoiceMath.getProductCount(iCreditInvoice, iProduct)) == null) continue;
            iSaleCount = iSaleCount - iCount;
        }
        return iSaleCount;
    }

    public static BigDecimal getAverageSellingPrice(SSProduct iProduct) {
        return SSProductMath.getAverageSellingPrice(iProduct, null, null);
    }

    public static BigDecimal getAverageSellingPrice(SSProduct iProduct, Date iFrom, Date iTo) {
        BigDecimal iValue;
        BigDecimal iDiscount;
        BigDecimal iUnitprice;
        Integer iQuantity;
        List<SSSaleRow> iRows;
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        BigDecimal iSum = new BigDecimal(0);
        Integer iCount = 0;
        for (SSInvoice iInvoice : iInvoices) {
            if (iFrom != null && iTo != null && !SSInvoiceMath.inPeriod(iInvoice, iFrom, iTo)) continue;
            iRows = SSInvoiceMath.getRowsForProduct(iInvoice, iProduct);
            for (SSSaleRow iRow : iRows) {
                iQuantity = iRow.getQuantity();
                iUnitprice = iRow.getUnitprice();
                iDiscount = iRow.getNormalizedDiscount();
                if (iQuantity == null || iUnitprice == null) continue;
                iValue = iUnitprice.multiply(new BigDecimal(iQuantity));
                if (iDiscount != null) {
                    iValue = iValue.subtract(iValue.multiply(iDiscount));
                }
                iValue = SSInvoiceMath.convertToLocal(iInvoice, iValue);
                iSum = iSum.add(iValue);
                iCount = iCount + iQuantity;
            }
        }
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            if (iFrom != null && iTo != null && !SSCreditInvoiceMath.inPeriod(iCreditInvoice, iFrom, iTo)) continue;
            iRows = SSCreditInvoiceMath.getRowsForProduct(iCreditInvoice, iProduct);
            for (SSSaleRow iRow : iRows) {
                iQuantity = iRow.getQuantity();
                iUnitprice = iRow.getUnitprice();
                iDiscount = iRow.getNormalizedDiscount();
                if (iQuantity == null || iUnitprice == null) continue;
                iValue = iUnitprice.multiply(new BigDecimal(iQuantity));
                if (iDiscount != null) {
                    iValue = iValue.subtract(iValue.multiply(iDiscount));
                }
                iValue = SSCreditInvoiceMath.convertToLocal(iCreditInvoice, iValue);
                iSum = iSum.subtract(iValue);
                iCount = iCount - iQuantity;
            }
        }
        if (iCount == 0) {
            return iProduct.getSellingPrice();
        }
        if (iSum.signum() == 0) {
            return iSum;
        }
        return iSum.divide(new BigDecimal(iCount), 20, RoundingMode.HALF_UP);
    }
}

