/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.math;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSProductMath;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProductRow;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSPurchaseOrderRow;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSPurchaseOrderMath {
    private SSPurchaseOrderMath() {
    }

    public static boolean inPeriod(SSPurchaseOrder iPurchaseOrder, Date pFrom, Date pTo) {
        Date iDate = iPurchaseOrder.getDate();
        Date iFrom = SSDateMath.floor(pFrom);
        Date iTo = SSDateMath.ceil(pTo);
        return iFrom.getTime() <= iDate.getTime() && iDate.getTime() <= iTo.getTime();
    }

    public static boolean inPeriod(SSPurchaseOrder iPurchaseOrder, Date pTo) {
        Date iDate = iPurchaseOrder.getDate();
        Date iTo = SSDateMath.ceil(pTo);
        return iDate.getTime() <= iTo.getTime();
    }

    public static List<SSPurchaseOrder> getOrdersForInvoice(SSSupplierInvoice iInvoice) {
        return SSPurchaseOrderMath.getOrdersForInvoice(SSDB.getInstance().getPurchaseOrders(), iInvoice);
    }

    public static List<SSPurchaseOrder> getOrdersForInvoice(List<SSPurchaseOrder> iOrders, SSSupplierInvoice iInvoice) {
        LinkedList<SSPurchaseOrder> iFiltered = new LinkedList<SSPurchaseOrder>();
        for (SSPurchaseOrder iOrder : iOrders) {
            if (!iOrder.hasInvoice(iInvoice)) continue;
            iFiltered.add(iOrder);
        }
        return iFiltered;
    }

    public static List<SSPurchaseOrder> getOrdersBySupplierNr(List<SSPurchaseOrder> iOrders, String iSupplierNr) {
        LinkedList<SSPurchaseOrder> iFiltered = new LinkedList<SSPurchaseOrder>();
        for (SSPurchaseOrder iOrder : iOrders) {
            if (!iSupplierNr.equals(iOrder.getSupplierNr())) continue;
            iFiltered.add(iOrder);
        }
        return iFiltered;
    }

    public static Integer getProductCount(SSPurchaseOrder iSale, SSProduct iProduct) {
        Integer iCount = 0;
        for (SSPurchaseOrderRow iRow : iSale.getRows()) {
            SSProduct iRowProduct = iRow.getProduct();
            if (iRowProduct == null || iRow.getQuantity() == null) continue;
            if (iRowProduct.equals(iProduct)) {
                iCount = iCount + iRow.getQuantity();
            }
            if (!iRowProduct.isParcel()) continue;
            Integer iQuantity = SSProductMath.getProductCount(iRowProduct, iProduct);
            iCount = iCount + iRow.getQuantity() * iQuantity;
        }
        return iCount;
    }

    public static List<SSPurchaseOrder> getOrdersWithoutInvoice(List<SSPurchaseOrder> iPurchaseOrders) {
        LinkedList<SSPurchaseOrder> iFiltered = new LinkedList<SSPurchaseOrder>();
        for (SSPurchaseOrder iOrder : iPurchaseOrders) {
            if (iOrder.hasInvoice()) continue;
            iFiltered.add(iOrder);
        }
        return iFiltered;
    }

    public static void removeReference(SSSupplierInvoice iInvoice) {
        SSPurchaseOrderMath.removeInvoice(SSDB.getInstance().getPurchaseOrders(), iInvoice);
    }

    public static void removeInvoice(List<SSPurchaseOrder> iPurchaseOrders, SSSupplierInvoice iInvoice) {
        for (SSPurchaseOrder iOrder : iPurchaseOrders) {
            if (!iOrder.hasInvoice(iInvoice)) continue;
            iOrder.setInvoice(null);
        }
    }

    public static Integer getNumberOfIncommingProducts(SSProduct iProduct) {
        Integer iSum = 0;
        for (SSPurchaseOrder iPurchaseOrder : SSDB.getInstance().getPurchaseOrders()) {
            if (iPurchaseOrder.hasInvoice()) continue;
            for (SSPurchaseOrderRow iRow : iPurchaseOrder.getRows()) {
                if (!iProduct.getNumber().equals(iRow.getProductNr())) continue;
                iSum = iSum + iRow.getQuantity();
            }
        }
        return iSum;
    }

    public static Map<String, Integer> getStockInfluencing(List<SSPurchaseOrder> iPurchaseOrders) {
        HashMap<String, Integer> iPurchaseOrderCount = new HashMap<String, Integer>();
        LinkedList<String> iParcelProducts = new LinkedList<String>();
        LinkedList<SSProduct> iProducts = new LinkedList<SSProduct>(SSDB.getInstance().getProducts());
        for (SSProduct iProduct : iProducts) {
            if (!iProduct.isParcel() || iProduct.getNumber() == null) continue;
            iParcelProducts.add(iProduct.getNumber());
        }
        for (SSPurchaseOrder iPurchaseOrder : iPurchaseOrders) {
            for (SSPurchaseOrderRow iRow : iPurchaseOrder.getRows()) {
                Integer iReserved;
                if (iRow.getQuantity() == null) continue;
                if (iParcelProducts.contains(iRow.getProductNr())) {
                    SSProduct iProduct = iRow.getProduct();
                    if (iProduct == null) continue;
                    for (SSProductRow iProductRow : iProduct.getParcelRows()) {
                        iReserved = iPurchaseOrderCount.get(iProductRow.getProductNr()) == null ? iProductRow.getQuantity() * iRow.getQuantity() : (Integer)iPurchaseOrderCount.get(iProductRow.getProductNr()) + iProductRow.getQuantity() * iRow.getQuantity();
                        iPurchaseOrderCount.put(iProductRow.getProductNr(), iReserved);
                    }
                    continue;
                }
                iReserved = iPurchaseOrderCount.get(iRow.getProductNr()) == null ? iRow.getQuantity() : (Integer)iPurchaseOrderCount.get(iRow.getProductNr()) + iRow.getQuantity();
                iPurchaseOrderCount.put(iRow.getProductNr(), iReserved);
            }
        }
        return iPurchaseOrderCount;
    }
}

