/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.calc.util.SSFilter;

public class SSFilterFactory<T> {
    private List<T> iObjects;

    public SSFilterFactory() {
        this.iObjects = Collections.emptyList();
    }

    public SSFilterFactory(List<T> iObjects) {
        this.iObjects = iObjects;
    }

    public void applyFilter(SSFilter<T> iFilter) {
        LinkedList<T> iFiltered = new LinkedList<T>();
        for (T iObject : this.iObjects) {
            if (!iFilter.applyFilter(iObject)) continue;
            iFiltered.add(iObject);
        }
        this.iObjects = iFiltered;
    }

    public void applyFilter(SSFilter<T> ... iFilters) {
        for (SSFilter<T> iFilter : iFilters) {
            this.applyFilter(iFilter);
        }
    }

    public List<T> getObjects() {
        return this.iObjects;
    }

    public void setObjects(List<T> iObjects) {
        this.iObjects = iObjects;
    }

    public static <T> List<T> doFilter(List<T> iObjects, SSFilter<T> iFilter) {
        SSFilterFactory<T> iFactory = new SSFilterFactory<T>(iObjects);
        iFactory.applyFilter(iFilter);
        return iFactory.iObjects;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.calc.util.SSFilterFactory");
        sb.append("{iObjects=").append(this.iObjects);
        sb.append('}');
        return sb.toString();
    }
}

