/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.calc.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSAccountMath;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;

public class SSVATUtil {
    private SSVATUtil() {
    }

    public static BigDecimal getVatToPayOrRetrieve(Map<SSAccount, BigDecimal> creditMinusDebetSum) {
        return SSAccountMath.getSumByVATCodeForAccounts(creditMinusDebetSum, "U1", "UVL", "U2", "U3", "UEU", "UTFU", "I", "IVL");
    }

    public static BigDecimal getVatToPayOrRetrieveRounded(Map<SSAccount, BigDecimal> creditMinusDebetSum) {
        return SSVATUtil.getVatToPayOrRetrieve(creditMinusDebetSum).setScale(0, RoundingMode.DOWN);
    }

    private static void addAccount(SSAccount account, List<SSAccount> accounts, Map<SSAccount, BigDecimal> creditMinusDebetSum, Map<SSAccount, BigDecimal> debetMinusCreditSum) {
        accounts.add(account);
        creditMinusDebetSum.put(account, new BigDecimal(0));
        debetMinusCreditSum.put(account, new BigDecimal(0));
    }

    public static SSVoucher generateVATVoucher(String name, Date iDateFrom, Date iDateTo, SSAccount iAccountR1, SSAccount iAccountR2, SSAccount iAccountA) {
        SSVoucherRow iRow;
        DateFormat iFormat = DateFormat.getDateInstance(3);
        String iDescription = String.format(SSBundle.getBundle().getString("vatreport2007.voucherdescription"), iFormat.format(iDateFrom), iFormat.format(iDateTo));
        List<SSAccount> iAccounts = SSAccountMath.getAccountsByVATCode(SSDB.getInstance().getAccounts(), "U1", "U2", "U3", "UVL", "UEU", "UTFU", "I", "IVL");
        List<SSVoucher> iVouchers = SSVoucherMath.getVouchers(SSDB.getInstance().getVouchers(), iDateFrom, iDateTo);
        Map<SSAccount, BigDecimal> iCreditMinusDebetSum = SSVoucherMath.getCreditMinusDebetSum(iVouchers);
        Map<SSAccount, BigDecimal> debetMinusCreditSum = SSVoucherMath.getDebetMinusCreditSum(iVouchers);
        SSVoucher iVoucher = new SSVoucher();
        iVoucher.doAutoIncrecement();
        iVoucher.setDescription(iDescription);
        iVoucher.setDate(iDateTo);
        BigDecimal iSum = new BigDecimal(0);
        for (SSAccount iAccount : iAccounts) {
            BigDecimal iValue = iCreditMinusDebetSum.get(iAccount);
            if (iValue == null || iValue.signum() == 0) continue;
            iRow = new SSVoucherRow();
            iRow.setAccount(iAccount);
            iRow.setValue(iValue);
            iVoucher.addVoucherRow(iRow);
            iSum = iSum.add(iValue);
        }
        if (iSum.signum() != 0) {
            iRow = new SSVoucherRow();
            BigDecimal iRounded = iSum.setScale(0, RoundingMode.DOWN);
            if (iRounded.signum() > 0) {
                iRow.setAccount(iAccountR2);
                iRow.setCredit(iRounded);
            } else {
                iRow.setAccount(iAccountR1);
                iRow.setDebet(iRounded.abs());
            }
            iVoucher.addVoucherRow(iRow);
            if (iRounded.subtract(iSum).signum() != 0) {
                iRow = new SSVoucherRow();
                iRow.setAccount(iAccountA);
                iRow.setValue(iRounded.subtract(iSum));
                iVoucher.addVoucherRow(iRow);
            }
        }
        return iVoucher;
    }
}

