/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.rmi.server.UID;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSBudget;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSAccountingYear
implements Serializable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private UID iId = new UID();
    private Date iFrom = new Date();
    private Date iTo = new Date();
    private SSAccountPlan iPlan;
    private Map<SSAccount, BigDecimal> iInBalance = new HashMap<SSAccount, BigDecimal>();
    private List<SSVoucher> iVouchers = new LinkedList<SSVoucher>();
    private SSBudget iBudget = new SSBudget();

    public SSAccountingYear() {
    }

    public SSAccountingYear(Date pFrom, Date pTo) {
        this();
        this.iFrom = pFrom;
        this.iTo = pTo;
    }

    public SSAccountingYear(SSAccountingYear pAccountingYear) {
        this();
        this.setData(pAccountingYear);
    }

    public void setData(SSAccountingYear pAccountingYear) {
        this.iId = pAccountingYear.iId;
        this.iFrom = pAccountingYear.iFrom;
        this.iTo = pAccountingYear.iTo;
        this.iInBalance = pAccountingYear.iInBalance;
        this.iVouchers = pAccountingYear.iVouchers;
        this.iBudget = pAccountingYear.iBudget;
        this.iPlan = pAccountingYear.iPlan;
    }

    public UID getId() {
        return this.iId;
    }

    public Date getFrom() {
        return this.iFrom;
    }

    public void setFrom(Date pFrom) {
        this.iFrom = pFrom;
    }

    public Date getTo() {
        return this.iTo;
    }

    public void setTo(Date pTo) {
        this.iTo = pTo;
    }

    public SSAccountPlan getAccountPlan() {
        if (this.iPlan == null) {
            this.iPlan = new SSAccountPlan();
        }
        return this.iPlan;
    }

    public void setAccountPlan(SSAccountPlan pAccountPlan) {
        this.iPlan = pAccountPlan;
    }

    public SSBudget getBudget() {
        return this.iBudget;
    }

    public void setBudget(SSBudget iBudget) {
        this.iBudget = iBudget;
    }

    public Map<SSAccount, BigDecimal> getInBalance() {
        return this.iInBalance;
    }

    public void setInBalance(Map<SSAccount, BigDecimal> pInBalance) {
        this.iInBalance = pInBalance;
    }

    public List<SSVoucher> getVouchers() {
        return this.iVouchers;
    }

    public void setVouchers(List<SSVoucher> pVouchers) {
        this.iVouchers = pVouchers;
    }

    public void updateVoucher(SSVoucher pVoucher) {
        for (int i = 0; i < this.iVouchers.size(); ++i) {
            SSVoucher iVoucher = this.iVouchers.get(i);
            if (iVoucher.getNumber() != pVoucher.getNumber()) continue;
            this.iVouchers.remove(i);
            this.iVouchers.add(i, pVoucher);
        }
    }

    public List<SSAccount> getAccounts() {
        if (this.iPlan != null) {
            return this.iPlan.getAccounts();
        }
        return Collections.emptyList();
    }

    public List<SSAccount> getActiveAccounts() {
        if (this.iPlan != null) {
            return this.iPlan.getActiveAccounts();
        }
        return Collections.emptyList();
    }

    @Override
    public String toRenderString() {
        DateFormat iFormat = DateFormat.getDateInstance(3);
        return iFormat.format(this.iFrom) + " - " + iFormat.format(this.iTo);
    }

    public String toString() {
        DateFormat iFormat = DateFormat.getDateInstance(3);
        StringBuilder sb = new StringBuilder();
        sb.append(iFormat.format(this.iFrom));
        sb.append(' ');
        sb.append(SSBundle.getBundle().getString("date.separator"));
        sb.append(' ');
        sb.append(iFormat.format(this.iTo));
        return sb.toString();
    }

    public void setInBalance(SSAccount pAccount, BigDecimal pAmount) {
        if (this.iInBalance == null) {
            this.iInBalance = new HashMap<SSAccount, BigDecimal>();
        }
        this.iInBalance.put(pAccount, pAmount);
    }

    public BigDecimal getInBalance(SSAccount pAccount) {
        BigDecimal amount;
        if (this.iInBalance == null) {
            this.iInBalance = new HashMap<SSAccount, BigDecimal>();
        }
        if ((amount = this.iInBalance.get(pAccount)) == null) {
            amount = new BigDecimal(0);
        }
        return amount;
    }

    public static void openWarningDialogNoYearData(SSMainFrame iMainFrame) {
        String message = SSBundle.getBundle().getString("accountingYear.no.year.message");
        String title = SSBundle.getBundle().getString("accountingYear.no.year.title");
        JOptionPane.showMessageDialog(iMainFrame, message, title, 1);
    }
}

