/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAutoDistRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSAutoDist
implements SSTableSearchable,
Serializable {
    static final long serialVersionUID = 1L;
    private Integer iAccountNumber;
    private String iDescription;
    private BigDecimal iAmount;
    private List<SSAutoDistRow> iRows;
    private transient SSAccount iAccount;

    public SSAutoDist() {
        this.iRows = new LinkedList<SSAutoDistRow>();
        this.iAmount = new BigDecimal(0);
    }

    public SSAutoDist(SSAccount iAccount) {
        this.iRows = new LinkedList<SSAutoDistRow>();
        this.iAmount = new BigDecimal(0);
        this.iAccount = iAccount;
        this.iAccountNumber = iAccount.getNumber();
    }

    public SSAutoDist(SSAutoDist iAutoDist) {
        this.copyFrom(iAutoDist);
    }

    public SSAutoDist(SSAutoDist iAutoDist, Integer iAccountNumber) {
        this.copyFrom(iAutoDist);
        this.iAccountNumber = iAccountNumber;
    }

    public void copyFrom(SSAutoDist iAutoDist) {
        this.iAccountNumber = iAutoDist.iAccountNumber;
        this.iAccount = iAutoDist.iAccount;
        this.iDescription = iAutoDist.iDescription;
        this.iAmount = iAutoDist.iAmount;
        this.iRows = new LinkedList<SSAutoDistRow>();
        for (SSAutoDistRow iRow : iAutoDist.iRows) {
            this.iRows.add(new SSAutoDistRow(iRow));
        }
    }

    public Integer getNumber() {
        return this.iAccountNumber;
    }

    public void setAccountNumber(Integer iNumber) {
        this.iAccountNumber = iNumber;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescrition(String iText) {
        this.iDescription = iText;
    }

    public List<SSAutoDistRow> getRows() {
        if (this.iRows == null) {
            this.iRows = new LinkedList<SSAutoDistRow>();
        }
        return this.iRows;
    }

    public void setRows(List<SSAutoDistRow> iRows) {
        this.iRows = iRows;
    }

    public BigDecimal getAmount() {
        return this.iAmount;
    }

    public void setAmount(BigDecimal iAmount) {
        this.iAmount = iAmount;
    }

    public SSAccount getAccount() {
        return this.getAccount(SSDB.getInstance().getAccounts());
    }

    public SSAccount getAccount(List<SSAccount> iAccounts) {
        if (this.iAccount == null && this.iAccountNumber != null) {
            for (SSAccount iCurrent : iAccounts) {
                if (!this.iAccountNumber.equals(iCurrent.getNumber())) continue;
                this.iAccount = iCurrent;
                break;
            }
        }
        return this.iAccount;
    }

    public void setAccount(SSAccount iAccount) {
        if (iAccount == null) {
            return;
        }
        this.iAccount = iAccount;
        this.iAccountNumber = iAccount.getNumber();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iAccountNumber);
        sb.append(", ");
        sb.append(this.iDescription);
        return sb.toString();
    }

    @Override
    public String toRenderString() {
        return this.iAccountNumber == null ? null : this.iAccountNumber.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSAutoDist)) {
            return false;
        }
        return this.iAccountNumber.equals(((SSAutoDist)obj).iAccountNumber);
    }
}

