/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSAutoDistRow
implements SSTableSearchable,
Serializable {
    static final long serialVersionUID = 1L;
    private Integer iAccountNr;
    private String iDescription;
    private BigDecimal iPercentage;
    private BigDecimal iDebet;
    private BigDecimal iCredit;
    private String iProjectNr;
    private String iResultUnitNr;
    private transient SSAccount iAccount;
    private transient SSNewProject iProject;
    private transient SSNewResultUnit iResultUnit;

    public SSAutoDistRow() {
    }

    public SSAutoDistRow(SSAccount iAccount) {
        this.iAccount = iAccount;
        this.iAccountNr = iAccount.getNumber();
        this.iPercentage = new BigDecimal(0);
        this.iDebet = new BigDecimal(0);
        this.iCredit = new BigDecimal(0);
        this.iProject = null;
        this.iResultUnit = null;
    }

    public SSAutoDistRow(SSAutoDistRow iRow) {
        this.copyFrom(iRow);
    }

    public void copyFrom(SSAutoDistRow iAutoDistRow) {
        this.iAccountNr = iAutoDistRow.iAccountNr;
        this.iDescription = iAutoDistRow.iDescription;
        this.iPercentage = iAutoDistRow.iPercentage;
        this.iDebet = iAutoDistRow.iDebet;
        this.iCredit = iAutoDistRow.iCredit;
        this.iProjectNr = iAutoDistRow.iProjectNr;
        this.iResultUnitNr = iAutoDistRow.iResultUnitNr;
        this.iAccount = iAutoDistRow.iAccount;
        this.iProject = iAutoDistRow.iProject;
        this.iResultUnit = iAutoDistRow.iResultUnit;
    }

    public Integer getAccountNr() {
        return this.iAccountNr;
    }

    public void setAccountNr(Integer iAccountNr) {
        this.iAccountNr = iAccountNr;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String iDescription) {
        this.iDescription = iDescription;
    }

    public BigDecimal getPercentage() {
        return this.iPercentage;
    }

    public void setPercentage(BigDecimal iPercentage) {
        this.iPercentage = iPercentage;
    }

    public BigDecimal getDebet() {
        return this.iDebet;
    }

    public void setDebet(BigDecimal iDebet) {
        this.iDebet = iDebet;
    }

    public BigDecimal getCredit() {
        return this.iCredit;
    }

    public void setCredit(BigDecimal iCredit) {
        this.iCredit = iCredit;
    }

    public String getProjectNr() {
        return this.iProjectNr;
    }

    public void setProjectNr(String iProjectNr) {
        this.iProjectNr = iProjectNr;
    }

    public String getResultUnitNr() {
        return this.iResultUnitNr;
    }

    public void setResultUnitNr(String iResultUnitNr) {
        this.iResultUnitNr = iResultUnitNr;
    }

    public SSAccount getAccount() {
        return this.getAccount(SSDB.getInstance().getAccounts());
    }

    public void setAccount(SSAccount iAccount) {
        this.iAccount = iAccount;
        this.iAccountNr = iAccount.getNumber();
    }

    public SSAccount getAccount(List<SSAccount> iAccounts) {
        if (this.iAccount == null && this.iAccountNr != null) {
            for (SSAccount iCurrent : iAccounts) {
                if (!this.iAccountNr.equals(iCurrent.getNumber())) continue;
                this.iAccount = iCurrent;
                break;
            }
        }
        return this.iAccount;
    }

    public SSNewProject getProject() {
        return this.getProject(SSDB.getInstance().getProjects());
    }

    public SSNewProject getProject(List<SSNewProject> iProjects) {
        if (this.iProject == null && this.iProjectNr != null) {
            for (SSNewProject iCurrent : iProjects) {
                if (!this.iProjectNr.equals(iCurrent.getNumber())) continue;
                this.iProject = iCurrent;
                break;
            }
        }
        return this.iProject;
    }

    public void setProject(SSNewProject iProject) {
        this.iProject = iProject;
        this.iProjectNr = iProject == null ? null : iProject.getNumber();
    }

    public SSNewResultUnit getResultUnit() {
        return this.getResultUnit(SSDB.getInstance().getResultUnits());
    }

    public SSNewResultUnit getResultUnit(List<SSNewResultUnit> iResultUnits) {
        if (this.iResultUnit == null && this.iResultUnitNr != null) {
            for (SSNewResultUnit iCurrent : iResultUnits) {
                if (!this.iResultUnitNr.equals(iCurrent.getNumber())) continue;
                this.iResultUnit = iCurrent;
                break;
            }
        }
        return this.iResultUnit;
    }

    public void setResultUnit(SSNewResultUnit iResultUnit) {
        this.iResultUnit = iResultUnit;
        this.iResultUnitNr = iResultUnit == null ? null : iResultUnit.getNumber();
    }

    @Override
    public String toRenderString() {
        return String.valueOf(this.iAccountNr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.SSAutoDistRow");
        sb.append("{iAccount=").append(this.iAccount);
        sb.append(", iAccountNr=").append(this.iAccountNr);
        sb.append(", iCredit=").append(this.iCredit);
        sb.append(", iDebet=").append(this.iDebet);
        sb.append(", iDescription='").append(this.iDescription).append('\'');
        sb.append(", iPercentage=").append(this.iPercentage);
        sb.append(", iProject=").append(this.iProject);
        sb.append(", iProjectNr='").append(this.iProjectNr).append('\'');
        sb.append(", iResultUnit=").append(this.iResultUnit);
        sb.append(", iResultUnitNr='").append(this.iResultUnitNr).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

