/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.rmi.server.UID;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.calc.util.SSAutoIncrement;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSAddress;
import se.swedsoft.bookkeeping.data.SSAutoDist;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSIndelivery;
import se.swedsoft.bookkeeping.data.SSInpayment;
import se.swedsoft.bookkeeping.data.SSInventory;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSOutdelivery;
import se.swedsoft.bookkeeping.data.SSOutpayment;
import se.swedsoft.bookkeeping.data.SSPeriodicInvoice;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProject;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSResultUnit;
import se.swedsoft.bookkeeping.data.SSStandardText;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierCreditInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSTender;
import se.swedsoft.bookkeeping.data.SSVoucherTemplate;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.common.SSUnit;

public class SSCompany
implements Serializable {
    static final long serialVersionUID = 1L;
    private UID iId = new UID();
    private String iName;
    private String iPhone;
    private String iPhone2;
    private String iTelefax;
    private String iResidence;
    private String iWebAddress;
    private String iSMTPAddress;
    private String iEMail;
    private String iContactPerson;
    private boolean iTaxRegistered;
    private String iCorporateID;
    private String iLogotype;
    private String iBank;
    private String iVATNumber;
    private String iBankAccountNumber;
    private String iPlusAccountNumber;
    private String iIBAN;
    private String iSwift;
    private SSCurrency iCurrency;
    private BigDecimal iDelayintrest;
    private BigDecimal iReminderfee;
    private String iEstimatedDelivery;
    private BigDecimal iTaxrate1;
    private BigDecimal iTaxrate2;
    private BigDecimal iTaxrate3;
    private String iWeightUnit;
    private String iVolumeUnit;
    private SSAddress iAddress = new SSAddress();
    private SSAddress iDeliveryAddress = new SSAddress();
    private Map<SSStandardText, String> iStandardTexts = new HashMap<SSStandardText, String>();
    private Map<SSDefaultAccount, Integer> iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
    private List<SSCurrency> iCurrencies;
    private List<SSUnit> iUnits;
    private List<SSDeliveryWay> iDeliveryWays;
    private List<SSDeliveryTerm> iDeliveryTerms;
    private List<SSPaymentTerm> iPaymentTerms;
    private SSUnit iStandardUnit;
    private SSPaymentTerm iPaymentTerm;
    private SSDeliveryTerm iDeliveryTerm;
    private SSDeliveryWay iDeliveryWay;
    private List<SSProject> iProjects = new LinkedList<SSProject>();
    private List<SSResultUnit> iResultUnits;
    private List<SSVoucherTemplate> iVoucherTemplates = new LinkedList<SSVoucherTemplate>();
    private List<SSProduct> iProducts;
    private List<SSCustomer> iCustomers;
    private List<SSSupplier> iSuppliers;
    private List<SSAutoDist> iAutoDists;
    private List<SSTender> iTenders;
    private List<SSOrder> iOrders;
    private List<SSInvoice> iInvoices;
    private List<SSInpayment> iInpayments;
    private List<SSOutpayment> iOutpayments;
    private List<SSCreditInvoice> iCreditInvoices;
    private List<SSPeriodicInvoice> iPeriodicInvoices;
    private List<SSPurchaseOrder> iPurchaseOrders;
    private List<SSSupplierInvoice> iSupplierInvoices;
    private List<SSSupplierCreditInvoice> iSupplierCreditinvoices;
    private List<SSInventory> iInventories;
    private List<SSIndelivery> iIndeliveries;
    private List<SSOutdelivery> iOutdeliveries;
    private SSAutoIncrement iAutoIncrement;

    public SSCompany() {
        this.iResultUnits = new LinkedList<SSResultUnit>();
        this.iProducts = new LinkedList<SSProduct>();
        this.iCustomers = new LinkedList<SSCustomer>();
        this.iSuppliers = new LinkedList<SSSupplier>();
        this.iAutoDists = new LinkedList<SSAutoDist>();
        this.iTenders = new LinkedList<SSTender>();
        this.iOrders = new LinkedList<SSOrder>();
        this.iInvoices = new LinkedList<SSInvoice>();
        this.iInpayments = new LinkedList<SSInpayment>();
        this.iCreditInvoices = new LinkedList<SSCreditInvoice>();
        this.iAutoIncrement = new SSAutoIncrement();
    }

    public UID getId() {
        return this.iId;
    }

    public SSAddress getAddress() {
        return this.iAddress;
    }

    public void setAddress(SSAddress pAddress) {
        this.iAddress = pAddress;
    }

    public SSAddress getDeliveryAddress() {
        return this.iDeliveryAddress;
    }

    public void setDeliveryAddress(SSAddress pDeliveryAddress) {
        this.iDeliveryAddress = pDeliveryAddress;
    }

    public Map<SSStandardText, String> getStandardTexts() {
        if (this.iStandardTexts == null) {
            this.iStandardTexts = new HashMap<SSStandardText, String>();
        }
        return this.iStandardTexts;
    }

    public String getStandardText(SSStandardText iStandardtext) {
        if (this.iStandardTexts != null) {
            return this.iStandardTexts.get((Object)iStandardtext);
        }
        return null;
    }

    public void setStandardTexts(Map<SSStandardText, String> pStandardTexts) {
        this.iStandardTexts = pStandardTexts;
    }

    public Map<SSDefaultAccount, Integer> getDefaultAccounts() {
        if (this.iDefaultAccounts == null) {
            this.iDefaultAccounts = new HashMap<SSDefaultAccount, Integer>();
        }
        return this.iDefaultAccounts;
    }

    public Integer getDefaultAccount(SSDefaultAccount iDefaultAccount) {
        if (this.iDefaultAccounts != null && this.iDefaultAccounts.containsKey(iDefaultAccount)) {
            return this.iDefaultAccounts.get(iDefaultAccount);
        }
        return iDefaultAccount.getDefaultAccountNumber();
    }

    public SSAccount getDefaultAccount(SSAccountPlan iAccountPlan, SSDefaultAccount iDefaultAccount) {
        Integer iAccountNumber = this.iDefaultAccounts.get(iDefaultAccount);
        if (iAccountNumber == null) {
            return null;
        }
        return iAccountPlan.getAccount(iAccountNumber);
    }

    public void setDefaultAccounts(Map<SSDefaultAccount, Integer> iDefaultAccounts) {
        this.iDefaultAccounts = iDefaultAccounts;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getPhone() {
        return this.iPhone;
    }

    public void setPhone(String pPhone) {
        this.iPhone = pPhone;
    }

    public String getPhone2() {
        return this.iPhone2;
    }

    public void setPhone2(String pPhone2) {
        this.iPhone2 = pPhone2;
    }

    public String getTelefax() {
        return this.iTelefax;
    }

    public void setTelefax(String pTelefax) {
        this.iTelefax = pTelefax;
    }

    public String getResidence() {
        return this.iResidence;
    }

    public void setResidence(String residence) {
        this.iResidence = residence;
    }

    public String getEMail() {
        return this.iEMail;
    }

    public void setEMail(String pEMail) {
        this.iEMail = pEMail;
    }

    public String getHomepage() {
        return this.iWebAddress;
    }

    public void setHomepage(String pWebAddress) {
        this.iWebAddress = pWebAddress;
    }

    public String getSMTP() {
        return this.iSMTPAddress;
    }

    public void setSMTP(String pSMTPAddress) {
        this.iSMTPAddress = pSMTPAddress;
    }

    public String getContactPerson() {
        return this.iContactPerson;
    }

    public void setContactPerson(String pContactPerson) {
        this.iContactPerson = pContactPerson;
    }

    public boolean getTaxRegistered() {
        return this.iTaxRegistered;
    }

    public void setTaxRegistered(boolean pTaxRegistered) {
        this.iTaxRegistered = pTaxRegistered;
    }

    public String getCorporateID() {
        return this.iCorporateID;
    }

    public void setCorporateID(String iCorporateID) {
        this.iCorporateID = iCorporateID;
    }

    public String getLogotype() {
        return this.iLogotype;
    }

    public void setLogotype(String pLogotype) {
        this.iLogotype = pLogotype;
    }

    public String getVATNumber() {
        return this.iVATNumber;
    }

    public void setVATNumber(String pVATNumber) {
        this.iVATNumber = pVATNumber;
    }

    public String getBank() {
        return this.iBank;
    }

    public void setBank(String pBank) {
        this.iBank = pBank;
    }

    public String getBankGiroNumber() {
        return this.iBankAccountNumber;
    }

    public void setBankGiroNumber(String bankAccountNumber) {
        this.iBankAccountNumber = bankAccountNumber;
    }

    public String getPlusGiroNumber() {
        return this.iPlusAccountNumber;
    }

    public void setPlusGiroNumber(String plusAccountNumber) {
        this.iPlusAccountNumber = plusAccountNumber;
    }

    public String getIBAN() {
        return this.iIBAN;
    }

    public void setIBAN(String IBAN) {
        this.iIBAN = IBAN;
    }

    public String getBIC() {
        return this.iSwift;
    }

    public void setBIC(String swift) {
        this.iSwift = swift;
    }

    public String getVolumeUnit() {
        if (this.iVolumeUnit == null) {
            this.iVolumeUnit = "m3";
        }
        return this.iVolumeUnit;
    }

    public void setVolumeUnit(String iVolumeUnit) {
        this.iVolumeUnit = iVolumeUnit;
    }

    public String getWeightUnit() {
        if (this.iWeightUnit == null) {
            this.iWeightUnit = "kg";
        }
        return this.iWeightUnit;
    }

    public void setWeightUnit(String iWeightUnit) {
        this.iWeightUnit = iWeightUnit;
    }

    public SSCurrency getCurrency() {
        return this.iCurrency;
    }

    public void setCurrency(SSCurrency iCurrency) {
        this.iCurrency = iCurrency;
    }

    public SSUnit getStandardUnit() {
        return this.iStandardUnit;
    }

    public void setStandardUnit(SSUnit iStandardUnit) {
        this.iStandardUnit = iStandardUnit;
    }

    public BigDecimal getDelayInterest() {
        return this.iDelayintrest;
    }

    public void setDelayInterest(BigDecimal iDelayintrest) {
        this.iDelayintrest = iDelayintrest;
    }

    public BigDecimal getReminderfee() {
        return this.iReminderfee;
    }

    public void setReminderfee(BigDecimal iReminderfee) {
        this.iReminderfee = iReminderfee;
    }

    public BigDecimal getTaxRate1() {
        if (this.iTaxrate1 == null) {
            this.iTaxrate1 = new BigDecimal(25);
        }
        return this.iTaxrate1;
    }

    public void setTaxrate1(BigDecimal iTaxrate1) {
        this.iTaxrate1 = iTaxrate1;
    }

    public BigDecimal getTaxRate2() {
        if (this.iTaxrate2 == null) {
            this.iTaxrate2 = new BigDecimal(12);
        }
        return this.iTaxrate2;
    }

    public void setTaxrate2(BigDecimal iTaxrate2) {
        this.iTaxrate2 = iTaxrate2;
    }

    public BigDecimal getTaxRate3() {
        if (this.iTaxrate3 == null) {
            this.iTaxrate3 = new BigDecimal(6);
        }
        return this.iTaxrate3;
    }

    public void setTaxrate3(BigDecimal iTaxrate3) {
        this.iTaxrate3 = iTaxrate3;
    }

    public SSDeliveryWay getDeliveryWay() {
        return this.iDeliveryWay;
    }

    public void setDeliveryWay(SSDeliveryWay iDeliveryWay) {
        this.iDeliveryWay = iDeliveryWay;
    }

    public SSDeliveryTerm getDeliveryTerm() {
        return this.iDeliveryTerm;
    }

    public void setDeliveryTerm(SSDeliveryTerm iDeliveryTerm) {
        this.iDeliveryTerm = iDeliveryTerm;
    }

    public SSPaymentTerm getPaymentTerm() {
        return this.iPaymentTerm;
    }

    public void setPaymentTerm(SSPaymentTerm iPaymentTerm) {
        this.iPaymentTerm = iPaymentTerm;
    }

    public BigDecimal getTaxRate(SSTaxCode iTaxCode) {
        if (iTaxCode == SSTaxCode.TAXRATE_1) {
            return this.iTaxrate1;
        }
        if (iTaxCode == SSTaxCode.TAXRATE_2) {
            return this.iTaxrate2;
        }
        if (iTaxCode == SSTaxCode.TAXRATE_3) {
            return this.iTaxrate3;
        }
        return null;
    }

    public String getEstimatedDelivery() {
        return this.iEstimatedDelivery;
    }

    public void setEstimatedDelivery(String iEstimatedDelivery) {
        this.iEstimatedDelivery = iEstimatedDelivery;
    }

    public List<SSCurrency> getCurrencies() {
        if (this.iCurrencies == null) {
            this.iCurrencies = SSCurrency.getDefaultCurrencies();
        }
        return this.iCurrencies;
    }

    public void updateCurrency(SSCurrency pCurrency) {
        for (int i = 0; i < this.iCurrencies.size(); ++i) {
            SSCurrency iCurrency = this.iCurrencies.get(i);
            if (!iCurrency.getName().equals(pCurrency.getName())) continue;
            this.iCurrencies.remove(i);
            this.iCurrencies.add(i, pCurrency);
        }
    }

    public List<SSUnit> getUnits() {
        if (this.iUnits == null) {
            this.iUnits = SSUnit.getDefaultUnits();
        }
        return this.iUnits;
    }

    public void updateUnit(SSUnit pUnit) {
        for (int i = 0; i < this.iCurrencies.size(); ++i) {
            SSUnit iUnit = this.iUnits.get(i);
            if (!iUnit.getName().equals(pUnit.getName())) continue;
            this.iUnits.remove(i);
            this.iUnits.add(i, pUnit);
        }
    }

    public List<SSDeliveryWay> getDeliveryWays() {
        if (this.iDeliveryWays == null) {
            this.iDeliveryWays = SSDeliveryWay.getDefaultDeliveryWays();
        }
        return this.iDeliveryWays;
    }

    public void updateDeliveryWay(SSDeliveryWay pDeliveryWay) {
        for (int i = 0; i < this.iCurrencies.size(); ++i) {
            SSDeliveryWay iDeliveryWay = this.iDeliveryWays.get(i);
            if (!iDeliveryWay.getName().equals(pDeliveryWay.getName())) continue;
            this.iDeliveryWays.remove(i);
            this.iDeliveryWays.add(i, pDeliveryWay);
        }
    }

    public List<SSDeliveryTerm> getDeliveryTerms() {
        if (this.iDeliveryTerms == null) {
            this.iDeliveryTerms = SSDeliveryTerm.getDefaultDeliveryTerms();
        }
        return this.iDeliveryTerms;
    }

    public void updateDeliveryTerm(SSDeliveryTerm pDeliveryTerm) {
        for (int i = 0; i < this.iCurrencies.size(); ++i) {
            SSDeliveryTerm iDeliveryTerm = this.iDeliveryTerms.get(i);
            if (!iDeliveryTerm.getName().equals(pDeliveryTerm.getName())) continue;
            this.iDeliveryTerms.remove(i);
            this.iDeliveryTerms.add(i, pDeliveryTerm);
        }
    }

    public List<SSPaymentTerm> getPaymentTerms() {
        if (this.iPaymentTerms == null) {
            this.iPaymentTerms = SSPaymentTerm.getDefaultPaymentTerms();
        }
        return this.iPaymentTerms;
    }

    public void updatePaymentTerm(SSPaymentTerm pPaymentTerm) {
        for (int i = 0; i < this.iCurrencies.size(); ++i) {
            SSPaymentTerm iPaymentTerm = this.iPaymentTerms.get(i);
            if (!iPaymentTerm.getName().equals(pPaymentTerm.getName())) continue;
            this.iPaymentTerms.remove(i);
            this.iPaymentTerms.add(i, pPaymentTerm);
        }
    }

    public List<SSProject> getProjects() {
        return this.iProjects;
    }

    public void setProjects(List<SSProject> iProjects) {
        this.iProjects = iProjects;
    }

    public void updateProject(SSProject pProject) {
        for (int i = 0; i < this.iProjects.size(); ++i) {
            SSProject iProject = this.iProjects.get(i);
            if (iProject.getNumber() != pProject.getNumber()) continue;
            this.iProjects.remove(i);
            this.iProjects.add(i, pProject);
        }
    }

    public List<SSResultUnit> getResultUnits() {
        return this.iResultUnits;
    }

    public void setResultUnits(List<SSResultUnit> iResultUnits) {
        this.iResultUnits = iResultUnits;
    }

    public void updateResultUnit(SSResultUnit pResultUnit) {
        for (int i = 0; i < this.iResultUnits.size(); ++i) {
            SSResultUnit iResultUnit = this.iResultUnits.get(i);
            if (iResultUnit.getNumber() != pResultUnit.getNumber()) continue;
            this.iResultUnits.remove(i);
            this.iResultUnits.add(i, pResultUnit);
        }
    }

    public List<SSVoucherTemplate> getVoucherTemplates() {
        return this.iVoucherTemplates;
    }

    public void setVoucherTemplates(List<SSVoucherTemplate> iVoucherTemplates) {
        this.iVoucherTemplates = iVoucherTemplates;
    }

    public List<SSProduct> getProducts() {
        if (this.iProducts == null) {
            this.iProducts = new LinkedList<SSProduct>();
        }
        return this.iProducts;
    }

    public void setProducts(List<SSProduct> iProducts) {
        this.iProducts = iProducts;
    }

    public void updateProduct(SSProduct pProduct) {
        for (int i = 0; i < this.iProducts.size(); ++i) {
            SSProduct iProduct = this.iProducts.get(i);
            if (!iProduct.getNumber().equals(pProduct.getNumber())) continue;
            this.iProducts.remove(i);
            this.iProducts.add(i, pProduct);
        }
    }

    public List<SSCustomer> getCustomers() {
        if (this.iCustomers == null) {
            this.iCustomers = new LinkedList<SSCustomer>();
        }
        return this.iCustomers;
    }

    public void setCustomers(List<SSCustomer> iCustomers) {
        this.iCustomers = iCustomers;
    }

    public void updateCustomer(SSCustomer pCustomer) {
        for (int i = 0; i < this.iCustomers.size(); ++i) {
            SSCustomer iCustomer = this.iCustomers.get(i);
            if (!iCustomer.getNumber().equals(pCustomer.getNumber())) continue;
            this.iCustomers.remove(i);
            this.iCustomers.add(i, pCustomer);
        }
    }

    public List<SSSupplier> getSuppliers() {
        if (this.iSuppliers == null) {
            this.iSuppliers = new LinkedList<SSSupplier>();
        }
        return this.iSuppliers;
    }

    public void setSuppliers(List<SSSupplier> iSuppliers) {
        this.iSuppliers = iSuppliers;
    }

    public void updateSupplier(SSSupplier pSupplier) {
        for (int i = 0; i < this.iSuppliers.size(); ++i) {
            SSSupplier iSupplier = this.iSuppliers.get(i);
            if (!iSupplier.getNumber().equals(pSupplier.getNumber())) continue;
            this.iSuppliers.remove(i);
            this.iSuppliers.add(i, pSupplier);
        }
    }

    public List<SSAutoDist> getAutoDists() {
        if (this.iAutoDists == null) {
            this.iAutoDists = new LinkedList<SSAutoDist>();
        }
        return this.iAutoDists;
    }

    public void setAutoDists(List<SSAutoDist> iAutoDists) {
        this.iAutoDists = iAutoDists;
    }

    public void updateAutoDist(SSAutoDist pAutoDist) {
        for (int i = 0; i < this.iAutoDists.size(); ++i) {
            SSAutoDist iAutoDist = this.iAutoDists.get(i);
            if (!iAutoDist.getNumber().equals(pAutoDist.getNumber())) continue;
            this.iAutoDists.remove(i);
            this.iAutoDists.add(i, pAutoDist);
        }
    }

    public List<SSTender> getTenders() {
        if (this.iTenders == null) {
            this.iTenders = new LinkedList<SSTender>();
        }
        return this.iTenders;
    }

    public void updateTender(SSTender pTender) {
        for (int i = 0; i < this.iTenders.size(); ++i) {
            SSTender iTender = this.iTenders.get(i);
            if (!iTender.getNumber().equals(pTender.getNumber())) continue;
            this.iTenders.remove(i);
            this.iTenders.add(i, pTender);
        }
    }

    public void setTenders(List<SSTender> iTenders) {
        this.iTenders = iTenders;
    }

    public Double getTenderValueForMonth(SSMonth iMonth) {
        Double sum = 0.0;
        for (SSTender iTender : this.iTenders) {
            Date iTenderDate = iTender.getDate();
            if (!iMonth.isDateInMonth(iTenderDate)) continue;
            for (SSSaleRow iRow : iTender.getRows()) {
                if (iRow.getSum() == null) continue;
                sum = sum + iRow.getSum().doubleValue() * iTender.getCurrencyRate().doubleValue();
            }
        }
        return sum;
    }

    public List<SSOrder> getOrders() {
        if (this.iOrders == null) {
            this.iOrders = new LinkedList<SSOrder>();
        }
        return this.iOrders;
    }

    public void setOrders(List<SSOrder> iOrders) {
        this.iOrders = iOrders;
    }

    public void updateOrder(SSOrder pOrder) {
        for (int i = 0; i < this.iOrders.size(); ++i) {
            SSOrder iOrder = this.iOrders.get(i);
            if (!iOrder.getNumber().equals(pOrder.getNumber())) continue;
            this.iOrders.remove(i);
            this.iOrders.add(i, pOrder);
        }
    }

    public Double getOrderValueForMonth(SSMonth iMonth) {
        Double sum = 0.0;
        for (SSOrder iOrder : this.iOrders) {
            Date iOrderDate = iOrder.getDate();
            if (!iMonth.isDateInMonth(iOrderDate)) continue;
            for (SSSaleRow iRow : iOrder.getRows()) {
                if (iRow.getSum() == null) continue;
                sum = sum + iRow.getSum().doubleValue() * iOrder.getCurrencyRate().doubleValue();
            }
        }
        return sum;
    }

    public List<SSInvoice> getInvoices() {
        if (this.iInvoices == null) {
            this.iInvoices = new LinkedList<SSInvoice>();
        }
        return this.iInvoices;
    }

    public void setInvoices(List<SSInvoice> iInvoices) {
        this.iInvoices = iInvoices;
    }

    public void updateInvoice(SSInvoice pInvoice) {
        for (int i = 0; i < this.iInvoices.size(); ++i) {
            SSInvoice iInvoice = this.iInvoices.get(i);
            if (!iInvoice.getNumber().equals(pInvoice.getNumber())) continue;
            this.iInvoices.remove(i);
            this.iInvoices.add(i, pInvoice);
        }
    }

    public Double getInvoiceValueForMonth(SSMonth iMonth) {
        Double suminvoices = 0.0;
        for (SSInvoice iInvoice : this.iInvoices) {
            Date iInvoiceDate = iInvoice.getDate();
            if (!iMonth.isDateInMonth(iInvoiceDate)) continue;
            for (SSSaleRow iRow : iInvoice.getRows()) {
                if (iRow.getSum() == null) continue;
                suminvoices = suminvoices + iRow.getSum().doubleValue() * iInvoice.getCurrencyRate().doubleValue();
            }
        }
        Double sumcreditinvoices = 0.0;
        for (SSCreditInvoice iCreditInvoice : this.iCreditInvoices) {
            Date iCreditInvoiceDate = iCreditInvoice.getDate();
            if (!iMonth.isDateInMonth(iCreditInvoiceDate)) continue;
            for (SSSaleRow iRow : iCreditInvoice.getRows()) {
                if (iRow.getSum() == null) continue;
                sumcreditinvoices = sumcreditinvoices + iRow.getSum().doubleValue() * iCreditInvoice.getCurrencyRate().doubleValue();
            }
        }
        return suminvoices - sumcreditinvoices;
    }

    public List<SSInpayment> getInpayments() {
        if (this.iInpayments == null) {
            this.iInpayments = new LinkedList<SSInpayment>();
        }
        return this.iInpayments;
    }

    public void setInpayments(List<SSInpayment> iInpayments) {
        this.iInpayments = iInpayments;
    }

    public void updateInpayment(SSInpayment pInpayment) {
        for (int i = 0; i < this.iInpayments.size(); ++i) {
            SSInpayment iInpayment = this.iInpayments.get(i);
            if (!iInpayment.getNumber().equals(pInpayment.getNumber())) continue;
            this.iInpayments.remove(i);
            this.iInpayments.add(i, pInpayment);
        }
    }

    public List<SSOutpayment> getOutpayments() {
        if (this.iOutpayments == null) {
            this.iOutpayments = new LinkedList<SSOutpayment>();
        }
        return this.iOutpayments;
    }

    public void setOutpayments(List<SSOutpayment> iOutpayments) {
        this.iOutpayments = iOutpayments;
    }

    public void updateOutpayment(SSOutpayment pOutpayment) {
        for (int i = 0; i < this.iOutpayments.size(); ++i) {
            SSOutpayment iOutpayment = this.iOutpayments.get(i);
            if (!iOutpayment.getNumber().equals(pOutpayment.getNumber())) continue;
            this.iOutpayments.remove(i);
            this.iOutpayments.add(i, pOutpayment);
        }
    }

    public List<SSCreditInvoice> getCreditInvoices() {
        if (this.iCreditInvoices == null) {
            this.iCreditInvoices = new LinkedList<SSCreditInvoice>();
        }
        return this.iCreditInvoices;
    }

    public void setCreditInvoices(List<SSCreditInvoice> iCreditInvoices) {
        this.iCreditInvoices = iCreditInvoices;
    }

    public void updateCreditInvoice(SSCreditInvoice pCreditInvoice) {
        for (int i = 0; i < this.iCreditInvoices.size(); ++i) {
            SSCreditInvoice iCreditInvoice = this.iCreditInvoices.get(i);
            if (!iCreditInvoice.getNumber().equals(pCreditInvoice.getNumber())) continue;
            this.iCreditInvoices.remove(i);
            this.iCreditInvoices.add(i, pCreditInvoice);
        }
    }

    public List<SSPeriodicInvoice> getPeriodicInvoices() {
        if (this.iPeriodicInvoices == null) {
            this.iPeriodicInvoices = new LinkedList<SSPeriodicInvoice>();
        }
        return this.iPeriodicInvoices;
    }

    public void setPeriodicInvoices(List<SSPeriodicInvoice> iPeriodicInvoices) {
        this.iPeriodicInvoices = iPeriodicInvoices;
    }

    public void updatePeriodicInvoice(SSPeriodicInvoice pPeriodicInvoice) {
        for (int i = 0; i < this.iPeriodicInvoices.size(); ++i) {
            SSPeriodicInvoice iPeriodicInvoice = this.iPeriodicInvoices.get(i);
            if (!iPeriodicInvoice.getNumber().equals(pPeriodicInvoice.getNumber())) continue;
            this.iPeriodicInvoices.remove(i);
            this.iPeriodicInvoices.add(i, pPeriodicInvoice);
        }
    }

    public List<SSPurchaseOrder> getPurchaseOrders() {
        if (this.iPurchaseOrders == null) {
            this.iPurchaseOrders = new LinkedList<SSPurchaseOrder>();
        }
        return this.iPurchaseOrders;
    }

    public void setPurchaseOrders(List<SSPurchaseOrder> iPurchaseOrders) {
        this.iPurchaseOrders = iPurchaseOrders;
    }

    public void updatePurchaseOrder(SSPurchaseOrder pPurchaseOrder) {
        for (int i = 0; i < this.iPurchaseOrders.size(); ++i) {
            SSPurchaseOrder iPurchaseOrder = this.iPurchaseOrders.get(i);
            if (!iPurchaseOrder.getNumber().equals(pPurchaseOrder.getNumber())) continue;
            this.iPurchaseOrders.remove(i);
            this.iPurchaseOrders.add(i, pPurchaseOrder);
        }
    }

    public Double getPurchaseOrderValueForMonth(SSMonth iMonth) {
        Double sum = 0.0;
        for (SSPurchaseOrder iPurchaseOrder : this.iPurchaseOrders) {
            Date iPurchaseOrderDate = iPurchaseOrder.getDate();
            if (!iMonth.isDateInMonth(iPurchaseOrderDate) || iPurchaseOrder.getSum() == null) continue;
            sum = sum + iPurchaseOrder.getSum().doubleValue() * iPurchaseOrder.getCurrencyRate().doubleValue();
        }
        return sum;
    }

    public List<SSSupplierInvoice> getSupplierInvoices() {
        if (this.iSupplierInvoices == null) {
            this.iSupplierInvoices = new LinkedList<SSSupplierInvoice>();
        }
        return this.iSupplierInvoices;
    }

    public void setSupplierInvoices(List<SSSupplierInvoice> iSupplierInvoices) {
        this.iSupplierInvoices = iSupplierInvoices;
    }

    public void updateSupplierInvoice(SSSupplierInvoice pSupplierInvoice) {
        for (int i = 0; i < this.iSupplierInvoices.size(); ++i) {
            SSSupplierInvoice iSupplierInvoice = this.iSupplierInvoices.get(i);
            if (!iSupplierInvoice.getNumber().equals(pSupplierInvoice.getNumber())) continue;
            this.iSupplierInvoices.remove(i);
            this.iSupplierInvoices.add(i, pSupplierInvoice);
        }
    }

    public Double getSupplierInvoiceValueForMonth(SSMonth iMonth) {
        Double sumSupplierInvoices = 0.0;
        for (SSSupplierInvoice iSupplierInvoice : this.iSupplierInvoices) {
            Date iSupplierInvoiceDate = iSupplierInvoice.getDate();
            if (!iMonth.isDateInMonth(iSupplierInvoiceDate) || SSSupplierInvoiceMath.getNetSum(iSupplierInvoice) == null) continue;
            sumSupplierInvoices = sumSupplierInvoices + SSSupplierInvoiceMath.getNetSum(iSupplierInvoice).doubleValue() * iSupplierInvoice.getCurrencyRate().doubleValue();
        }
        Double sumSupplierCreditInvoices = 0.0;
        for (SSSupplierCreditInvoice iSupplierCreditInvoice : this.iSupplierCreditinvoices) {
            Date iSupplierCreditInvoiceDate = iSupplierCreditInvoice.getDate();
            if (!iMonth.isDateInMonth(iSupplierCreditInvoiceDate) || SSSupplierInvoiceMath.getNetSum(iSupplierCreditInvoice) == null) continue;
            sumSupplierCreditInvoices = sumSupplierCreditInvoices + SSSupplierInvoiceMath.getNetSum(iSupplierCreditInvoice).doubleValue() * iSupplierCreditInvoice.getCurrencyRate().doubleValue();
        }
        return sumSupplierInvoices - sumSupplierCreditInvoices;
    }

    public List<SSSupplierCreditInvoice> getSupplierCreditinvoices() {
        if (this.iSupplierCreditinvoices == null) {
            this.iSupplierCreditinvoices = new LinkedList<SSSupplierCreditInvoice>();
        }
        return this.iSupplierCreditinvoices;
    }

    public void setSupplierCreditinvoices(List<SSSupplierCreditInvoice> iSupplierCreditinvoices) {
        this.iSupplierCreditinvoices = iSupplierCreditinvoices;
    }

    public void updateSupplierCreditInvoice(SSSupplierCreditInvoice pSupplierCreditInvoice) {
        for (int i = 0; i < this.iSupplierCreditinvoices.size(); ++i) {
            SSSupplierCreditInvoice iSupplierCreditInvoice = this.iSupplierCreditinvoices.get(i);
            if (!iSupplierCreditInvoice.getNumber().equals(pSupplierCreditInvoice.getNumber())) continue;
            this.iSupplierCreditinvoices.remove(i);
            this.iSupplierCreditinvoices.add(i, pSupplierCreditInvoice);
        }
    }

    public List<SSInventory> getInventories() {
        if (this.iInventories == null) {
            this.iInventories = new LinkedList<SSInventory>();
        }
        return this.iInventories;
    }

    public void setInventories(List<SSInventory> iInventories) {
        this.iInventories = iInventories;
    }

    public void updateInventory(SSInventory pInventory) {
        for (int i = 0; i < this.iInventories.size(); ++i) {
            SSInventory iInventory = this.iInventories.get(i);
            if (!iInventory.getNumber().equals(pInventory.getNumber())) continue;
            this.iInventories.remove(i);
            this.iInventories.add(i, pInventory);
        }
    }

    public List<SSIndelivery> getIndeliveries() {
        if (this.iIndeliveries == null) {
            this.iIndeliveries = new LinkedList<SSIndelivery>();
        }
        return this.iIndeliveries;
    }

    public void setIndeliveries(List<SSIndelivery> iIndeliveries) {
        this.iIndeliveries = iIndeliveries;
    }

    public void updateIndelivery(SSIndelivery pIndelivery) {
        for (int i = 0; i < this.iIndeliveries.size(); ++i) {
            SSIndelivery iIndelivery = this.iIndeliveries.get(i);
            if (!iIndelivery.getNumber().equals(pIndelivery.getNumber())) continue;
            this.iIndeliveries.remove(i);
            this.iIndeliveries.add(i, pIndelivery);
        }
    }

    public List<SSOutdelivery> getOutdeliveries() {
        if (this.iOutdeliveries == null) {
            this.iOutdeliveries = new LinkedList<SSOutdelivery>();
        }
        return this.iOutdeliveries;
    }

    public void setOutdeliveries(List<SSOutdelivery> iOutdeliveries) {
        this.iOutdeliveries = iOutdeliveries;
    }

    public void updateOutdelivery(SSOutdelivery pOutdelivery) {
        for (int i = 0; i < this.iOutdeliveries.size(); ++i) {
            SSOutdelivery iOutdelivery = this.iOutdeliveries.get(i);
            if (!iOutdelivery.getNumber().equals(pOutdelivery.getNumber())) continue;
            this.iOutdeliveries.remove(i);
            this.iOutdeliveries.add(i, pOutdelivery);
        }
    }

    public SSAutoIncrement getAutoIncrement() {
        if (this.iAutoIncrement == null) {
            this.iAutoIncrement = new SSAutoIncrement();
        }
        return this.iAutoIncrement;
    }

    public Image getLogoImage() {
        if (this.iLogotype == null) {
            return null;
        }
        File iFile = new File(this.iLogotype);
        if (!iFile.exists()) {
            return null;
        }
        BufferedImage iImage = null;
        try {
            iImage = ImageIO.read(iFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return iImage;
    }

    public int hashCode() {
        return this.iId.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSCompany)) {
            return false;
        }
        return this.iId.equals(((SSCompany)obj).iId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iName);
        return sb.toString();
    }
}

