/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data;

import java.io.Serializable;
import java.math.BigDecimal;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSAddress;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;

public class SSCustomer
implements Serializable,
SSTableSearchable {
    static final long serialVersionUID = 1L;
    private String iCustomerNr;
    private String iName;
    private String iEMail;
    private String iPhone;
    private String iPhone2;
    private String iTelefax;
    private String iRegistrationNumber;
    private String iOurContactPerson;
    private String iYourContactPerson;
    private String iVATNumber;
    private String iBankAccountNumber;
    private String iPlusAccountNumber;
    private String iAccountNumber;
    private String iClearingNumber;
    private boolean iEuSaleCommodity;
    private boolean iEuSaleYhirdPartCommodity;
    private boolean iVatFreeSale;
    private boolean iHideUnitprice;
    private SSCurrency iInvoiceCurrency;
    private SSPaymentTerm iPaymentTerm;
    private SSDeliveryTerm iDeliveryTerm;
    private SSDeliveryWay iDeliveryWay;
    private BigDecimal iCreditLimit;
    private BigDecimal iDiscount;
    private SSAddress iInvoiceAddress;
    private SSAddress iDeliveryAddress;
    private String iComment;

    public SSCustomer() {
        this.iInvoiceAddress = new SSAddress();
        this.iDeliveryAddress = new SSAddress();
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.iOurContactPerson = iCompany.getContactPerson();
            this.iInvoiceCurrency = iCompany.getCurrency();
            this.iPaymentTerm = iCompany.getPaymentTerm();
            this.iDeliveryTerm = iCompany.getDeliveryTerm();
            this.iDeliveryWay = iCompany.getDeliveryWay();
        }
    }

    public SSCustomer(SSCustomer iCustomer) {
        this.iCustomerNr = iCustomer.iCustomerNr;
        this.iName = iCustomer.iName;
        this.iEMail = iCustomer.iEMail;
        this.iPhone = iCustomer.iPhone;
        this.iPhone2 = iCustomer.iPhone2;
        this.iTelefax = iCustomer.iTelefax;
        this.iRegistrationNumber = iCustomer.iRegistrationNumber;
        this.iOurContactPerson = iCustomer.iOurContactPerson;
        this.iYourContactPerson = iCustomer.iYourContactPerson;
        this.iVATNumber = iCustomer.iVATNumber;
        this.iBankAccountNumber = iCustomer.iBankAccountNumber;
        this.iPlusAccountNumber = iCustomer.iPlusAccountNumber;
        this.iAccountNumber = iCustomer.iAccountNumber;
        this.iClearingNumber = iCustomer.iClearingNumber;
        this.iEuSaleCommodity = iCustomer.iEuSaleCommodity;
        this.iEuSaleYhirdPartCommodity = iCustomer.iEuSaleYhirdPartCommodity;
        this.iVatFreeSale = iCustomer.iVatFreeSale;
        this.iHideUnitprice = iCustomer.iHideUnitprice;
        this.iInvoiceCurrency = iCustomer.iInvoiceCurrency;
        this.iPaymentTerm = iCustomer.iPaymentTerm;
        this.iDeliveryTerm = iCustomer.iDeliveryTerm;
        this.iDeliveryWay = iCustomer.iDeliveryWay;
        this.iCreditLimit = iCustomer.iCreditLimit;
        this.iDiscount = iCustomer.iDiscount;
        this.iInvoiceAddress = new SSAddress(iCustomer.iInvoiceAddress);
        this.iDeliveryAddress = new SSAddress(iCustomer.iDeliveryAddress);
    }

    public String getNumber() {
        return this.iCustomerNr;
    }

    public void setNumber(String iNumber) {
        this.iCustomerNr = iNumber;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String iName) {
        this.iName = iName;
    }

    public String getEMail() {
        return this.iEMail;
    }

    public void setEMail(String iEMail) {
        this.iEMail = iEMail;
    }

    public String getPhone1() {
        return this.iPhone;
    }

    public void setPhone1(String iPhone) {
        this.iPhone = iPhone;
    }

    public String getPhone2() {
        return this.iPhone2;
    }

    public void setPhone2(String iPhone2) {
        this.iPhone2 = iPhone2;
    }

    public String getTelefax() {
        return this.iTelefax;
    }

    public void setTelefax(String iTelefax) {
        this.iTelefax = iTelefax;
    }

    public String getRegistrationNumber() {
        return this.iRegistrationNumber;
    }

    public void setRegistrationNumber(String iRegistrationNumber) {
        this.iRegistrationNumber = iRegistrationNumber;
    }

    public String getOurContactPerson() {
        return this.iOurContactPerson;
    }

    public void setOurContactPerson(String iOurContactPerson) {
        this.iOurContactPerson = iOurContactPerson;
    }

    public String getYourContactPerson() {
        return this.iYourContactPerson;
    }

    public void setYourContactPerson(String iYourContactPerson) {
        this.iYourContactPerson = iYourContactPerson;
    }

    public String getVATNumber() {
        return this.iVATNumber;
    }

    public void setVATNumber(String iVATNumber) {
        this.iVATNumber = iVATNumber;
    }

    public String getBankgiro() {
        return this.iBankAccountNumber;
    }

    public void setBankgiro(String iBankAccountNumber) {
        this.iBankAccountNumber = iBankAccountNumber;
    }

    public String getPlusgiro() {
        return this.iPlusAccountNumber;
    }

    public void setPlusgiro(String iPlusAccountNumber) {
        this.iPlusAccountNumber = iPlusAccountNumber;
    }

    public String getAccountNumber() {
        return this.iAccountNumber;
    }

    public void setAccountNumber(String iAccountNumber) {
        this.iAccountNumber = iAccountNumber;
    }

    public String getClearingNumber() {
        return this.iClearingNumber;
    }

    public void setClearingNumber(String iClearingNumber) {
        this.iClearingNumber = iClearingNumber;
    }

    public boolean getEuSaleCommodity() {
        return this.iEuSaleCommodity;
    }

    public void setEuSaleCommodity(boolean iEuSaleCommodity) {
        this.iEuSaleCommodity = iEuSaleCommodity;
    }

    public boolean getEuSaleYhirdPartCommodity() {
        return this.iEuSaleYhirdPartCommodity;
    }

    public void setEuSaleYhirdPartCommodity(boolean iEuSaleYhirdPartCommodity) {
        this.iEuSaleYhirdPartCommodity = iEuSaleYhirdPartCommodity;
    }

    public boolean getHideUnitprice() {
        return this.iHideUnitprice;
    }

    public void setHideUnitprice(boolean iHideUnitprice) {
        this.iHideUnitprice = iHideUnitprice;
    }

    public boolean getTaxFree() {
        return this.iVatFreeSale;
    }

    public void setTaxFree(boolean iTaxFree) {
        this.iVatFreeSale = iTaxFree;
    }

    public SSCurrency getInvoiceCurrency() {
        return SSDB.getInstance().getCurrency(this.iInvoiceCurrency);
    }

    public void setInvoiceCurrency(SSCurrency iInvoiceCurrency) {
        this.iInvoiceCurrency = iInvoiceCurrency;
    }

    public SSPaymentTerm getPaymentTerm() {
        return this.iPaymentTerm;
    }

    public void setPaymentTerm(SSPaymentTerm iPaymentTerm) {
        this.iPaymentTerm = iPaymentTerm;
    }

    public SSDeliveryTerm getDeliveryTerm() {
        return this.iDeliveryTerm;
    }

    public void setDeliveryTerm(SSDeliveryTerm iDeliveryTerm) {
        this.iDeliveryTerm = iDeliveryTerm;
    }

    public SSDeliveryWay getDeliveryWay() {
        return this.iDeliveryWay;
    }

    public void setDeliveryWay(SSDeliveryWay iDeliveryWay) {
        this.iDeliveryWay = iDeliveryWay;
    }

    public BigDecimal getCreditLimit() {
        return this.iCreditLimit;
    }

    public void setCreditLimit(BigDecimal iCreditLimit) {
        this.iCreditLimit = iCreditLimit;
    }

    public BigDecimal getDiscount() {
        return this.iDiscount;
    }

    public void setDiscount(BigDecimal iDiscount) {
        this.iDiscount = iDiscount;
    }

    public SSAddress getInvoiceAddress() {
        return this.iInvoiceAddress;
    }

    public void setInvoiceAddress(SSAddress iInvoiceAddress) {
        this.iInvoiceAddress = iInvoiceAddress;
    }

    public SSAddress getDeliveryAddress() {
        return this.iDeliveryAddress;
    }

    public String getComment() {
        return this.iComment;
    }

    public void setComment(String iComment) {
        this.iComment = iComment;
    }

    public void setDeliveryAddress(SSAddress iDeliveryAddress) {
        this.iDeliveryAddress = iDeliveryAddress;
    }

    public boolean equals(Object obj) {
        if (this.iCustomerNr == null) {
            return false;
        }
        if (obj instanceof SSCustomer) {
            SSCustomer iCustomer = (SSCustomer)obj;
            return this.iCustomerNr.equals(iCustomer.iCustomerNr);
        }
        return false;
    }

    @Override
    public String toRenderString() {
        return this.iCustomerNr;
    }

    public int hashCode() {
        return this.iCustomerNr == null ? super.hashCode() : this.iCustomerNr.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.iCustomerNr);
        sb.append(", ");
        sb.append(this.iName);
        return sb.toString();
    }

    public BigDecimal getCustomerRevenueForMonth(SSMonth iMonth) {
        Double iInvoiceSum = 0.0;
        for (SSInvoice iInvoice : SSDB.getInstance().getInvoices()) {
            if (!iMonth.isDateInMonth(iInvoice.getDate()) || iInvoice.getCustomerNr() == null || !iInvoice.getCustomerNr().equals(this.iCustomerNr)) continue;
            iInvoiceSum = iInvoiceSum + SSInvoiceMath.getNetSum(iInvoice).doubleValue() * iInvoice.getCurrencyRate().doubleValue();
        }
        Double iCreditInvoiceSum = 0.0;
        for (SSCreditInvoice iCreditInvoice : SSDB.getInstance().getCreditInvoices()) {
            if (!iMonth.isDateInMonth(iCreditInvoice.getDate()) || iCreditInvoice.getCustomerNr() == null || !iCreditInvoice.getCustomerNr().equals(this.iCustomerNr)) continue;
            iCreditInvoiceSum = iCreditInvoiceSum + SSInvoiceMath.getNetSum(iCreditInvoice).doubleValue() * iCreditInvoice.getCurrencyRate().doubleValue();
        }
        return new BigDecimal(iInvoiceSum - iCreditInvoiceSum);
    }
}

